/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cleanrooms.model.CleanRoomsRequest;
import software.amazon.awssdk.services.cleanrooms.model.ProtectedJobComputeConfiguration;
import software.amazon.awssdk.services.cleanrooms.model.ProtectedJobParameters;
import software.amazon.awssdk.services.cleanrooms.model.ProtectedJobResultConfigurationInput;
import software.amazon.awssdk.services.cleanrooms.model.ProtectedJobType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartProtectedJobRequest
extends CleanRoomsRequest
implements ToCopyableBuilder<Builder, StartProtectedJobRequest> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(StartProtectedJobRequest.getter(StartProtectedJobRequest::typeAsString)).setter(StartProtectedJobRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipIdentifier").getter(StartProtectedJobRequest.getter(StartProtectedJobRequest::membershipIdentifier)).setter(StartProtectedJobRequest.setter(Builder::membershipIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("membershipIdentifier").build()}).build();
    private static final SdkField<ProtectedJobParameters> JOB_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("jobParameters").getter(StartProtectedJobRequest.getter(StartProtectedJobRequest::jobParameters)).setter(StartProtectedJobRequest.setter(Builder::jobParameters)).constructor(ProtectedJobParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobParameters").build()}).build();
    private static final SdkField<ProtectedJobResultConfigurationInput> RESULT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resultConfiguration").getter(StartProtectedJobRequest.getter(StartProtectedJobRequest::resultConfiguration)).setter(StartProtectedJobRequest.setter(Builder::resultConfiguration)).constructor(ProtectedJobResultConfigurationInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resultConfiguration").build()}).build();
    private static final SdkField<ProtectedJobComputeConfiguration> COMPUTE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("computeConfiguration").getter(StartProtectedJobRequest.getter(StartProtectedJobRequest::computeConfiguration)).setter(StartProtectedJobRequest.setter(Builder::computeConfiguration)).constructor(ProtectedJobComputeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, MEMBERSHIP_IDENTIFIER_FIELD, JOB_PARAMETERS_FIELD, RESULT_CONFIGURATION_FIELD, COMPUTE_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartProtectedJobRequest.memberNameToFieldInitializer();
    private final String type;
    private final String membershipIdentifier;
    private final ProtectedJobParameters jobParameters;
    private final ProtectedJobResultConfigurationInput resultConfiguration;
    private final ProtectedJobComputeConfiguration computeConfiguration;

    private StartProtectedJobRequest(BuilderImpl builder) {
        super(builder);
        this.type = builder.type;
        this.membershipIdentifier = builder.membershipIdentifier;
        this.jobParameters = builder.jobParameters;
        this.resultConfiguration = builder.resultConfiguration;
        this.computeConfiguration = builder.computeConfiguration;
    }

    public final ProtectedJobType type() {
        return ProtectedJobType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String membershipIdentifier() {
        return this.membershipIdentifier;
    }

    public final ProtectedJobParameters jobParameters() {
        return this.jobParameters;
    }

    public final ProtectedJobResultConfigurationInput resultConfiguration() {
        return this.resultConfiguration;
    }

    public final ProtectedJobComputeConfiguration computeConfiguration() {
        return this.computeConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartProtectedJobRequest)) {
            return false;
        }
        StartProtectedJobRequest other = (StartProtectedJobRequest)((Object)obj);
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.membershipIdentifier(), other.membershipIdentifier()) && Objects.equals(this.jobParameters(), other.jobParameters()) && Objects.equals(this.resultConfiguration(), other.resultConfiguration()) && Objects.equals(this.computeConfiguration(), other.computeConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"StartProtectedJobRequest").add("Type", (Object)this.typeAsString()).add("MembershipIdentifier", (Object)this.membershipIdentifier()).add("JobParameters", (Object)this.jobParameters()).add("ResultConfiguration", (Object)this.resultConfiguration()).add("ComputeConfiguration", (Object)this.computeConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "membershipIdentifier": {
                return Optional.ofNullable(clazz.cast(this.membershipIdentifier()));
            }
            case "jobParameters": {
                return Optional.ofNullable(clazz.cast(this.jobParameters()));
            }
            case "resultConfiguration": {
                return Optional.ofNullable(clazz.cast(this.resultConfiguration()));
            }
            case "computeConfiguration": {
                return Optional.ofNullable(clazz.cast(this.computeConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", TYPE_FIELD);
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        map.put("jobParameters", JOB_PARAMETERS_FIELD);
        map.put("resultConfiguration", RESULT_CONFIGURATION_FIELD);
        map.put("computeConfiguration", COMPUTE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartProtectedJobRequest, T> g) {
        return obj -> g.apply((StartProtectedJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsRequest.BuilderImpl
    implements Builder {
        private String type;
        private String membershipIdentifier;
        private ProtectedJobParameters jobParameters;
        private ProtectedJobResultConfigurationInput resultConfiguration;
        private ProtectedJobComputeConfiguration computeConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(StartProtectedJobRequest model) {
            super(model);
            this.type(model.type);
            this.membershipIdentifier(model.membershipIdentifier);
            this.jobParameters(model.jobParameters);
            this.resultConfiguration(model.resultConfiguration);
            this.computeConfiguration(model.computeConfiguration);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ProtectedJobType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getMembershipIdentifier() {
            return this.membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final ProtectedJobParameters.Builder getJobParameters() {
            return this.jobParameters != null ? this.jobParameters.toBuilder() : null;
        }

        public final void setJobParameters(ProtectedJobParameters.BuilderImpl jobParameters) {
            this.jobParameters = jobParameters != null ? jobParameters.build() : null;
        }

        @Override
        public final Builder jobParameters(ProtectedJobParameters jobParameters) {
            this.jobParameters = jobParameters;
            return this;
        }

        public final ProtectedJobResultConfigurationInput.Builder getResultConfiguration() {
            return this.resultConfiguration != null ? this.resultConfiguration.toBuilder() : null;
        }

        public final void setResultConfiguration(ProtectedJobResultConfigurationInput.BuilderImpl resultConfiguration) {
            this.resultConfiguration = resultConfiguration != null ? resultConfiguration.build() : null;
        }

        @Override
        public final Builder resultConfiguration(ProtectedJobResultConfigurationInput resultConfiguration) {
            this.resultConfiguration = resultConfiguration;
            return this;
        }

        public final ProtectedJobComputeConfiguration.Builder getComputeConfiguration() {
            return this.computeConfiguration != null ? this.computeConfiguration.toBuilder() : null;
        }

        public final void setComputeConfiguration(ProtectedJobComputeConfiguration.BuilderImpl computeConfiguration) {
            this.computeConfiguration = computeConfiguration != null ? computeConfiguration.build() : null;
        }

        @Override
        public final Builder computeConfiguration(ProtectedJobComputeConfiguration computeConfiguration) {
            this.computeConfiguration = computeConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartProtectedJobRequest build() {
            return new StartProtectedJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CleanRoomsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartProtectedJobRequest> {
        public Builder type(String var1);

        public Builder type(ProtectedJobType var1);

        public Builder membershipIdentifier(String var1);

        public Builder jobParameters(ProtectedJobParameters var1);

        default public Builder jobParameters(Consumer<ProtectedJobParameters.Builder> jobParameters) {
            return this.jobParameters((ProtectedJobParameters)((ProtectedJobParameters.Builder)ProtectedJobParameters.builder().applyMutation(jobParameters)).build());
        }

        public Builder resultConfiguration(ProtectedJobResultConfigurationInput var1);

        default public Builder resultConfiguration(Consumer<ProtectedJobResultConfigurationInput.Builder> resultConfiguration) {
            return this.resultConfiguration((ProtectedJobResultConfigurationInput)((ProtectedJobResultConfigurationInput.Builder)ProtectedJobResultConfigurationInput.builder().applyMutation(resultConfiguration)).build());
        }

        public Builder computeConfiguration(ProtectedJobComputeConfiguration var1);

        default public Builder computeConfiguration(Consumer<ProtectedJobComputeConfiguration.Builder> computeConfiguration) {
            return this.computeConfiguration((ProtectedJobComputeConfiguration)((ProtectedJobComputeConfiguration.Builder)ProtectedJobComputeConfiguration.builder().applyMutation(computeConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

