/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanrooms.CleanRoomsAsyncClient;
import software.amazon.awssdk.services.cleanrooms.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanrooms.model.ListPrivacyBudgetsRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListPrivacyBudgetsResponse;
import software.amazon.awssdk.services.cleanrooms.model.PrivacyBudgetSummary;

public class ListPrivacyBudgetsPublisher
implements SdkPublisher<ListPrivacyBudgetsResponse> {
    private final CleanRoomsAsyncClient client;
    private final ListPrivacyBudgetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPrivacyBudgetsPublisher(CleanRoomsAsyncClient client, ListPrivacyBudgetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPrivacyBudgetsPublisher(CleanRoomsAsyncClient client, ListPrivacyBudgetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPrivacyBudgetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPrivacyBudgetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PrivacyBudgetSummary> privacyBudgetSummaries() {
        Function<ListPrivacyBudgetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.privacyBudgetSummaries() != null) {
                return response.privacyBudgetSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPrivacyBudgetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPrivacyBudgetsResponseFetcher
    implements AsyncPageFetcher<ListPrivacyBudgetsResponse> {
        private ListPrivacyBudgetsResponseFetcher() {
        }

        public boolean hasNextPage(ListPrivacyBudgetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPrivacyBudgetsResponse> nextPage(ListPrivacyBudgetsResponse previousPage) {
            if (previousPage == null) {
                return ListPrivacyBudgetsPublisher.this.client.listPrivacyBudgets(ListPrivacyBudgetsPublisher.this.firstRequest);
            }
            return ListPrivacyBudgetsPublisher.this.client.listPrivacyBudgets((ListPrivacyBudgetsRequest)((Object)ListPrivacyBudgetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

