/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanrooms.CleanRoomsClient;
import software.amazon.awssdk.services.cleanrooms.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanrooms.model.CollaborationIdNamespaceAssociationSummary;
import software.amazon.awssdk.services.cleanrooms.model.ListCollaborationIdNamespaceAssociationsRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListCollaborationIdNamespaceAssociationsResponse;

public class ListCollaborationIdNamespaceAssociationsIterable
implements SdkIterable<ListCollaborationIdNamespaceAssociationsResponse> {
    private final CleanRoomsClient client;
    private final ListCollaborationIdNamespaceAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCollaborationIdNamespaceAssociationsIterable(CleanRoomsClient client, ListCollaborationIdNamespaceAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCollaborationIdNamespaceAssociationsResponseFetcher();
    }

    public Iterator<ListCollaborationIdNamespaceAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CollaborationIdNamespaceAssociationSummary> collaborationIdNamespaceAssociationSummaries() {
        Function<ListCollaborationIdNamespaceAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.collaborationIdNamespaceAssociationSummaries() != null) {
                return response.collaborationIdNamespaceAssociationSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCollaborationIdNamespaceAssociationsResponseFetcher
    implements SyncPageFetcher<ListCollaborationIdNamespaceAssociationsResponse> {
        private ListCollaborationIdNamespaceAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListCollaborationIdNamespaceAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCollaborationIdNamespaceAssociationsResponse nextPage(ListCollaborationIdNamespaceAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListCollaborationIdNamespaceAssociationsIterable.this.client.listCollaborationIdNamespaceAssociations(ListCollaborationIdNamespaceAssociationsIterable.this.firstRequest);
            }
            return ListCollaborationIdNamespaceAssociationsIterable.this.client.listCollaborationIdNamespaceAssociations((ListCollaborationIdNamespaceAssociationsRequest)((Object)ListCollaborationIdNamespaceAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

