/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanrooms.CleanRoomsClient;
import software.amazon.awssdk.services.cleanrooms.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanrooms.model.CollaborationChangeRequestSummary;
import software.amazon.awssdk.services.cleanrooms.model.ListCollaborationChangeRequestsRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListCollaborationChangeRequestsResponse;

public class ListCollaborationChangeRequestsIterable
implements SdkIterable<ListCollaborationChangeRequestsResponse> {
    private final CleanRoomsClient client;
    private final ListCollaborationChangeRequestsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCollaborationChangeRequestsIterable(CleanRoomsClient client, ListCollaborationChangeRequestsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCollaborationChangeRequestsResponseFetcher();
    }

    public Iterator<ListCollaborationChangeRequestsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CollaborationChangeRequestSummary> collaborationChangeRequestSummaries() {
        Function<ListCollaborationChangeRequestsResponse, Iterator> getIterator = response -> {
            if (response != null && response.collaborationChangeRequestSummaries() != null) {
                return response.collaborationChangeRequestSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCollaborationChangeRequestsResponseFetcher
    implements SyncPageFetcher<ListCollaborationChangeRequestsResponse> {
        private ListCollaborationChangeRequestsResponseFetcher() {
        }

        public boolean hasNextPage(ListCollaborationChangeRequestsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCollaborationChangeRequestsResponse nextPage(ListCollaborationChangeRequestsResponse previousPage) {
            if (previousPage == null) {
                return ListCollaborationChangeRequestsIterable.this.client.listCollaborationChangeRequests(ListCollaborationChangeRequestsIterable.this.firstRequest);
            }
            return ListCollaborationChangeRequestsIterable.this.client.listCollaborationChangeRequests((ListCollaborationChangeRequestsRequest)((Object)ListCollaborationChangeRequestsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

