/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cleanrooms.model.ProtectedJobMemberOutputListCopier;
import software.amazon.awssdk.services.cleanrooms.model.ProtectedJobS3Output;
import software.amazon.awssdk.services.cleanrooms.model.ProtectedJobSingleMemberOutput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProtectedJobOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProtectedJobOutput> {
    private static final SdkField<ProtectedJobS3Output> S3_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3").getter(ProtectedJobOutput.getter(ProtectedJobOutput::s3)).setter(ProtectedJobOutput.setter(Builder::s3)).constructor(ProtectedJobS3Output::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3").build()}).build();
    private static final SdkField<List<ProtectedJobSingleMemberOutput>> MEMBER_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("memberList").getter(ProtectedJobOutput.getter(ProtectedJobOutput::memberList)).setter(ProtectedJobOutput.setter(Builder::memberList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProtectedJobSingleMemberOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_FIELD, MEMBER_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProtectedJobOutput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ProtectedJobS3Output s3;
    private final List<ProtectedJobSingleMemberOutput> memberList;
    private final Type type;

    private ProtectedJobOutput(BuilderImpl builder) {
        this.s3 = builder.s3;
        this.memberList = builder.memberList;
        this.type = builder.type;
    }

    public final ProtectedJobS3Output s3() {
        return this.s3;
    }

    public final boolean hasMemberList() {
        return this.memberList != null && !(this.memberList instanceof SdkAutoConstructList);
    }

    public final List<ProtectedJobSingleMemberOutput> memberList() {
        return this.memberList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMemberList() ? this.memberList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtectedJobOutput)) {
            return false;
        }
        ProtectedJobOutput other = (ProtectedJobOutput)obj;
        return Objects.equals(this.s3(), other.s3()) && this.hasMemberList() == other.hasMemberList() && Objects.equals(this.memberList(), other.memberList());
    }

    public final String toString() {
        return ToString.builder((String)"ProtectedJobOutput").add("S3", (Object)this.s3()).add("MemberList", this.hasMemberList() ? this.memberList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "s3": {
                return Optional.ofNullable(clazz.cast(this.s3()));
            }
            case "memberList": {
                return Optional.ofNullable(clazz.cast(this.memberList()));
            }
        }
        return Optional.empty();
    }

    public static ProtectedJobOutput fromS3(ProtectedJobS3Output s3) {
        return (ProtectedJobOutput)ProtectedJobOutput.builder().s3(s3).build();
    }

    public static ProtectedJobOutput fromS3(Consumer<ProtectedJobS3Output.Builder> s3) {
        ProtectedJobS3Output.Builder builder = ProtectedJobS3Output.builder();
        s3.accept(builder);
        return ProtectedJobOutput.fromS3((ProtectedJobS3Output)builder.build());
    }

    public static ProtectedJobOutput fromMemberList(List<ProtectedJobSingleMemberOutput> memberList) {
        return (ProtectedJobOutput)ProtectedJobOutput.builder().memberList(memberList).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("s3", S3_FIELD);
        map.put("memberList", MEMBER_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProtectedJobOutput, T> g) {
        return obj -> g.apply((ProtectedJobOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        S3,
        MEMBER_LIST,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private ProtectedJobS3Output s3;
        private List<ProtectedJobSingleMemberOutput> memberList = DefaultSdkAutoConstructList.getInstance();
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ProtectedJobOutput model) {
            this.s3(model.s3);
            this.memberList(model.memberList);
        }

        public final ProtectedJobS3Output.Builder getS3() {
            return this.s3 != null ? this.s3.toBuilder() : null;
        }

        public final void setS3(ProtectedJobS3Output.BuilderImpl s3) {
            ProtectedJobS3Output oldValue = this.s3;
            this.s3 = s3 != null ? s3.build() : null;
            this.handleUnionValueChange(Type.S3, oldValue, this.s3);
        }

        @Override
        public final Builder s3(ProtectedJobS3Output s3) {
            ProtectedJobS3Output oldValue = this.s3;
            this.s3 = s3;
            this.handleUnionValueChange(Type.S3, oldValue, this.s3);
            return this;
        }

        public final List<ProtectedJobSingleMemberOutput.Builder> getMemberList() {
            List<ProtectedJobSingleMemberOutput.Builder> result = ProtectedJobMemberOutputListCopier.copyToBuilder(this.memberList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMemberList(Collection<ProtectedJobSingleMemberOutput.BuilderImpl> memberList) {
            List<ProtectedJobSingleMemberOutput> oldValue = this.memberList;
            this.memberList = ProtectedJobMemberOutputListCopier.copyFromBuilder(memberList);
            this.handleUnionValueChange(Type.MEMBER_LIST, oldValue, this.memberList);
        }

        @Override
        public final Builder memberList(Collection<ProtectedJobSingleMemberOutput> memberList) {
            List<ProtectedJobSingleMemberOutput> oldValue = this.memberList;
            this.memberList = ProtectedJobMemberOutputListCopier.copy(memberList);
            this.handleUnionValueChange(Type.MEMBER_LIST, oldValue, this.memberList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberList(ProtectedJobSingleMemberOutput ... memberList) {
            this.memberList(Arrays.asList(memberList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberList(Consumer<ProtectedJobSingleMemberOutput.Builder> ... memberList) {
            this.memberList(Stream.of(memberList).map(c -> (ProtectedJobSingleMemberOutput)((ProtectedJobSingleMemberOutput.Builder)ProtectedJobSingleMemberOutput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ProtectedJobOutput build() {
            return new ProtectedJobOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProtectedJobOutput> {
        public Builder s3(ProtectedJobS3Output var1);

        default public Builder s3(Consumer<ProtectedJobS3Output.Builder> s3) {
            return this.s3((ProtectedJobS3Output)((ProtectedJobS3Output.Builder)ProtectedJobS3Output.builder().applyMutation(s3)).build());
        }

        public Builder memberList(Collection<ProtectedJobSingleMemberOutput> var1);

        public Builder memberList(ProtectedJobSingleMemberOutput ... var1);

        public Builder memberList(Consumer<ProtectedJobSingleMemberOutput.Builder> ... var1);
    }
}

