/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ErrorMessageType {
    DETAILED("DETAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ErrorMessageType> VALUE_MAP;
    private final String value;

    private ErrorMessageType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ErrorMessageType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ErrorMessageType> knownValues() {
        EnumSet<ErrorMessageType> knownValues = EnumSet.allOf(ErrorMessageType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ErrorMessageType.class, ErrorMessageType::toString);
    }
}

