/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisFormat;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisParameter;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisParameterListCopier;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisSchema;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisSource;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisSourceMetadata;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisTemplateValidationStatusDetail;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisTemplateValidationStatusDetailListCopier;
import software.amazon.awssdk.services.cleanrooms.model.ErrorMessageConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CollaborationAnalysisTemplate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CollaborationAnalysisTemplate> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(CollaborationAnalysisTemplate.getter(CollaborationAnalysisTemplate::id)).setter(CollaborationAnalysisTemplate.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(CollaborationAnalysisTemplate.getter(CollaborationAnalysisTemplate::arn)).setter(CollaborationAnalysisTemplate.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> COLLABORATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("collaborationId").getter(CollaborationAnalysisTemplate.getter(CollaborationAnalysisTemplate::collaborationId)).setter(CollaborationAnalysisTemplate.setter(Builder::collaborationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationId").build()}).build();
    private static final SdkField<String> COLLABORATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("collaborationArn").getter(CollaborationAnalysisTemplate.getter(CollaborationAnalysisTemplate::collaborationArn)).setter(CollaborationAnalysisTemplate.setter(Builder::collaborationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CollaborationAnalysisTemplate.getter(CollaborationAnalysisTemplate::description)).setter(CollaborationAnalysisTemplate.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> CREATOR_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("creatorAccountId").getter(CollaborationAnalysisTemplate.getter(CollaborationAnalysisTemplate::creatorAccountId)).setter(CollaborationAnalysisTemplate.setter(Builder::creatorAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creatorAccountId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CollaborationAnalysisTemplate.getter(CollaborationAnalysisTemplate::name)).setter(CollaborationAnalysisTemplate.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createTime").getter(CollaborationAnalysisTemplate.getter(CollaborationAnalysisTemplate::createTime)).setter(CollaborationAnalysisTemplate.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateTime").getter(CollaborationAnalysisTemplate.getter(CollaborationAnalysisTemplate::updateTime)).setter(CollaborationAnalysisTemplate.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build()}).build();
    private static final SdkField<AnalysisSchema> SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("schema").getter(CollaborationAnalysisTemplate.getter(CollaborationAnalysisTemplate::schema)).setter(CollaborationAnalysisTemplate.setter(Builder::schema)).constructor(AnalysisSchema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schema").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("format").getter(CollaborationAnalysisTemplate.getter(CollaborationAnalysisTemplate::formatAsString)).setter(CollaborationAnalysisTemplate.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()}).build();
    private static final SdkField<AnalysisSource> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("source").getter(CollaborationAnalysisTemplate.getter(CollaborationAnalysisTemplate::source)).setter(CollaborationAnalysisTemplate.setter(Builder::source)).constructor(AnalysisSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<AnalysisSourceMetadata> SOURCE_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sourceMetadata").getter(CollaborationAnalysisTemplate.getter(CollaborationAnalysisTemplate::sourceMetadata)).setter(CollaborationAnalysisTemplate.setter(Builder::sourceMetadata)).constructor(AnalysisSourceMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceMetadata").build()}).build();
    private static final SdkField<List<AnalysisParameter>> ANALYSIS_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("analysisParameters").getter(CollaborationAnalysisTemplate.getter(CollaborationAnalysisTemplate::analysisParameters)).setter(CollaborationAnalysisTemplate.setter(Builder::analysisParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnalysisParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AnalysisTemplateValidationStatusDetail>> VALIDATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("validations").getter(CollaborationAnalysisTemplate.getter(CollaborationAnalysisTemplate::validations)).setter(CollaborationAnalysisTemplate.setter(Builder::validations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnalysisTemplateValidationStatusDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ErrorMessageConfiguration> ERROR_MESSAGE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("errorMessageConfiguration").getter(CollaborationAnalysisTemplate.getter(CollaborationAnalysisTemplate::errorMessageConfiguration)).setter(CollaborationAnalysisTemplate.setter(Builder::errorMessageConfiguration)).constructor(ErrorMessageConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessageConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, COLLABORATION_ID_FIELD, COLLABORATION_ARN_FIELD, DESCRIPTION_FIELD, CREATOR_ACCOUNT_ID_FIELD, NAME_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD, SCHEMA_FIELD, FORMAT_FIELD, SOURCE_FIELD, SOURCE_METADATA_FIELD, ANALYSIS_PARAMETERS_FIELD, VALIDATIONS_FIELD, ERROR_MESSAGE_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CollaborationAnalysisTemplate.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String arn;
    private final String collaborationId;
    private final String collaborationArn;
    private final String description;
    private final String creatorAccountId;
    private final String name;
    private final Instant createTime;
    private final Instant updateTime;
    private final AnalysisSchema schema;
    private final String format;
    private final AnalysisSource source;
    private final AnalysisSourceMetadata sourceMetadata;
    private final List<AnalysisParameter> analysisParameters;
    private final List<AnalysisTemplateValidationStatusDetail> validations;
    private final ErrorMessageConfiguration errorMessageConfiguration;

    private CollaborationAnalysisTemplate(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.collaborationId = builder.collaborationId;
        this.collaborationArn = builder.collaborationArn;
        this.description = builder.description;
        this.creatorAccountId = builder.creatorAccountId;
        this.name = builder.name;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.schema = builder.schema;
        this.format = builder.format;
        this.source = builder.source;
        this.sourceMetadata = builder.sourceMetadata;
        this.analysisParameters = builder.analysisParameters;
        this.validations = builder.validations;
        this.errorMessageConfiguration = builder.errorMessageConfiguration;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String collaborationId() {
        return this.collaborationId;
    }

    public final String collaborationArn() {
        return this.collaborationArn;
    }

    public final String description() {
        return this.description;
    }

    public final String creatorAccountId() {
        return this.creatorAccountId;
    }

    public final String name() {
        return this.name;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public final AnalysisSchema schema() {
        return this.schema;
    }

    public final AnalysisFormat format() {
        return AnalysisFormat.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final AnalysisSource source() {
        return this.source;
    }

    public final AnalysisSourceMetadata sourceMetadata() {
        return this.sourceMetadata;
    }

    public final boolean hasAnalysisParameters() {
        return this.analysisParameters != null && !(this.analysisParameters instanceof SdkAutoConstructList);
    }

    public final List<AnalysisParameter> analysisParameters() {
        return this.analysisParameters;
    }

    public final boolean hasValidations() {
        return this.validations != null && !(this.validations instanceof SdkAutoConstructList);
    }

    public final List<AnalysisTemplateValidationStatusDetail> validations() {
        return this.validations;
    }

    public final ErrorMessageConfiguration errorMessageConfiguration() {
        return this.errorMessageConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.collaborationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.collaborationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.schema());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnalysisParameters() ? this.analysisParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValidations() ? this.validations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessageConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CollaborationAnalysisTemplate)) {
            return false;
        }
        CollaborationAnalysisTemplate other = (CollaborationAnalysisTemplate)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.collaborationId(), other.collaborationId()) && Objects.equals(this.collaborationArn(), other.collaborationArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.creatorAccountId(), other.creatorAccountId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.updateTime(), other.updateTime()) && Objects.equals(this.schema(), other.schema()) && Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.sourceMetadata(), other.sourceMetadata()) && this.hasAnalysisParameters() == other.hasAnalysisParameters() && Objects.equals(this.analysisParameters(), other.analysisParameters()) && this.hasValidations() == other.hasValidations() && Objects.equals(this.validations(), other.validations()) && Objects.equals(this.errorMessageConfiguration(), other.errorMessageConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"CollaborationAnalysisTemplate").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("CollaborationId", (Object)this.collaborationId()).add("CollaborationArn", (Object)this.collaborationArn()).add("Description", (Object)this.description()).add("CreatorAccountId", (Object)this.creatorAccountId()).add("Name", (Object)this.name()).add("CreateTime", (Object)this.createTime()).add("UpdateTime", (Object)this.updateTime()).add("Schema", (Object)this.schema()).add("Format", (Object)this.formatAsString()).add("Source", (Object)this.source()).add("SourceMetadata", (Object)this.sourceMetadata()).add("AnalysisParameters", (Object)(this.analysisParameters() == null ? null : "*** Sensitive Data Redacted ***")).add("Validations", this.hasValidations() ? this.validations() : null).add("ErrorMessageConfiguration", (Object)this.errorMessageConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "collaborationId": {
                return Optional.ofNullable(clazz.cast(this.collaborationId()));
            }
            case "collaborationArn": {
                return Optional.ofNullable(clazz.cast(this.collaborationArn()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "creatorAccountId": {
                return Optional.ofNullable(clazz.cast(this.creatorAccountId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "updateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
            case "schema": {
                return Optional.ofNullable(clazz.cast(this.schema()));
            }
            case "format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "sourceMetadata": {
                return Optional.ofNullable(clazz.cast(this.sourceMetadata()));
            }
            case "analysisParameters": {
                return Optional.ofNullable(clazz.cast(this.analysisParameters()));
            }
            case "validations": {
                return Optional.ofNullable(clazz.cast(this.validations()));
            }
            case "errorMessageConfiguration": {
                return Optional.ofNullable(clazz.cast(this.errorMessageConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("collaborationId", COLLABORATION_ID_FIELD);
        map.put("collaborationArn", COLLABORATION_ARN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("creatorAccountId", CREATOR_ACCOUNT_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        map.put("schema", SCHEMA_FIELD);
        map.put("format", FORMAT_FIELD);
        map.put("source", SOURCE_FIELD);
        map.put("sourceMetadata", SOURCE_METADATA_FIELD);
        map.put("analysisParameters", ANALYSIS_PARAMETERS_FIELD);
        map.put("validations", VALIDATIONS_FIELD);
        map.put("errorMessageConfiguration", ERROR_MESSAGE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CollaborationAnalysisTemplate, T> g) {
        return obj -> g.apply((CollaborationAnalysisTemplate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String collaborationId;
        private String collaborationArn;
        private String description;
        private String creatorAccountId;
        private String name;
        private Instant createTime;
        private Instant updateTime;
        private AnalysisSchema schema;
        private String format;
        private AnalysisSource source;
        private AnalysisSourceMetadata sourceMetadata;
        private List<AnalysisParameter> analysisParameters = DefaultSdkAutoConstructList.getInstance();
        private List<AnalysisTemplateValidationStatusDetail> validations = DefaultSdkAutoConstructList.getInstance();
        private ErrorMessageConfiguration errorMessageConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CollaborationAnalysisTemplate model) {
            this.id(model.id);
            this.arn(model.arn);
            this.collaborationId(model.collaborationId);
            this.collaborationArn(model.collaborationArn);
            this.description(model.description);
            this.creatorAccountId(model.creatorAccountId);
            this.name(model.name);
            this.createTime(model.createTime);
            this.updateTime(model.updateTime);
            this.schema(model.schema);
            this.format(model.format);
            this.source(model.source);
            this.sourceMetadata(model.sourceMetadata);
            this.analysisParameters(model.analysisParameters);
            this.validations(model.validations);
            this.errorMessageConfiguration(model.errorMessageConfiguration);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCollaborationId() {
            return this.collaborationId;
        }

        public final void setCollaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
        }

        @Override
        public final Builder collaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
            return this;
        }

        public final String getCollaborationArn() {
            return this.collaborationArn;
        }

        public final void setCollaborationArn(String collaborationArn) {
            this.collaborationArn = collaborationArn;
        }

        @Override
        public final Builder collaborationArn(String collaborationArn) {
            this.collaborationArn = collaborationArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getCreatorAccountId() {
            return this.creatorAccountId;
        }

        public final void setCreatorAccountId(String creatorAccountId) {
            this.creatorAccountId = creatorAccountId;
        }

        @Override
        public final Builder creatorAccountId(String creatorAccountId) {
            this.creatorAccountId = creatorAccountId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final AnalysisSchema.Builder getSchema() {
            return this.schema != null ? this.schema.toBuilder() : null;
        }

        public final void setSchema(AnalysisSchema.BuilderImpl schema) {
            this.schema = schema != null ? schema.build() : null;
        }

        @Override
        public final Builder schema(AnalysisSchema schema) {
            this.schema = schema;
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(AnalysisFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final AnalysisSource.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(AnalysisSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(AnalysisSource source) {
            this.source = source;
            return this;
        }

        public final AnalysisSourceMetadata.Builder getSourceMetadata() {
            return this.sourceMetadata != null ? this.sourceMetadata.toBuilder() : null;
        }

        public final void setSourceMetadata(AnalysisSourceMetadata.BuilderImpl sourceMetadata) {
            this.sourceMetadata = sourceMetadata != null ? sourceMetadata.build() : null;
        }

        @Override
        public final Builder sourceMetadata(AnalysisSourceMetadata sourceMetadata) {
            this.sourceMetadata = sourceMetadata;
            return this;
        }

        public final List<AnalysisParameter.Builder> getAnalysisParameters() {
            List<AnalysisParameter.Builder> result = AnalysisParameterListCopier.copyToBuilder(this.analysisParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnalysisParameters(Collection<AnalysisParameter.BuilderImpl> analysisParameters) {
            this.analysisParameters = AnalysisParameterListCopier.copyFromBuilder(analysisParameters);
        }

        @Override
        public final Builder analysisParameters(Collection<AnalysisParameter> analysisParameters) {
            this.analysisParameters = AnalysisParameterListCopier.copy(analysisParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisParameters(AnalysisParameter ... analysisParameters) {
            this.analysisParameters(Arrays.asList(analysisParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisParameters(Consumer<AnalysisParameter.Builder> ... analysisParameters) {
            this.analysisParameters(Stream.of(analysisParameters).map(c -> (AnalysisParameter)((AnalysisParameter.Builder)AnalysisParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AnalysisTemplateValidationStatusDetail.Builder> getValidations() {
            List<AnalysisTemplateValidationStatusDetail.Builder> result = AnalysisTemplateValidationStatusDetailListCopier.copyToBuilder(this.validations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValidations(Collection<AnalysisTemplateValidationStatusDetail.BuilderImpl> validations) {
            this.validations = AnalysisTemplateValidationStatusDetailListCopier.copyFromBuilder(validations);
        }

        @Override
        public final Builder validations(Collection<AnalysisTemplateValidationStatusDetail> validations) {
            this.validations = AnalysisTemplateValidationStatusDetailListCopier.copy(validations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validations(AnalysisTemplateValidationStatusDetail ... validations) {
            this.validations(Arrays.asList(validations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validations(Consumer<AnalysisTemplateValidationStatusDetail.Builder> ... validations) {
            this.validations(Stream.of(validations).map(c -> (AnalysisTemplateValidationStatusDetail)((AnalysisTemplateValidationStatusDetail.Builder)AnalysisTemplateValidationStatusDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ErrorMessageConfiguration.Builder getErrorMessageConfiguration() {
            return this.errorMessageConfiguration != null ? this.errorMessageConfiguration.toBuilder() : null;
        }

        public final void setErrorMessageConfiguration(ErrorMessageConfiguration.BuilderImpl errorMessageConfiguration) {
            this.errorMessageConfiguration = errorMessageConfiguration != null ? errorMessageConfiguration.build() : null;
        }

        @Override
        public final Builder errorMessageConfiguration(ErrorMessageConfiguration errorMessageConfiguration) {
            this.errorMessageConfiguration = errorMessageConfiguration;
            return this;
        }

        public CollaborationAnalysisTemplate build() {
            return new CollaborationAnalysisTemplate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CollaborationAnalysisTemplate> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder collaborationId(String var1);

        public Builder collaborationArn(String var1);

        public Builder description(String var1);

        public Builder creatorAccountId(String var1);

        public Builder name(String var1);

        public Builder createTime(Instant var1);

        public Builder updateTime(Instant var1);

        public Builder schema(AnalysisSchema var1);

        default public Builder schema(Consumer<AnalysisSchema.Builder> schema) {
            return this.schema((AnalysisSchema)((AnalysisSchema.Builder)AnalysisSchema.builder().applyMutation(schema)).build());
        }

        public Builder format(String var1);

        public Builder format(AnalysisFormat var1);

        public Builder source(AnalysisSource var1);

        default public Builder source(Consumer<AnalysisSource.Builder> source) {
            return this.source((AnalysisSource)((AnalysisSource.Builder)AnalysisSource.builder().applyMutation(source)).build());
        }

        public Builder sourceMetadata(AnalysisSourceMetadata var1);

        default public Builder sourceMetadata(Consumer<AnalysisSourceMetadata.Builder> sourceMetadata) {
            return this.sourceMetadata((AnalysisSourceMetadata)((AnalysisSourceMetadata.Builder)AnalysisSourceMetadata.builder().applyMutation(sourceMetadata)).build());
        }

        public Builder analysisParameters(Collection<AnalysisParameter> var1);

        public Builder analysisParameters(AnalysisParameter ... var1);

        public Builder analysisParameters(Consumer<AnalysisParameter.Builder> ... var1);

        public Builder validations(Collection<AnalysisTemplateValidationStatusDetail> var1);

        public Builder validations(AnalysisTemplateValidationStatusDetail ... var1);

        public Builder validations(Consumer<AnalysisTemplateValidationStatusDetail.Builder> ... var1);

        public Builder errorMessageConfiguration(ErrorMessageConfiguration var1);

        default public Builder errorMessageConfiguration(Consumer<ErrorMessageConfiguration.Builder> errorMessageConfiguration) {
            return this.errorMessageConfiguration((ErrorMessageConfiguration)((ErrorMessageConfiguration.Builder)ErrorMessageConfiguration.builder().applyMutation(errorMessageConfiguration)).build());
        }
    }
}

