/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AnalysisRuleType {
    AGGREGATION("AGGREGATION"),
    LIST("LIST"),
    CUSTOM("CUSTOM"),
    ID_MAPPING_TABLE("ID_MAPPING_TABLE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AnalysisRuleType> VALUE_MAP;
    private final String value;

    private AnalysisRuleType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AnalysisRuleType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AnalysisRuleType> knownValues() {
        EnumSet<AnalysisRuleType> knownValues = EnumSet.allOf(AnalysisRuleType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AnalysisRuleType.class, AnalysisRuleType::toString);
    }
}

