/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisMethod;
import software.amazon.awssdk.services.cleanrooms.model.CleanRoomsRequest;
import software.amazon.awssdk.services.cleanrooms.model.SelectedAnalysisMethod;
import software.amazon.awssdk.services.cleanrooms.model.SelectedAnalysisMethodsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateConfiguredTableRequest
extends CleanRoomsRequest
implements ToCopyableBuilder<Builder, UpdateConfiguredTableRequest> {
    private static final SdkField<String> CONFIGURED_TABLE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configuredTableIdentifier").getter(UpdateConfiguredTableRequest.getter(UpdateConfiguredTableRequest::configuredTableIdentifier)).setter(UpdateConfiguredTableRequest.setter(Builder::configuredTableIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("configuredTableIdentifier").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateConfiguredTableRequest.getter(UpdateConfiguredTableRequest::name)).setter(UpdateConfiguredTableRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateConfiguredTableRequest.getter(UpdateConfiguredTableRequest::description)).setter(UpdateConfiguredTableRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ANALYSIS_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("analysisMethod").getter(UpdateConfiguredTableRequest.getter(UpdateConfiguredTableRequest::analysisMethodAsString)).setter(UpdateConfiguredTableRequest.setter(Builder::analysisMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisMethod").build()}).build();
    private static final SdkField<List<String>> SELECTED_ANALYSIS_METHODS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("selectedAnalysisMethods").getter(UpdateConfiguredTableRequest.getter(UpdateConfiguredTableRequest::selectedAnalysisMethodsAsStrings)).setter(UpdateConfiguredTableRequest.setter(Builder::selectedAnalysisMethodsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selectedAnalysisMethods").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURED_TABLE_IDENTIFIER_FIELD, NAME_FIELD, DESCRIPTION_FIELD, ANALYSIS_METHOD_FIELD, SELECTED_ANALYSIS_METHODS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateConfiguredTableRequest.memberNameToFieldInitializer();
    private final String configuredTableIdentifier;
    private final String name;
    private final String description;
    private final String analysisMethod;
    private final List<String> selectedAnalysisMethods;

    private UpdateConfiguredTableRequest(BuilderImpl builder) {
        super(builder);
        this.configuredTableIdentifier = builder.configuredTableIdentifier;
        this.name = builder.name;
        this.description = builder.description;
        this.analysisMethod = builder.analysisMethod;
        this.selectedAnalysisMethods = builder.selectedAnalysisMethods;
    }

    public final String configuredTableIdentifier() {
        return this.configuredTableIdentifier;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final AnalysisMethod analysisMethod() {
        return AnalysisMethod.fromValue(this.analysisMethod);
    }

    public final String analysisMethodAsString() {
        return this.analysisMethod;
    }

    public final List<SelectedAnalysisMethod> selectedAnalysisMethods() {
        return SelectedAnalysisMethodsCopier.copyStringToEnum(this.selectedAnalysisMethods);
    }

    public final boolean hasSelectedAnalysisMethods() {
        return this.selectedAnalysisMethods != null && !(this.selectedAnalysisMethods instanceof SdkAutoConstructList);
    }

    public final List<String> selectedAnalysisMethodsAsStrings() {
        return this.selectedAnalysisMethods;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configuredTableIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSelectedAnalysisMethods() ? this.selectedAnalysisMethodsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConfiguredTableRequest)) {
            return false;
        }
        UpdateConfiguredTableRequest other = (UpdateConfiguredTableRequest)((Object)obj);
        return Objects.equals(this.configuredTableIdentifier(), other.configuredTableIdentifier()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.analysisMethodAsString(), other.analysisMethodAsString()) && this.hasSelectedAnalysisMethods() == other.hasSelectedAnalysisMethods() && Objects.equals(this.selectedAnalysisMethodsAsStrings(), other.selectedAnalysisMethodsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateConfiguredTableRequest").add("ConfiguredTableIdentifier", (Object)this.configuredTableIdentifier()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("AnalysisMethod", (Object)this.analysisMethodAsString()).add("SelectedAnalysisMethods", this.hasSelectedAnalysisMethods() ? this.selectedAnalysisMethodsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "configuredTableIdentifier": {
                return Optional.ofNullable(clazz.cast(this.configuredTableIdentifier()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "analysisMethod": {
                return Optional.ofNullable(clazz.cast(this.analysisMethodAsString()));
            }
            case "selectedAnalysisMethods": {
                return Optional.ofNullable(clazz.cast(this.selectedAnalysisMethodsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("configuredTableIdentifier", CONFIGURED_TABLE_IDENTIFIER_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("analysisMethod", ANALYSIS_METHOD_FIELD);
        map.put("selectedAnalysisMethods", SELECTED_ANALYSIS_METHODS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateConfiguredTableRequest, T> g) {
        return obj -> g.apply((UpdateConfiguredTableRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsRequest.BuilderImpl
    implements Builder {
        private String configuredTableIdentifier;
        private String name;
        private String description;
        private String analysisMethod;
        private List<String> selectedAnalysisMethods = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConfiguredTableRequest model) {
            super(model);
            this.configuredTableIdentifier(model.configuredTableIdentifier);
            this.name(model.name);
            this.description(model.description);
            this.analysisMethod(model.analysisMethod);
            this.selectedAnalysisMethodsWithStrings(model.selectedAnalysisMethods);
        }

        public final String getConfiguredTableIdentifier() {
            return this.configuredTableIdentifier;
        }

        public final void setConfiguredTableIdentifier(String configuredTableIdentifier) {
            this.configuredTableIdentifier = configuredTableIdentifier;
        }

        @Override
        public final Builder configuredTableIdentifier(String configuredTableIdentifier) {
            this.configuredTableIdentifier = configuredTableIdentifier;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getAnalysisMethod() {
            return this.analysisMethod;
        }

        public final void setAnalysisMethod(String analysisMethod) {
            this.analysisMethod = analysisMethod;
        }

        @Override
        public final Builder analysisMethod(String analysisMethod) {
            this.analysisMethod = analysisMethod;
            return this;
        }

        @Override
        public final Builder analysisMethod(AnalysisMethod analysisMethod) {
            this.analysisMethod(analysisMethod == null ? null : analysisMethod.toString());
            return this;
        }

        public final Collection<String> getSelectedAnalysisMethods() {
            if (this.selectedAnalysisMethods instanceof SdkAutoConstructList) {
                return null;
            }
            return this.selectedAnalysisMethods;
        }

        public final void setSelectedAnalysisMethods(Collection<String> selectedAnalysisMethods) {
            this.selectedAnalysisMethods = SelectedAnalysisMethodsCopier.copy(selectedAnalysisMethods);
        }

        @Override
        public final Builder selectedAnalysisMethodsWithStrings(Collection<String> selectedAnalysisMethods) {
            this.selectedAnalysisMethods = SelectedAnalysisMethodsCopier.copy(selectedAnalysisMethods);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedAnalysisMethodsWithStrings(String ... selectedAnalysisMethods) {
            this.selectedAnalysisMethodsWithStrings(Arrays.asList(selectedAnalysisMethods));
            return this;
        }

        @Override
        public final Builder selectedAnalysisMethods(Collection<SelectedAnalysisMethod> selectedAnalysisMethods) {
            this.selectedAnalysisMethods = SelectedAnalysisMethodsCopier.copyEnumToString(selectedAnalysisMethods);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedAnalysisMethods(SelectedAnalysisMethod ... selectedAnalysisMethods) {
            this.selectedAnalysisMethods(Arrays.asList(selectedAnalysisMethods));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConfiguredTableRequest build() {
            return new UpdateConfiguredTableRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CleanRoomsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateConfiguredTableRequest> {
        public Builder configuredTableIdentifier(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder analysisMethod(String var1);

        public Builder analysisMethod(AnalysisMethod var1);

        public Builder selectedAnalysisMethodsWithStrings(Collection<String> var1);

        public Builder selectedAnalysisMethodsWithStrings(String ... var1);

        public Builder selectedAnalysisMethods(Collection<SelectedAnalysisMethod> var1);

        public Builder selectedAnalysisMethods(SelectedAnalysisMethod ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

