/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanrooms.model.CleanRoomsResponse;
import software.amazon.awssdk.services.cleanrooms.model.PrivacyBudgetTemplateSummary;
import software.amazon.awssdk.services.cleanrooms.model.PrivacyBudgetTemplateSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPrivacyBudgetTemplatesResponse
extends CleanRoomsResponse
implements ToCopyableBuilder<Builder, ListPrivacyBudgetTemplatesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListPrivacyBudgetTemplatesResponse.getter(ListPrivacyBudgetTemplatesResponse::nextToken)).setter(ListPrivacyBudgetTemplatesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<PrivacyBudgetTemplateSummary>> PRIVACY_BUDGET_TEMPLATE_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("privacyBudgetTemplateSummaries").getter(ListPrivacyBudgetTemplatesResponse.getter(ListPrivacyBudgetTemplatesResponse::privacyBudgetTemplateSummaries)).setter(ListPrivacyBudgetTemplatesResponse.setter(Builder::privacyBudgetTemplateSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privacyBudgetTemplateSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PrivacyBudgetTemplateSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, PRIVACY_BUDGET_TEMPLATE_SUMMARIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListPrivacyBudgetTemplatesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<PrivacyBudgetTemplateSummary> privacyBudgetTemplateSummaries;

    private ListPrivacyBudgetTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.privacyBudgetTemplateSummaries = builder.privacyBudgetTemplateSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasPrivacyBudgetTemplateSummaries() {
        return this.privacyBudgetTemplateSummaries != null && !(this.privacyBudgetTemplateSummaries instanceof SdkAutoConstructList);
    }

    public final List<PrivacyBudgetTemplateSummary> privacyBudgetTemplateSummaries() {
        return this.privacyBudgetTemplateSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrivacyBudgetTemplateSummaries() ? this.privacyBudgetTemplateSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPrivacyBudgetTemplatesResponse)) {
            return false;
        }
        ListPrivacyBudgetTemplatesResponse other = (ListPrivacyBudgetTemplatesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasPrivacyBudgetTemplateSummaries() == other.hasPrivacyBudgetTemplateSummaries() && Objects.equals(this.privacyBudgetTemplateSummaries(), other.privacyBudgetTemplateSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListPrivacyBudgetTemplatesResponse").add("NextToken", (Object)this.nextToken()).add("PrivacyBudgetTemplateSummaries", this.hasPrivacyBudgetTemplateSummaries() ? this.privacyBudgetTemplateSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "privacyBudgetTemplateSummaries": {
                return Optional.ofNullable(clazz.cast(this.privacyBudgetTemplateSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("privacyBudgetTemplateSummaries", PRIVACY_BUDGET_TEMPLATE_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPrivacyBudgetTemplatesResponse, T> g) {
        return obj -> g.apply((ListPrivacyBudgetTemplatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<PrivacyBudgetTemplateSummary> privacyBudgetTemplateSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPrivacyBudgetTemplatesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.privacyBudgetTemplateSummaries(model.privacyBudgetTemplateSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<PrivacyBudgetTemplateSummary.Builder> getPrivacyBudgetTemplateSummaries() {
            List<PrivacyBudgetTemplateSummary.Builder> result = PrivacyBudgetTemplateSummaryListCopier.copyToBuilder(this.privacyBudgetTemplateSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrivacyBudgetTemplateSummaries(Collection<PrivacyBudgetTemplateSummary.BuilderImpl> privacyBudgetTemplateSummaries) {
            this.privacyBudgetTemplateSummaries = PrivacyBudgetTemplateSummaryListCopier.copyFromBuilder(privacyBudgetTemplateSummaries);
        }

        @Override
        public final Builder privacyBudgetTemplateSummaries(Collection<PrivacyBudgetTemplateSummary> privacyBudgetTemplateSummaries) {
            this.privacyBudgetTemplateSummaries = PrivacyBudgetTemplateSummaryListCopier.copy(privacyBudgetTemplateSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privacyBudgetTemplateSummaries(PrivacyBudgetTemplateSummary ... privacyBudgetTemplateSummaries) {
            this.privacyBudgetTemplateSummaries(Arrays.asList(privacyBudgetTemplateSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privacyBudgetTemplateSummaries(Consumer<PrivacyBudgetTemplateSummary.Builder> ... privacyBudgetTemplateSummaries) {
            this.privacyBudgetTemplateSummaries(Stream.of(privacyBudgetTemplateSummaries).map(c -> (PrivacyBudgetTemplateSummary)((PrivacyBudgetTemplateSummary.Builder)PrivacyBudgetTemplateSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListPrivacyBudgetTemplatesResponse build() {
            return new ListPrivacyBudgetTemplatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CleanRoomsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPrivacyBudgetTemplatesResponse> {
        public Builder nextToken(String var1);

        public Builder privacyBudgetTemplateSummaries(Collection<PrivacyBudgetTemplateSummary> var1);

        public Builder privacyBudgetTemplateSummaries(PrivacyBudgetTemplateSummary ... var1);

        public Builder privacyBudgetTemplateSummaries(Consumer<PrivacyBudgetTemplateSummary.Builder> ... var1);
    }
}

