/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanrooms.model.CleanRoomsResponse;
import software.amazon.awssdk.services.cleanrooms.model.CollaborationIdNamespaceAssociationSummary;
import software.amazon.awssdk.services.cleanrooms.model.CollaborationIdNamespaceAssociationSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCollaborationIdNamespaceAssociationsResponse
extends CleanRoomsResponse
implements ToCopyableBuilder<Builder, ListCollaborationIdNamespaceAssociationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListCollaborationIdNamespaceAssociationsResponse.getter(ListCollaborationIdNamespaceAssociationsResponse::nextToken)).setter(ListCollaborationIdNamespaceAssociationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<CollaborationIdNamespaceAssociationSummary>> COLLABORATION_ID_NAMESPACE_ASSOCIATION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("collaborationIdNamespaceAssociationSummaries").getter(ListCollaborationIdNamespaceAssociationsResponse.getter(ListCollaborationIdNamespaceAssociationsResponse::collaborationIdNamespaceAssociationSummaries)).setter(ListCollaborationIdNamespaceAssociationsResponse.setter(Builder::collaborationIdNamespaceAssociationSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationIdNamespaceAssociationSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CollaborationIdNamespaceAssociationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, COLLABORATION_ID_NAMESPACE_ASSOCIATION_SUMMARIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListCollaborationIdNamespaceAssociationsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<CollaborationIdNamespaceAssociationSummary> collaborationIdNamespaceAssociationSummaries;

    private ListCollaborationIdNamespaceAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.collaborationIdNamespaceAssociationSummaries = builder.collaborationIdNamespaceAssociationSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasCollaborationIdNamespaceAssociationSummaries() {
        return this.collaborationIdNamespaceAssociationSummaries != null && !(this.collaborationIdNamespaceAssociationSummaries instanceof SdkAutoConstructList);
    }

    public final List<CollaborationIdNamespaceAssociationSummary> collaborationIdNamespaceAssociationSummaries() {
        return this.collaborationIdNamespaceAssociationSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCollaborationIdNamespaceAssociationSummaries() ? this.collaborationIdNamespaceAssociationSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCollaborationIdNamespaceAssociationsResponse)) {
            return false;
        }
        ListCollaborationIdNamespaceAssociationsResponse other = (ListCollaborationIdNamespaceAssociationsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasCollaborationIdNamespaceAssociationSummaries() == other.hasCollaborationIdNamespaceAssociationSummaries() && Objects.equals(this.collaborationIdNamespaceAssociationSummaries(), other.collaborationIdNamespaceAssociationSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListCollaborationIdNamespaceAssociationsResponse").add("NextToken", (Object)this.nextToken()).add("CollaborationIdNamespaceAssociationSummaries", this.hasCollaborationIdNamespaceAssociationSummaries() ? this.collaborationIdNamespaceAssociationSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "collaborationIdNamespaceAssociationSummaries": {
                return Optional.ofNullable(clazz.cast(this.collaborationIdNamespaceAssociationSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("collaborationIdNamespaceAssociationSummaries", COLLABORATION_ID_NAMESPACE_ASSOCIATION_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCollaborationIdNamespaceAssociationsResponse, T> g) {
        return obj -> g.apply((ListCollaborationIdNamespaceAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<CollaborationIdNamespaceAssociationSummary> collaborationIdNamespaceAssociationSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCollaborationIdNamespaceAssociationsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.collaborationIdNamespaceAssociationSummaries(model.collaborationIdNamespaceAssociationSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<CollaborationIdNamespaceAssociationSummary.Builder> getCollaborationIdNamespaceAssociationSummaries() {
            List<CollaborationIdNamespaceAssociationSummary.Builder> result = CollaborationIdNamespaceAssociationSummaryListCopier.copyToBuilder(this.collaborationIdNamespaceAssociationSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCollaborationIdNamespaceAssociationSummaries(Collection<CollaborationIdNamespaceAssociationSummary.BuilderImpl> collaborationIdNamespaceAssociationSummaries) {
            this.collaborationIdNamespaceAssociationSummaries = CollaborationIdNamespaceAssociationSummaryListCopier.copyFromBuilder(collaborationIdNamespaceAssociationSummaries);
        }

        @Override
        public final Builder collaborationIdNamespaceAssociationSummaries(Collection<CollaborationIdNamespaceAssociationSummary> collaborationIdNamespaceAssociationSummaries) {
            this.collaborationIdNamespaceAssociationSummaries = CollaborationIdNamespaceAssociationSummaryListCopier.copy(collaborationIdNamespaceAssociationSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collaborationIdNamespaceAssociationSummaries(CollaborationIdNamespaceAssociationSummary ... collaborationIdNamespaceAssociationSummaries) {
            this.collaborationIdNamespaceAssociationSummaries(Arrays.asList(collaborationIdNamespaceAssociationSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collaborationIdNamespaceAssociationSummaries(Consumer<CollaborationIdNamespaceAssociationSummary.Builder> ... collaborationIdNamespaceAssociationSummaries) {
            this.collaborationIdNamespaceAssociationSummaries(Stream.of(collaborationIdNamespaceAssociationSummaries).map(c -> (CollaborationIdNamespaceAssociationSummary)((CollaborationIdNamespaceAssociationSummary.Builder)CollaborationIdNamespaceAssociationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListCollaborationIdNamespaceAssociationsResponse build() {
            return new ListCollaborationIdNamespaceAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CleanRoomsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCollaborationIdNamespaceAssociationsResponse> {
        public Builder nextToken(String var1);

        public Builder collaborationIdNamespaceAssociationSummaries(Collection<CollaborationIdNamespaceAssociationSummary> var1);

        public Builder collaborationIdNamespaceAssociationSummaries(CollaborationIdNamespaceAssociationSummary ... var1);

        public Builder collaborationIdNamespaceAssociationSummaries(Consumer<CollaborationIdNamespaceAssociationSummary.Builder> ... var1);
    }
}

