/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkvoice.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chimesdkvoice.model.ChimeSdkVoiceResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.VoiceProfileSummary;
import software.amazon.awssdk.services.chimesdkvoice.model.VoiceProfileSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListVoiceProfilesResponse
extends ChimeSdkVoiceResponse
implements ToCopyableBuilder<Builder, ListVoiceProfilesResponse> {
    private static final SdkField<List<VoiceProfileSummary>> VOICE_PROFILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VoiceProfiles").getter(ListVoiceProfilesResponse.getter(ListVoiceProfilesResponse::voiceProfiles)).setter(ListVoiceProfilesResponse.setter(Builder::voiceProfiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceProfiles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VoiceProfileSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListVoiceProfilesResponse.getter(ListVoiceProfilesResponse::nextToken)).setter(ListVoiceProfilesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOICE_PROFILES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListVoiceProfilesResponse.memberNameToFieldInitializer();
    private final List<VoiceProfileSummary> voiceProfiles;
    private final String nextToken;

    private ListVoiceProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.voiceProfiles = builder.voiceProfiles;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasVoiceProfiles() {
        return this.voiceProfiles != null && !(this.voiceProfiles instanceof SdkAutoConstructList);
    }

    public final List<VoiceProfileSummary> voiceProfiles() {
        return this.voiceProfiles;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVoiceProfiles() ? this.voiceProfiles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVoiceProfilesResponse)) {
            return false;
        }
        ListVoiceProfilesResponse other = (ListVoiceProfilesResponse)((Object)obj);
        return this.hasVoiceProfiles() == other.hasVoiceProfiles() && Objects.equals(this.voiceProfiles(), other.voiceProfiles()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListVoiceProfilesResponse").add("VoiceProfiles", this.hasVoiceProfiles() ? this.voiceProfiles() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VoiceProfiles": {
                return Optional.ofNullable(clazz.cast(this.voiceProfiles()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VoiceProfiles", VOICE_PROFILES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListVoiceProfilesResponse, T> g) {
        return obj -> g.apply((ListVoiceProfilesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkVoiceResponse.BuilderImpl
    implements Builder {
        private List<VoiceProfileSummary> voiceProfiles = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListVoiceProfilesResponse model) {
            super(model);
            this.voiceProfiles(model.voiceProfiles);
            this.nextToken(model.nextToken);
        }

        public final List<VoiceProfileSummary.Builder> getVoiceProfiles() {
            List<VoiceProfileSummary.Builder> result = VoiceProfileSummaryListCopier.copyToBuilder(this.voiceProfiles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVoiceProfiles(Collection<VoiceProfileSummary.BuilderImpl> voiceProfiles) {
            this.voiceProfiles = VoiceProfileSummaryListCopier.copyFromBuilder(voiceProfiles);
        }

        @Override
        public final Builder voiceProfiles(Collection<VoiceProfileSummary> voiceProfiles) {
            this.voiceProfiles = VoiceProfileSummaryListCopier.copy(voiceProfiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder voiceProfiles(VoiceProfileSummary ... voiceProfiles) {
            this.voiceProfiles(Arrays.asList(voiceProfiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder voiceProfiles(Consumer<VoiceProfileSummary.Builder> ... voiceProfiles) {
            this.voiceProfiles(Stream.of(voiceProfiles).map(c -> (VoiceProfileSummary)((VoiceProfileSummary.Builder)VoiceProfileSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListVoiceProfilesResponse build() {
            return new ListVoiceProfilesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ChimeSdkVoiceResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListVoiceProfilesResponse> {
        public Builder voiceProfiles(Collection<VoiceProfileSummary> var1);

        public Builder voiceProfiles(VoiceProfileSummary ... var1);

        public Builder voiceProfiles(Consumer<VoiceProfileSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

