/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmessaging.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chimesdkmessaging.ChimeSdkMessagingAsyncClient;
import software.amazon.awssdk.services.chimesdkmessaging.internal.UserAgentUtils;
import software.amazon.awssdk.services.chimesdkmessaging.model.SearchChannelsRequest;
import software.amazon.awssdk.services.chimesdkmessaging.model.SearchChannelsResponse;

public class SearchChannelsPublisher
implements SdkPublisher<SearchChannelsResponse> {
    private final ChimeSdkMessagingAsyncClient client;
    private final SearchChannelsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchChannelsPublisher(ChimeSdkMessagingAsyncClient client, SearchChannelsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchChannelsPublisher(ChimeSdkMessagingAsyncClient client, SearchChannelsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchChannelsResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchChannelsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class SearchChannelsResponseFetcher
    implements AsyncPageFetcher<SearchChannelsResponse> {
        private SearchChannelsResponseFetcher() {
        }

        public boolean hasNextPage(SearchChannelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchChannelsResponse> nextPage(SearchChannelsResponse previousPage) {
            if (previousPage == null) {
                return SearchChannelsPublisher.this.client.searchChannels(SearchChannelsPublisher.this.firstRequest);
            }
            return SearchChannelsPublisher.this.client.searchChannels((SearchChannelsRequest)((Object)SearchChannelsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

