/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chimesdkmessaging.model.ChimeSdkMessagingRequest;
import software.amazon.awssdk.services.chimesdkmessaging.model.ExpirationSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutChannelExpirationSettingsRequest
extends ChimeSdkMessagingRequest
implements ToCopyableBuilder<Builder, PutChannelExpirationSettingsRequest> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelArn").getter(PutChannelExpirationSettingsRequest.getter(PutChannelExpirationSettingsRequest::channelArn)).setter(PutChannelExpirationSettingsRequest.setter(Builder::channelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("channelArn").build()}).build();
    private static final SdkField<String> CHIME_BEARER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChimeBearer").getter(PutChannelExpirationSettingsRequest.getter(PutChannelExpirationSettingsRequest::chimeBearer)).setter(PutChannelExpirationSettingsRequest.setter(Builder::chimeBearer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-chime-bearer").build()}).build();
    private static final SdkField<ExpirationSettings> EXPIRATION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExpirationSettings").getter(PutChannelExpirationSettingsRequest.getter(PutChannelExpirationSettingsRequest::expirationSettings)).setter(PutChannelExpirationSettingsRequest.setter(Builder::expirationSettings)).constructor(ExpirationSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD, CHIME_BEARER_FIELD, EXPIRATION_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutChannelExpirationSettingsRequest.memberNameToFieldInitializer();
    private final String channelArn;
    private final String chimeBearer;
    private final ExpirationSettings expirationSettings;

    private PutChannelExpirationSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.channelArn = builder.channelArn;
        this.chimeBearer = builder.chimeBearer;
        this.expirationSettings = builder.expirationSettings;
    }

    public final String channelArn() {
        return this.channelArn;
    }

    public final String chimeBearer() {
        return this.chimeBearer;
    }

    public final ExpirationSettings expirationSettings() {
        return this.expirationSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.chimeBearer());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutChannelExpirationSettingsRequest)) {
            return false;
        }
        PutChannelExpirationSettingsRequest other = (PutChannelExpirationSettingsRequest)((Object)obj);
        return Objects.equals(this.channelArn(), other.channelArn()) && Objects.equals(this.chimeBearer(), other.chimeBearer()) && Objects.equals(this.expirationSettings(), other.expirationSettings());
    }

    public final String toString() {
        return ToString.builder((String)"PutChannelExpirationSettingsRequest").add("ChannelArn", (Object)this.channelArn()).add("ChimeBearer", (Object)this.chimeBearer()).add("ExpirationSettings", (Object)this.expirationSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelArn": {
                return Optional.ofNullable(clazz.cast(this.channelArn()));
            }
            case "ChimeBearer": {
                return Optional.ofNullable(clazz.cast(this.chimeBearer()));
            }
            case "ExpirationSettings": {
                return Optional.ofNullable(clazz.cast(this.expirationSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("channelArn", CHANNEL_ARN_FIELD);
        map.put("x-amz-chime-bearer", CHIME_BEARER_FIELD);
        map.put("ExpirationSettings", EXPIRATION_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutChannelExpirationSettingsRequest, T> g) {
        return obj -> g.apply((PutChannelExpirationSettingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkMessagingRequest.BuilderImpl
    implements Builder {
        private String channelArn;
        private String chimeBearer;
        private ExpirationSettings expirationSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(PutChannelExpirationSettingsRequest model) {
            super(model);
            this.channelArn(model.channelArn);
            this.chimeBearer(model.chimeBearer);
            this.expirationSettings(model.expirationSettings);
        }

        public final String getChannelArn() {
            return this.channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final String getChimeBearer() {
            return this.chimeBearer;
        }

        public final void setChimeBearer(String chimeBearer) {
            this.chimeBearer = chimeBearer;
        }

        @Override
        public final Builder chimeBearer(String chimeBearer) {
            this.chimeBearer = chimeBearer;
            return this;
        }

        public final ExpirationSettings.Builder getExpirationSettings() {
            return this.expirationSettings != null ? this.expirationSettings.toBuilder() : null;
        }

        public final void setExpirationSettings(ExpirationSettings.BuilderImpl expirationSettings) {
            this.expirationSettings = expirationSettings != null ? expirationSettings.build() : null;
        }

        @Override
        public final Builder expirationSettings(ExpirationSettings expirationSettings) {
            this.expirationSettings = expirationSettings;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutChannelExpirationSettingsRequest build() {
            return new PutChannelExpirationSettingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ChimeSdkMessagingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutChannelExpirationSettingsRequest> {
        public Builder channelArn(String var1);

        public Builder chimeBearer(String var1);

        public Builder expirationSettings(ExpirationSettings var1);

        default public Builder expirationSettings(Consumer<ExpirationSettings.Builder> expirationSettings) {
            return this.expirationSettings((ExpirationSettings)((ExpirationSettings.Builder)ExpirationSettings.builder().applyMutation(expirationSettings)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

