/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ChimeSdkMediaPipelinesRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.LiveConnectorSinkConfiguration;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.LiveConnectorSinkListCopier;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.LiveConnectorSourceConfiguration;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.LiveConnectorSourceListCopier;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.Tag;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMediaLiveConnectorPipelineRequest
extends ChimeSdkMediaPipelinesRequest
implements ToCopyableBuilder<Builder, CreateMediaLiveConnectorPipelineRequest> {
    private static final SdkField<List<LiveConnectorSourceConfiguration>> SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Sources").getter(CreateMediaLiveConnectorPipelineRequest.getter(CreateMediaLiveConnectorPipelineRequest::sources)).setter(CreateMediaLiveConnectorPipelineRequest.setter(Builder::sources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LiveConnectorSourceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<LiveConnectorSinkConfiguration>> SINKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Sinks").getter(CreateMediaLiveConnectorPipelineRequest.getter(CreateMediaLiveConnectorPipelineRequest::sinks)).setter(CreateMediaLiveConnectorPipelineRequest.setter(Builder::sinks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sinks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LiveConnectorSinkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(CreateMediaLiveConnectorPipelineRequest.getter(CreateMediaLiveConnectorPipelineRequest::clientRequestToken)).setter(CreateMediaLiveConnectorPipelineRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateMediaLiveConnectorPipelineRequest.getter(CreateMediaLiveConnectorPipelineRequest::tags)).setter(CreateMediaLiveConnectorPipelineRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCES_FIELD, SINKS_FIELD, CLIENT_REQUEST_TOKEN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateMediaLiveConnectorPipelineRequest.memberNameToFieldInitializer();
    private final List<LiveConnectorSourceConfiguration> sources;
    private final List<LiveConnectorSinkConfiguration> sinks;
    private final String clientRequestToken;
    private final List<Tag> tags;

    private CreateMediaLiveConnectorPipelineRequest(BuilderImpl builder) {
        super(builder);
        this.sources = builder.sources;
        this.sinks = builder.sinks;
        this.clientRequestToken = builder.clientRequestToken;
        this.tags = builder.tags;
    }

    public final boolean hasSources() {
        return this.sources != null && !(this.sources instanceof SdkAutoConstructList);
    }

    public final List<LiveConnectorSourceConfiguration> sources() {
        return this.sources;
    }

    public final boolean hasSinks() {
        return this.sinks != null && !(this.sinks instanceof SdkAutoConstructList);
    }

    public final List<LiveConnectorSinkConfiguration> sinks() {
        return this.sinks;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSources() ? this.sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSinks() ? this.sinks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMediaLiveConnectorPipelineRequest)) {
            return false;
        }
        CreateMediaLiveConnectorPipelineRequest other = (CreateMediaLiveConnectorPipelineRequest)((Object)obj);
        return this.hasSources() == other.hasSources() && Objects.equals(this.sources(), other.sources()) && this.hasSinks() == other.hasSinks() && Objects.equals(this.sinks(), other.sinks()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMediaLiveConnectorPipelineRequest").add("Sources", this.hasSources() ? this.sources() : null).add("Sinks", this.hasSinks() ? this.sinks() : null).add("ClientRequestToken", (Object)(this.clientRequestToken() == null ? null : "*** Sensitive Data Redacted ***")).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Sources": {
                return Optional.ofNullable(clazz.cast(this.sources()));
            }
            case "Sinks": {
                return Optional.ofNullable(clazz.cast(this.sinks()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Sources", SOURCES_FIELD);
        map.put("Sinks", SINKS_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMediaLiveConnectorPipelineRequest, T> g) {
        return obj -> g.apply((CreateMediaLiveConnectorPipelineRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkMediaPipelinesRequest.BuilderImpl
    implements Builder {
        private List<LiveConnectorSourceConfiguration> sources = DefaultSdkAutoConstructList.getInstance();
        private List<LiveConnectorSinkConfiguration> sinks = DefaultSdkAutoConstructList.getInstance();
        private String clientRequestToken;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMediaLiveConnectorPipelineRequest model) {
            super(model);
            this.sources(model.sources);
            this.sinks(model.sinks);
            this.clientRequestToken(model.clientRequestToken);
            this.tags(model.tags);
        }

        public final List<LiveConnectorSourceConfiguration.Builder> getSources() {
            List<LiveConnectorSourceConfiguration.Builder> result = LiveConnectorSourceListCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<LiveConnectorSourceConfiguration.BuilderImpl> sources) {
            this.sources = LiveConnectorSourceListCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<LiveConnectorSourceConfiguration> sources) {
            this.sources = LiveConnectorSourceListCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(LiveConnectorSourceConfiguration ... sources) {
            this.sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<LiveConnectorSourceConfiguration.Builder> ... sources) {
            this.sources(Stream.of(sources).map(c -> (LiveConnectorSourceConfiguration)((LiveConnectorSourceConfiguration.Builder)LiveConnectorSourceConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<LiveConnectorSinkConfiguration.Builder> getSinks() {
            List<LiveConnectorSinkConfiguration.Builder> result = LiveConnectorSinkListCopier.copyToBuilder(this.sinks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSinks(Collection<LiveConnectorSinkConfiguration.BuilderImpl> sinks) {
            this.sinks = LiveConnectorSinkListCopier.copyFromBuilder(sinks);
        }

        @Override
        public final Builder sinks(Collection<LiveConnectorSinkConfiguration> sinks) {
            this.sinks = LiveConnectorSinkListCopier.copy(sinks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sinks(LiveConnectorSinkConfiguration ... sinks) {
            this.sinks(Arrays.asList(sinks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sinks(Consumer<LiveConnectorSinkConfiguration.Builder> ... sinks) {
            this.sinks(Stream.of(sinks).map(c -> (LiveConnectorSinkConfiguration)((LiveConnectorSinkConfiguration.Builder)LiveConnectorSinkConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMediaLiveConnectorPipelineRequest build() {
            return new CreateMediaLiveConnectorPipelineRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ChimeSdkMediaPipelinesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMediaLiveConnectorPipelineRequest> {
        public Builder sources(Collection<LiveConnectorSourceConfiguration> var1);

        public Builder sources(LiveConnectorSourceConfiguration ... var1);

        public Builder sources(Consumer<LiveConnectorSourceConfiguration.Builder> ... var1);

        public Builder sinks(Collection<LiveConnectorSinkConfiguration> var1);

        public Builder sinks(LiveConnectorSinkConfiguration ... var1);

        public Builder sinks(Consumer<LiveConnectorSinkConfiguration.Builder> ... var1);

        public Builder clientRequestToken(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

