/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkidentity.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chimesdkidentity.model.InvokedBy;
import software.amazon.awssdk.services.chimesdkidentity.model.RespondsTo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LexConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LexConfiguration> {
    private static final SdkField<String> RESPONDS_TO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RespondsTo").getter(LexConfiguration.getter(LexConfiguration::respondsToAsString)).setter(LexConfiguration.setter(Builder::respondsTo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RespondsTo").build()}).build();
    private static final SdkField<InvokedBy> INVOKED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InvokedBy").getter(LexConfiguration.getter(LexConfiguration::invokedBy)).setter(LexConfiguration.setter(Builder::invokedBy)).constructor(InvokedBy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvokedBy").build()}).build();
    private static final SdkField<String> LEX_BOT_ALIAS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LexBotAliasArn").getter(LexConfiguration.getter(LexConfiguration::lexBotAliasArn)).setter(LexConfiguration.setter(Builder::lexBotAliasArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LexBotAliasArn").build()}).build();
    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocaleId").getter(LexConfiguration.getter(LexConfiguration::localeId)).setter(LexConfiguration.setter(Builder::localeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocaleId").build()}).build();
    private static final SdkField<String> WELCOME_INTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WelcomeIntent").getter(LexConfiguration.getter(LexConfiguration::welcomeIntent)).setter(LexConfiguration.setter(Builder::welcomeIntent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WelcomeIntent").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESPONDS_TO_FIELD, INVOKED_BY_FIELD, LEX_BOT_ALIAS_ARN_FIELD, LOCALE_ID_FIELD, WELCOME_INTENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LexConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String respondsTo;
    private final InvokedBy invokedBy;
    private final String lexBotAliasArn;
    private final String localeId;
    private final String welcomeIntent;

    private LexConfiguration(BuilderImpl builder) {
        this.respondsTo = builder.respondsTo;
        this.invokedBy = builder.invokedBy;
        this.lexBotAliasArn = builder.lexBotAliasArn;
        this.localeId = builder.localeId;
        this.welcomeIntent = builder.welcomeIntent;
    }

    public final RespondsTo respondsTo() {
        return RespondsTo.fromValue(this.respondsTo);
    }

    public final String respondsToAsString() {
        return this.respondsTo;
    }

    public final InvokedBy invokedBy() {
        return this.invokedBy;
    }

    public final String lexBotAliasArn() {
        return this.lexBotAliasArn;
    }

    public final String localeId() {
        return this.localeId;
    }

    public final String welcomeIntent() {
        return this.welcomeIntent;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.respondsToAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.invokedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.lexBotAliasArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.localeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.welcomeIntent());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LexConfiguration)) {
            return false;
        }
        LexConfiguration other = (LexConfiguration)obj;
        return Objects.equals(this.respondsToAsString(), other.respondsToAsString()) && Objects.equals(this.invokedBy(), other.invokedBy()) && Objects.equals(this.lexBotAliasArn(), other.lexBotAliasArn()) && Objects.equals(this.localeId(), other.localeId()) && Objects.equals(this.welcomeIntent(), other.welcomeIntent());
    }

    public final String toString() {
        return ToString.builder((String)"LexConfiguration").add("RespondsTo", (Object)this.respondsToAsString()).add("InvokedBy", (Object)this.invokedBy()).add("LexBotAliasArn", (Object)this.lexBotAliasArn()).add("LocaleId", (Object)this.localeId()).add("WelcomeIntent", (Object)this.welcomeIntent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RespondsTo": {
                return Optional.ofNullable(clazz.cast(this.respondsToAsString()));
            }
            case "InvokedBy": {
                return Optional.ofNullable(clazz.cast(this.invokedBy()));
            }
            case "LexBotAliasArn": {
                return Optional.ofNullable(clazz.cast(this.lexBotAliasArn()));
            }
            case "LocaleId": {
                return Optional.ofNullable(clazz.cast(this.localeId()));
            }
            case "WelcomeIntent": {
                return Optional.ofNullable(clazz.cast(this.welcomeIntent()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RespondsTo", RESPONDS_TO_FIELD);
        map.put("InvokedBy", INVOKED_BY_FIELD);
        map.put("LexBotAliasArn", LEX_BOT_ALIAS_ARN_FIELD);
        map.put("LocaleId", LOCALE_ID_FIELD);
        map.put("WelcomeIntent", WELCOME_INTENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LexConfiguration, T> g) {
        return obj -> g.apply((LexConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String respondsTo;
        private InvokedBy invokedBy;
        private String lexBotAliasArn;
        private String localeId;
        private String welcomeIntent;

        private BuilderImpl() {
        }

        private BuilderImpl(LexConfiguration model) {
            this.respondsTo(model.respondsTo);
            this.invokedBy(model.invokedBy);
            this.lexBotAliasArn(model.lexBotAliasArn);
            this.localeId(model.localeId);
            this.welcomeIntent(model.welcomeIntent);
        }

        public final String getRespondsTo() {
            return this.respondsTo;
        }

        public final void setRespondsTo(String respondsTo) {
            this.respondsTo = respondsTo;
        }

        @Override
        public final Builder respondsTo(String respondsTo) {
            this.respondsTo = respondsTo;
            return this;
        }

        @Override
        public final Builder respondsTo(RespondsTo respondsTo) {
            this.respondsTo(respondsTo == null ? null : respondsTo.toString());
            return this;
        }

        public final InvokedBy.Builder getInvokedBy() {
            return this.invokedBy != null ? this.invokedBy.toBuilder() : null;
        }

        public final void setInvokedBy(InvokedBy.BuilderImpl invokedBy) {
            this.invokedBy = invokedBy != null ? invokedBy.build() : null;
        }

        @Override
        public final Builder invokedBy(InvokedBy invokedBy) {
            this.invokedBy = invokedBy;
            return this;
        }

        public final String getLexBotAliasArn() {
            return this.lexBotAliasArn;
        }

        public final void setLexBotAliasArn(String lexBotAliasArn) {
            this.lexBotAliasArn = lexBotAliasArn;
        }

        @Override
        public final Builder lexBotAliasArn(String lexBotAliasArn) {
            this.lexBotAliasArn = lexBotAliasArn;
            return this;
        }

        public final String getLocaleId() {
            return this.localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final String getWelcomeIntent() {
            return this.welcomeIntent;
        }

        public final void setWelcomeIntent(String welcomeIntent) {
            this.welcomeIntent = welcomeIntent;
        }

        @Override
        public final Builder welcomeIntent(String welcomeIntent) {
            this.welcomeIntent = welcomeIntent;
            return this;
        }

        public LexConfiguration build() {
            return new LexConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LexConfiguration> {
        public Builder respondsTo(String var1);

        public Builder respondsTo(RespondsTo var1);

        public Builder invokedBy(InvokedBy var1);

        default public Builder invokedBy(Consumer<InvokedBy.Builder> invokedBy) {
            return this.invokedBy((InvokedBy)((InvokedBy.Builder)InvokedBy.builder().applyMutation(invokedBy)).build());
        }

        public Builder lexBotAliasArn(String var1);

        public Builder localeId(String var1);

        public Builder welcomeIntent(String var1);
    }
}

