/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkidentity.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chimesdkidentity.ChimeSdkIdentityClient;
import software.amazon.awssdk.services.chimesdkidentity.internal.UserAgentUtils;
import software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstancesRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstancesResponse;

public class ListAppInstancesIterable
implements SdkIterable<ListAppInstancesResponse> {
    private final ChimeSdkIdentityClient client;
    private final ListAppInstancesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAppInstancesIterable(ChimeSdkIdentityClient client, ListAppInstancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAppInstancesResponseFetcher();
    }

    public Iterator<ListAppInstancesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListAppInstancesResponseFetcher
    implements SyncPageFetcher<ListAppInstancesResponse> {
        private ListAppInstancesResponseFetcher() {
        }

        public boolean hasNextPage(ListAppInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAppInstancesResponse nextPage(ListAppInstancesResponse previousPage) {
            if (previousPage == null) {
                return ListAppInstancesIterable.this.client.listAppInstances(ListAppInstancesIterable.this.firstRequest);
            }
            return ListAppInstancesIterable.this.client.listAppInstances((ListAppInstancesRequest)((Object)ListAppInstancesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

