/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.CallingNameStatus;
import software.amazon.awssdk.services.chime.model.PhoneNumberAssociation;
import software.amazon.awssdk.services.chime.model.PhoneNumberAssociationListCopier;
import software.amazon.awssdk.services.chime.model.PhoneNumberCapabilities;
import software.amazon.awssdk.services.chime.model.PhoneNumberProductType;
import software.amazon.awssdk.services.chime.model.PhoneNumberStatus;
import software.amazon.awssdk.services.chime.model.PhoneNumberType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PhoneNumber
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PhoneNumber> {
    private static final SdkField<String> PHONE_NUMBER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PhoneNumberId").getter(PhoneNumber.getter(PhoneNumber::phoneNumberId)).setter(PhoneNumber.setter(Builder::phoneNumberId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberId").build()}).build();
    private static final SdkField<String> E164_PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("E164PhoneNumber").getter(PhoneNumber.getter(PhoneNumber::e164PhoneNumber)).setter(PhoneNumber.setter(Builder::e164PhoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("E164PhoneNumber").build()}).build();
    private static final SdkField<String> COUNTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Country").getter(PhoneNumber.getter(PhoneNumber::country)).setter(PhoneNumber.setter(Builder::country)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(PhoneNumber.getter(PhoneNumber::typeAsString)).setter(PhoneNumber.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> PRODUCT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductType").getter(PhoneNumber.getter(PhoneNumber::productTypeAsString)).setter(PhoneNumber.setter(Builder::productType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(PhoneNumber.getter(PhoneNumber::statusAsString)).setter(PhoneNumber.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<PhoneNumberCapabilities> CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Capabilities").getter(PhoneNumber.getter(PhoneNumber::capabilities)).setter(PhoneNumber.setter(Builder::capabilities)).constructor(PhoneNumberCapabilities::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capabilities").build()}).build();
    private static final SdkField<List<PhoneNumberAssociation>> ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Associations").getter(PhoneNumber.getter(PhoneNumber::associations)).setter(PhoneNumber.setter(Builder::associations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Associations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PhoneNumberAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CALLING_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CallingName").getter(PhoneNumber.getter(PhoneNumber::callingName)).setter(PhoneNumber.setter(Builder::callingName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallingName").build()}).build();
    private static final SdkField<String> CALLING_NAME_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CallingNameStatus").getter(PhoneNumber.getter(PhoneNumber::callingNameStatusAsString)).setter(PhoneNumber.setter(Builder::callingNameStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallingNameStatus").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(PhoneNumber.getter(PhoneNumber::createdTimestamp)).setter(PhoneNumber.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedTimestamp").getter(PhoneNumber.getter(PhoneNumber::updatedTimestamp)).setter(PhoneNumber.setter(Builder::updatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTimestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> DELETION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DeletionTimestamp").getter(PhoneNumber.getter(PhoneNumber::deletionTimestamp)).setter(PhoneNumber.setter(Builder::deletionTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionTimestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_NUMBER_ID_FIELD, E164_PHONE_NUMBER_FIELD, COUNTRY_FIELD, TYPE_FIELD, PRODUCT_TYPE_FIELD, STATUS_FIELD, CAPABILITIES_FIELD, ASSOCIATIONS_FIELD, CALLING_NAME_FIELD, CALLING_NAME_STATUS_FIELD, CREATED_TIMESTAMP_FIELD, UPDATED_TIMESTAMP_FIELD, DELETION_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PhoneNumber.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String phoneNumberId;
    private final String e164PhoneNumber;
    private final String country;
    private final String type;
    private final String productType;
    private final String status;
    private final PhoneNumberCapabilities capabilities;
    private final List<PhoneNumberAssociation> associations;
    private final String callingName;
    private final String callingNameStatus;
    private final Instant createdTimestamp;
    private final Instant updatedTimestamp;
    private final Instant deletionTimestamp;

    private PhoneNumber(BuilderImpl builder) {
        this.phoneNumberId = builder.phoneNumberId;
        this.e164PhoneNumber = builder.e164PhoneNumber;
        this.country = builder.country;
        this.type = builder.type;
        this.productType = builder.productType;
        this.status = builder.status;
        this.capabilities = builder.capabilities;
        this.associations = builder.associations;
        this.callingName = builder.callingName;
        this.callingNameStatus = builder.callingNameStatus;
        this.createdTimestamp = builder.createdTimestamp;
        this.updatedTimestamp = builder.updatedTimestamp;
        this.deletionTimestamp = builder.deletionTimestamp;
    }

    public final String phoneNumberId() {
        return this.phoneNumberId;
    }

    public final String e164PhoneNumber() {
        return this.e164PhoneNumber;
    }

    public final String country() {
        return this.country;
    }

    public final PhoneNumberType type() {
        return PhoneNumberType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final PhoneNumberProductType productType() {
        return PhoneNumberProductType.fromValue(this.productType);
    }

    public final String productTypeAsString() {
        return this.productType;
    }

    public final PhoneNumberStatus status() {
        return PhoneNumberStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final PhoneNumberCapabilities capabilities() {
        return this.capabilities;
    }

    public final boolean hasAssociations() {
        return this.associations != null && !(this.associations instanceof SdkAutoConstructList);
    }

    public final List<PhoneNumberAssociation> associations() {
        return this.associations;
    }

    public final String callingName() {
        return this.callingName;
    }

    public final CallingNameStatus callingNameStatus() {
        return CallingNameStatus.fromValue(this.callingNameStatus);
    }

    public final String callingNameStatusAsString() {
        return this.callingNameStatus;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public final Instant updatedTimestamp() {
        return this.updatedTimestamp;
    }

    public final Instant deletionTimestamp() {
        return this.deletionTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumberId());
        hashCode = 31 * hashCode + Objects.hashCode(this.e164PhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.country());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.productTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.capabilities());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociations() ? this.associations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.callingName());
        hashCode = 31 * hashCode + Objects.hashCode(this.callingNameStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PhoneNumber)) {
            return false;
        }
        PhoneNumber other = (PhoneNumber)obj;
        return Objects.equals(this.phoneNumberId(), other.phoneNumberId()) && Objects.equals(this.e164PhoneNumber(), other.e164PhoneNumber()) && Objects.equals(this.country(), other.country()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.productTypeAsString(), other.productTypeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.capabilities(), other.capabilities()) && this.hasAssociations() == other.hasAssociations() && Objects.equals(this.associations(), other.associations()) && Objects.equals(this.callingName(), other.callingName()) && Objects.equals(this.callingNameStatusAsString(), other.callingNameStatusAsString()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.updatedTimestamp(), other.updatedTimestamp()) && Objects.equals(this.deletionTimestamp(), other.deletionTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"PhoneNumber").add("PhoneNumberId", (Object)this.phoneNumberId()).add("E164PhoneNumber", (Object)(this.e164PhoneNumber() == null ? null : "*** Sensitive Data Redacted ***")).add("Country", (Object)this.country()).add("Type", (Object)this.typeAsString()).add("ProductType", (Object)this.productTypeAsString()).add("Status", (Object)this.statusAsString()).add("Capabilities", (Object)this.capabilities()).add("Associations", this.hasAssociations() ? this.associations() : null).add("CallingName", (Object)(this.callingName() == null ? null : "*** Sensitive Data Redacted ***")).add("CallingNameStatus", (Object)this.callingNameStatusAsString()).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("UpdatedTimestamp", (Object)this.updatedTimestamp()).add("DeletionTimestamp", (Object)this.deletionTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PhoneNumberId": {
                return Optional.ofNullable(clazz.cast(this.phoneNumberId()));
            }
            case "E164PhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.e164PhoneNumber()));
            }
            case "Country": {
                return Optional.ofNullable(clazz.cast(this.country()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "ProductType": {
                return Optional.ofNullable(clazz.cast(this.productTypeAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Capabilities": {
                return Optional.ofNullable(clazz.cast(this.capabilities()));
            }
            case "Associations": {
                return Optional.ofNullable(clazz.cast(this.associations()));
            }
            case "CallingName": {
                return Optional.ofNullable(clazz.cast(this.callingName()));
            }
            case "CallingNameStatus": {
                return Optional.ofNullable(clazz.cast(this.callingNameStatusAsString()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "UpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.updatedTimestamp()));
            }
            case "DeletionTimestamp": {
                return Optional.ofNullable(clazz.cast(this.deletionTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PhoneNumberId", PHONE_NUMBER_ID_FIELD);
        map.put("E164PhoneNumber", E164_PHONE_NUMBER_FIELD);
        map.put("Country", COUNTRY_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("ProductType", PRODUCT_TYPE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Capabilities", CAPABILITIES_FIELD);
        map.put("Associations", ASSOCIATIONS_FIELD);
        map.put("CallingName", CALLING_NAME_FIELD);
        map.put("CallingNameStatus", CALLING_NAME_STATUS_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("UpdatedTimestamp", UPDATED_TIMESTAMP_FIELD);
        map.put("DeletionTimestamp", DELETION_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PhoneNumber, T> g) {
        return obj -> g.apply((PhoneNumber)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String phoneNumberId;
        private String e164PhoneNumber;
        private String country;
        private String type;
        private String productType;
        private String status;
        private PhoneNumberCapabilities capabilities;
        private List<PhoneNumberAssociation> associations = DefaultSdkAutoConstructList.getInstance();
        private String callingName;
        private String callingNameStatus;
        private Instant createdTimestamp;
        private Instant updatedTimestamp;
        private Instant deletionTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(PhoneNumber model) {
            this.phoneNumberId(model.phoneNumberId);
            this.e164PhoneNumber(model.e164PhoneNumber);
            this.country(model.country);
            this.type(model.type);
            this.productType(model.productType);
            this.status(model.status);
            this.capabilities(model.capabilities);
            this.associations(model.associations);
            this.callingName(model.callingName);
            this.callingNameStatus(model.callingNameStatus);
            this.createdTimestamp(model.createdTimestamp);
            this.updatedTimestamp(model.updatedTimestamp);
            this.deletionTimestamp(model.deletionTimestamp);
        }

        public final String getPhoneNumberId() {
            return this.phoneNumberId;
        }

        public final void setPhoneNumberId(String phoneNumberId) {
            this.phoneNumberId = phoneNumberId;
        }

        @Override
        public final Builder phoneNumberId(String phoneNumberId) {
            this.phoneNumberId = phoneNumberId;
            return this;
        }

        public final String getE164PhoneNumber() {
            return this.e164PhoneNumber;
        }

        public final void setE164PhoneNumber(String e164PhoneNumber) {
            this.e164PhoneNumber = e164PhoneNumber;
        }

        @Override
        public final Builder e164PhoneNumber(String e164PhoneNumber) {
            this.e164PhoneNumber = e164PhoneNumber;
            return this;
        }

        public final String getCountry() {
            return this.country;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PhoneNumberType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getProductType() {
            return this.productType;
        }

        public final void setProductType(String productType) {
            this.productType = productType;
        }

        @Override
        public final Builder productType(String productType) {
            this.productType = productType;
            return this;
        }

        @Override
        public final Builder productType(PhoneNumberProductType productType) {
            this.productType(productType == null ? null : productType.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PhoneNumberStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final PhoneNumberCapabilities.Builder getCapabilities() {
            return this.capabilities != null ? this.capabilities.toBuilder() : null;
        }

        public final void setCapabilities(PhoneNumberCapabilities.BuilderImpl capabilities) {
            this.capabilities = capabilities != null ? capabilities.build() : null;
        }

        @Override
        public final Builder capabilities(PhoneNumberCapabilities capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        public final List<PhoneNumberAssociation.Builder> getAssociations() {
            List<PhoneNumberAssociation.Builder> result = PhoneNumberAssociationListCopier.copyToBuilder(this.associations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociations(Collection<PhoneNumberAssociation.BuilderImpl> associations) {
            this.associations = PhoneNumberAssociationListCopier.copyFromBuilder(associations);
        }

        @Override
        public final Builder associations(Collection<PhoneNumberAssociation> associations) {
            this.associations = PhoneNumberAssociationListCopier.copy(associations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(PhoneNumberAssociation ... associations) {
            this.associations(Arrays.asList(associations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(Consumer<PhoneNumberAssociation.Builder> ... associations) {
            this.associations(Stream.of(associations).map(c -> (PhoneNumberAssociation)((PhoneNumberAssociation.Builder)PhoneNumberAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getCallingName() {
            return this.callingName;
        }

        public final void setCallingName(String callingName) {
            this.callingName = callingName;
        }

        @Override
        public final Builder callingName(String callingName) {
            this.callingName = callingName;
            return this;
        }

        public final String getCallingNameStatus() {
            return this.callingNameStatus;
        }

        public final void setCallingNameStatus(String callingNameStatus) {
            this.callingNameStatus = callingNameStatus;
        }

        @Override
        public final Builder callingNameStatus(String callingNameStatus) {
            this.callingNameStatus = callingNameStatus;
            return this;
        }

        @Override
        public final Builder callingNameStatus(CallingNameStatus callingNameStatus) {
            this.callingNameStatus(callingNameStatus == null ? null : callingNameStatus.toString());
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getUpdatedTimestamp() {
            return this.updatedTimestamp;
        }

        public final void setUpdatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
        }

        @Override
        public final Builder updatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
            return this;
        }

        public final Instant getDeletionTimestamp() {
            return this.deletionTimestamp;
        }

        public final void setDeletionTimestamp(Instant deletionTimestamp) {
            this.deletionTimestamp = deletionTimestamp;
        }

        @Override
        public final Builder deletionTimestamp(Instant deletionTimestamp) {
            this.deletionTimestamp = deletionTimestamp;
            return this;
        }

        public PhoneNumber build() {
            return new PhoneNumber(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PhoneNumber> {
        public Builder phoneNumberId(String var1);

        public Builder e164PhoneNumber(String var1);

        public Builder country(String var1);

        public Builder type(String var1);

        public Builder type(PhoneNumberType var1);

        public Builder productType(String var1);

        public Builder productType(PhoneNumberProductType var1);

        public Builder status(String var1);

        public Builder status(PhoneNumberStatus var1);

        public Builder capabilities(PhoneNumberCapabilities var1);

        default public Builder capabilities(Consumer<PhoneNumberCapabilities.Builder> capabilities) {
            return this.capabilities((PhoneNumberCapabilities)((PhoneNumberCapabilities.Builder)PhoneNumberCapabilities.builder().applyMutation(capabilities)).build());
        }

        public Builder associations(Collection<PhoneNumberAssociation> var1);

        public Builder associations(PhoneNumberAssociation ... var1);

        public Builder associations(Consumer<PhoneNumberAssociation.Builder> ... var1);

        public Builder callingName(String var1);

        public Builder callingNameStatus(String var1);

        public Builder callingNameStatus(CallingNameStatus var1);

        public Builder createdTimestamp(Instant var1);

        public Builder updatedTimestamp(Instant var1);

        public Builder deletionTimestamp(Instant var1);
    }
}

