/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.checksums.internal;

import java.lang.reflect.Method;
import java.util.zip.Checksum;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.checksums.internal.BaseCrcChecksum;
import software.amazon.awssdk.utils.NumericUtils;

@SdkInternalApi
public final class CrcCloneOnMarkChecksum
extends BaseCrcChecksum {
    public CrcCloneOnMarkChecksum(Checksum checksum) {
        super(checksum);
    }

    @Override
    Checksum cloneChecksum(Checksum checksum) {
        return this.cloneIfCloneable(checksum);
    }

    @Override
    public byte[] getChecksumBytes() {
        byte[] valueBytes = NumericUtils.longToByte((Long)this.getValue());
        return new byte[]{valueBytes[4], valueBytes[5], valueBytes[6], valueBytes[7]};
    }

    private Checksum cloneIfCloneable(Checksum checksum) {
        if (checksum instanceof Cloneable) {
            try {
                Method cloneMethod = checksum.getClass().getMethod("clone", new Class[0]);
                return (Checksum)cloneMethod.invoke((Object)checksum, new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to clone the checksum", e);
            }
        }
        throw new UnsupportedOperationException("Checksum does not support cloning");
    }
}

