/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.budgets.BudgetsClient;
import software.amazon.awssdk.services.budgets.internal.UserAgentUtils;
import software.amazon.awssdk.services.budgets.model.BudgetNotificationsForAccount;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetNotificationsForAccountRequest;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetNotificationsForAccountResponse;

public class DescribeBudgetNotificationsForAccountIterable
implements SdkIterable<DescribeBudgetNotificationsForAccountResponse> {
    private final BudgetsClient client;
    private final DescribeBudgetNotificationsForAccountRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeBudgetNotificationsForAccountIterable(BudgetsClient client, DescribeBudgetNotificationsForAccountRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeBudgetNotificationsForAccountResponseFetcher();
    }

    public Iterator<DescribeBudgetNotificationsForAccountResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<BudgetNotificationsForAccount> budgetNotificationsForAccount() {
        Function<DescribeBudgetNotificationsForAccountResponse, Iterator> getIterator = response -> {
            if (response != null && response.budgetNotificationsForAccount() != null) {
                return response.budgetNotificationsForAccount().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeBudgetNotificationsForAccountResponseFetcher
    implements SyncPageFetcher<DescribeBudgetNotificationsForAccountResponse> {
        private DescribeBudgetNotificationsForAccountResponseFetcher() {
        }

        public boolean hasNextPage(DescribeBudgetNotificationsForAccountResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeBudgetNotificationsForAccountResponse nextPage(DescribeBudgetNotificationsForAccountResponse previousPage) {
            if (previousPage == null) {
                return DescribeBudgetNotificationsForAccountIterable.this.client.describeBudgetNotificationsForAccount(DescribeBudgetNotificationsForAccountIterable.this.firstRequest);
            }
            return DescribeBudgetNotificationsForAccountIterable.this.client.describeBudgetNotificationsForAccount((DescribeBudgetNotificationsForAccountRequest)((Object)DescribeBudgetNotificationsForAccountIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

