/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.braket.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.braket.model.TagsMapCopier;
import software.amazon.awssdk.services.braket.model.TimePeriod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SpendingLimitSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SpendingLimitSummary> {
    private static final SdkField<String> SPENDING_LIMIT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("spendingLimitArn").getter(SpendingLimitSummary.getter(SpendingLimitSummary::spendingLimitArn)).setter(SpendingLimitSummary.setter(Builder::spendingLimitArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spendingLimitArn").build()}).build();
    private static final SdkField<String> DEVICE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deviceArn").getter(SpendingLimitSummary.getter(SpendingLimitSummary::deviceArn)).setter(SpendingLimitSummary.setter(Builder::deviceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceArn").build()}).build();
    private static final SdkField<TimePeriod> TIME_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("timePeriod").getter(SpendingLimitSummary.getter(SpendingLimitSummary::timePeriod)).setter(SpendingLimitSummary.setter(Builder::timePeriod)).constructor(TimePeriod::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timePeriod").build()}).build();
    private static final SdkField<String> SPENDING_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("spendingLimit").getter(SpendingLimitSummary.getter(SpendingLimitSummary::spendingLimit)).setter(SpendingLimitSummary.setter(Builder::spendingLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spendingLimit").build()}).build();
    private static final SdkField<String> QUEUED_SPEND_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queuedSpend").getter(SpendingLimitSummary.getter(SpendingLimitSummary::queuedSpend)).setter(SpendingLimitSummary.setter(Builder::queuedSpend)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queuedSpend").build()}).build();
    private static final SdkField<String> TOTAL_SPEND_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("totalSpend").getter(SpendingLimitSummary.getter(SpendingLimitSummary::totalSpend)).setter(SpendingLimitSummary.setter(Builder::totalSpend)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalSpend").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(SpendingLimitSummary.getter(SpendingLimitSummary::createdAt)).setter(SpendingLimitSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(SpendingLimitSummary.getter(SpendingLimitSummary::updatedAt)).setter(SpendingLimitSummary.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(SpendingLimitSummary.getter(SpendingLimitSummary::tags)).setter(SpendingLimitSummary.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPENDING_LIMIT_ARN_FIELD, DEVICE_ARN_FIELD, TIME_PERIOD_FIELD, SPENDING_LIMIT_FIELD, QUEUED_SPEND_FIELD, TOTAL_SPEND_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SpendingLimitSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String spendingLimitArn;
    private final String deviceArn;
    private final TimePeriod timePeriod;
    private final String spendingLimit;
    private final String queuedSpend;
    private final String totalSpend;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final Map<String, String> tags;

    private SpendingLimitSummary(BuilderImpl builder) {
        this.spendingLimitArn = builder.spendingLimitArn;
        this.deviceArn = builder.deviceArn;
        this.timePeriod = builder.timePeriod;
        this.spendingLimit = builder.spendingLimit;
        this.queuedSpend = builder.queuedSpend;
        this.totalSpend = builder.totalSpend;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.tags = builder.tags;
    }

    public final String spendingLimitArn() {
        return this.spendingLimitArn;
    }

    public final String deviceArn() {
        return this.deviceArn;
    }

    public final TimePeriod timePeriod() {
        return this.timePeriod;
    }

    public final String spendingLimit() {
        return this.spendingLimit;
    }

    public final String queuedSpend() {
        return this.queuedSpend;
    }

    public final String totalSpend() {
        return this.totalSpend;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.spendingLimitArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.timePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.spendingLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.queuedSpend());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalSpend());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpendingLimitSummary)) {
            return false;
        }
        SpendingLimitSummary other = (SpendingLimitSummary)obj;
        return Objects.equals(this.spendingLimitArn(), other.spendingLimitArn()) && Objects.equals(this.deviceArn(), other.deviceArn()) && Objects.equals(this.timePeriod(), other.timePeriod()) && Objects.equals(this.spendingLimit(), other.spendingLimit()) && Objects.equals(this.queuedSpend(), other.queuedSpend()) && Objects.equals(this.totalSpend(), other.totalSpend()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"SpendingLimitSummary").add("SpendingLimitArn", (Object)this.spendingLimitArn()).add("DeviceArn", (Object)this.deviceArn()).add("TimePeriod", (Object)this.timePeriod()).add("SpendingLimit", (Object)this.spendingLimit()).add("QueuedSpend", (Object)this.queuedSpend()).add("TotalSpend", (Object)this.totalSpend()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "spendingLimitArn": {
                return Optional.ofNullable(clazz.cast(this.spendingLimitArn()));
            }
            case "deviceArn": {
                return Optional.ofNullable(clazz.cast(this.deviceArn()));
            }
            case "timePeriod": {
                return Optional.ofNullable(clazz.cast(this.timePeriod()));
            }
            case "spendingLimit": {
                return Optional.ofNullable(clazz.cast(this.spendingLimit()));
            }
            case "queuedSpend": {
                return Optional.ofNullable(clazz.cast(this.queuedSpend()));
            }
            case "totalSpend": {
                return Optional.ofNullable(clazz.cast(this.totalSpend()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("spendingLimitArn", SPENDING_LIMIT_ARN_FIELD);
        map.put("deviceArn", DEVICE_ARN_FIELD);
        map.put("timePeriod", TIME_PERIOD_FIELD);
        map.put("spendingLimit", SPENDING_LIMIT_FIELD);
        map.put("queuedSpend", QUEUED_SPEND_FIELD);
        map.put("totalSpend", TOTAL_SPEND_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SpendingLimitSummary, T> g) {
        return obj -> g.apply((SpendingLimitSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String spendingLimitArn;
        private String deviceArn;
        private TimePeriod timePeriod;
        private String spendingLimit;
        private String queuedSpend;
        private String totalSpend;
        private Instant createdAt;
        private Instant updatedAt;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SpendingLimitSummary model) {
            this.spendingLimitArn(model.spendingLimitArn);
            this.deviceArn(model.deviceArn);
            this.timePeriod(model.timePeriod);
            this.spendingLimit(model.spendingLimit);
            this.queuedSpend(model.queuedSpend);
            this.totalSpend(model.totalSpend);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.tags(model.tags);
        }

        public final String getSpendingLimitArn() {
            return this.spendingLimitArn;
        }

        public final void setSpendingLimitArn(String spendingLimitArn) {
            this.spendingLimitArn = spendingLimitArn;
        }

        @Override
        public final Builder spendingLimitArn(String spendingLimitArn) {
            this.spendingLimitArn = spendingLimitArn;
            return this;
        }

        public final String getDeviceArn() {
            return this.deviceArn;
        }

        public final void setDeviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
        }

        @Override
        public final Builder deviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
            return this;
        }

        public final TimePeriod.Builder getTimePeriod() {
            return this.timePeriod != null ? this.timePeriod.toBuilder() : null;
        }

        public final void setTimePeriod(TimePeriod.BuilderImpl timePeriod) {
            this.timePeriod = timePeriod != null ? timePeriod.build() : null;
        }

        @Override
        public final Builder timePeriod(TimePeriod timePeriod) {
            this.timePeriod = timePeriod;
            return this;
        }

        public final String getSpendingLimit() {
            return this.spendingLimit;
        }

        public final void setSpendingLimit(String spendingLimit) {
            this.spendingLimit = spendingLimit;
        }

        @Override
        public final Builder spendingLimit(String spendingLimit) {
            this.spendingLimit = spendingLimit;
            return this;
        }

        public final String getQueuedSpend() {
            return this.queuedSpend;
        }

        public final void setQueuedSpend(String queuedSpend) {
            this.queuedSpend = queuedSpend;
        }

        @Override
        public final Builder queuedSpend(String queuedSpend) {
            this.queuedSpend = queuedSpend;
            return this;
        }

        public final String getTotalSpend() {
            return this.totalSpend;
        }

        public final void setTotalSpend(String totalSpend) {
            this.totalSpend = totalSpend;
        }

        @Override
        public final Builder totalSpend(String totalSpend) {
            this.totalSpend = totalSpend;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public SpendingLimitSummary build() {
            return new SpendingLimitSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SpendingLimitSummary> {
        public Builder spendingLimitArn(String var1);

        public Builder deviceArn(String var1);

        public Builder timePeriod(TimePeriod var1);

        default public Builder timePeriod(Consumer<TimePeriod.Builder> timePeriod) {
            return this.timePeriod((TimePeriod)((TimePeriod.Builder)TimePeriod.builder().applyMutation(timePeriod)).build());
        }

        public Builder spendingLimit(String var1);

        public Builder queuedSpend(String var1);

        public Builder totalSpend(String var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder tags(Map<String, String> var1);
    }
}

