/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.braket.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.braket.model.QueueName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HybridJobQueueInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HybridJobQueueInfo> {
    private static final SdkField<String> QUEUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queue").getter(HybridJobQueueInfo.getter(HybridJobQueueInfo::queueAsString)).setter(HybridJobQueueInfo.setter(Builder::queue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queue").build()}).build();
    private static final SdkField<String> POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("position").getter(HybridJobQueueInfo.getter(HybridJobQueueInfo::position)).setter(HybridJobQueueInfo.setter(Builder::position)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("position").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(HybridJobQueueInfo.getter(HybridJobQueueInfo::message)).setter(HybridJobQueueInfo.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUE_FIELD, POSITION_FIELD, MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = HybridJobQueueInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String queue;
    private final String position;
    private final String message;

    private HybridJobQueueInfo(BuilderImpl builder) {
        this.queue = builder.queue;
        this.position = builder.position;
        this.message = builder.message;
    }

    public final QueueName queue() {
        return QueueName.fromValue(this.queue);
    }

    public final String queueAsString() {
        return this.queue;
    }

    public final String position() {
        return this.position;
    }

    public final String message() {
        return this.message;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.queueAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.position());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HybridJobQueueInfo)) {
            return false;
        }
        HybridJobQueueInfo other = (HybridJobQueueInfo)obj;
        return Objects.equals(this.queueAsString(), other.queueAsString()) && Objects.equals(this.position(), other.position()) && Objects.equals(this.message(), other.message());
    }

    public final String toString() {
        return ToString.builder((String)"HybridJobQueueInfo").add("Queue", (Object)this.queueAsString()).add("Position", (Object)this.position()).add("Message", (Object)this.message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "queue": {
                return Optional.ofNullable(clazz.cast(this.queueAsString()));
            }
            case "position": {
                return Optional.ofNullable(clazz.cast(this.position()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("queue", QUEUE_FIELD);
        map.put("position", POSITION_FIELD);
        map.put("message", MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HybridJobQueueInfo, T> g) {
        return obj -> g.apply((HybridJobQueueInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String queue;
        private String position;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(HybridJobQueueInfo model) {
            this.queue(model.queue);
            this.position(model.position);
            this.message(model.message);
        }

        public final String getQueue() {
            return this.queue;
        }

        public final void setQueue(String queue) {
            this.queue = queue;
        }

        @Override
        public final Builder queue(String queue) {
            this.queue = queue;
            return this;
        }

        @Override
        public final Builder queue(QueueName queue) {
            this.queue(queue == null ? null : queue.toString());
            return this;
        }

        public final String getPosition() {
            return this.position;
        }

        public final void setPosition(String position) {
            this.position = position;
        }

        @Override
        public final Builder position(String position) {
            this.position = position;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public HybridJobQueueInfo build() {
            return new HybridJobQueueInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HybridJobQueueInfo> {
        public Builder queue(String var1);

        public Builder queue(QueueName var1);

        public Builder position(String var1);

        public Builder message(String var1);
    }
}

