/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BillingGroupType {
    STANDARD("STANDARD"),
    TRANSFER_BILLING("TRANSFER_BILLING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BillingGroupType> VALUE_MAP;
    private final String value;

    private BillingGroupType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BillingGroupType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BillingGroupType> knownValues() {
        EnumSet<BillingGroupType> knownValues = EnumSet.allOf(BillingGroupType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BillingGroupType.class, BillingGroupType::toString);
    }
}

