/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billing;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.billing.BillingAsyncClientBuilder;
import software.amazon.awssdk.services.billing.BillingServiceClientConfiguration;
import software.amazon.awssdk.services.billing.DefaultBillingAsyncClientBuilder;
import software.amazon.awssdk.services.billing.model.CreateBillingViewRequest;
import software.amazon.awssdk.services.billing.model.CreateBillingViewResponse;
import software.amazon.awssdk.services.billing.model.DeleteBillingViewRequest;
import software.amazon.awssdk.services.billing.model.DeleteBillingViewResponse;
import software.amazon.awssdk.services.billing.model.GetBillingViewRequest;
import software.amazon.awssdk.services.billing.model.GetBillingViewResponse;
import software.amazon.awssdk.services.billing.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.billing.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.billing.model.ListBillingViewsRequest;
import software.amazon.awssdk.services.billing.model.ListBillingViewsResponse;
import software.amazon.awssdk.services.billing.model.ListSourceViewsForBillingViewRequest;
import software.amazon.awssdk.services.billing.model.ListSourceViewsForBillingViewResponse;
import software.amazon.awssdk.services.billing.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.billing.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.billing.model.TagResourceRequest;
import software.amazon.awssdk.services.billing.model.TagResourceResponse;
import software.amazon.awssdk.services.billing.model.UntagResourceRequest;
import software.amazon.awssdk.services.billing.model.UntagResourceResponse;
import software.amazon.awssdk.services.billing.model.UpdateBillingViewRequest;
import software.amazon.awssdk.services.billing.model.UpdateBillingViewResponse;
import software.amazon.awssdk.services.billing.paginators.ListBillingViewsPublisher;
import software.amazon.awssdk.services.billing.paginators.ListSourceViewsForBillingViewPublisher;

@SdkPublicApi
@ThreadSafe
public interface BillingAsyncClient
extends AwsClient {
    public static final String SERVICE_NAME = "billing";
    public static final String SERVICE_METADATA_ID = "billing";

    default public CompletableFuture<CreateBillingViewResponse> createBillingView(CreateBillingViewRequest createBillingViewRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<CreateBillingViewResponse> createBillingView(Consumer<CreateBillingViewRequest.Builder> createBillingViewRequest) {
        return this.createBillingView((CreateBillingViewRequest)((Object)((CreateBillingViewRequest.Builder)CreateBillingViewRequest.builder().applyMutation(createBillingViewRequest)).build()));
    }

    default public CompletableFuture<DeleteBillingViewResponse> deleteBillingView(DeleteBillingViewRequest deleteBillingViewRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DeleteBillingViewResponse> deleteBillingView(Consumer<DeleteBillingViewRequest.Builder> deleteBillingViewRequest) {
        return this.deleteBillingView((DeleteBillingViewRequest)((Object)((DeleteBillingViewRequest.Builder)DeleteBillingViewRequest.builder().applyMutation(deleteBillingViewRequest)).build()));
    }

    default public CompletableFuture<GetBillingViewResponse> getBillingView(GetBillingViewRequest getBillingViewRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetBillingViewResponse> getBillingView(Consumer<GetBillingViewRequest.Builder> getBillingViewRequest) {
        return this.getBillingView((GetBillingViewRequest)((Object)((GetBillingViewRequest.Builder)GetBillingViewRequest.builder().applyMutation(getBillingViewRequest)).build()));
    }

    default public CompletableFuture<GetResourcePolicyResponse> getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetResourcePolicyResponse> getResourcePolicy(Consumer<GetResourcePolicyRequest.Builder> getResourcePolicyRequest) {
        return this.getResourcePolicy((GetResourcePolicyRequest)((Object)((GetResourcePolicyRequest.Builder)GetResourcePolicyRequest.builder().applyMutation(getResourcePolicyRequest)).build()));
    }

    default public CompletableFuture<ListBillingViewsResponse> listBillingViews(ListBillingViewsRequest listBillingViewsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListBillingViewsResponse> listBillingViews(Consumer<ListBillingViewsRequest.Builder> listBillingViewsRequest) {
        return this.listBillingViews((ListBillingViewsRequest)((Object)((ListBillingViewsRequest.Builder)ListBillingViewsRequest.builder().applyMutation(listBillingViewsRequest)).build()));
    }

    default public ListBillingViewsPublisher listBillingViewsPaginator(ListBillingViewsRequest listBillingViewsRequest) {
        return new ListBillingViewsPublisher(this, listBillingViewsRequest);
    }

    default public ListBillingViewsPublisher listBillingViewsPaginator(Consumer<ListBillingViewsRequest.Builder> listBillingViewsRequest) {
        return this.listBillingViewsPaginator((ListBillingViewsRequest)((Object)((ListBillingViewsRequest.Builder)ListBillingViewsRequest.builder().applyMutation(listBillingViewsRequest)).build()));
    }

    default public CompletableFuture<ListSourceViewsForBillingViewResponse> listSourceViewsForBillingView(ListSourceViewsForBillingViewRequest listSourceViewsForBillingViewRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListSourceViewsForBillingViewResponse> listSourceViewsForBillingView(Consumer<ListSourceViewsForBillingViewRequest.Builder> listSourceViewsForBillingViewRequest) {
        return this.listSourceViewsForBillingView((ListSourceViewsForBillingViewRequest)((Object)((ListSourceViewsForBillingViewRequest.Builder)ListSourceViewsForBillingViewRequest.builder().applyMutation(listSourceViewsForBillingViewRequest)).build()));
    }

    default public ListSourceViewsForBillingViewPublisher listSourceViewsForBillingViewPaginator(ListSourceViewsForBillingViewRequest listSourceViewsForBillingViewRequest) {
        return new ListSourceViewsForBillingViewPublisher(this, listSourceViewsForBillingViewRequest);
    }

    default public ListSourceViewsForBillingViewPublisher listSourceViewsForBillingViewPaginator(Consumer<ListSourceViewsForBillingViewRequest.Builder> listSourceViewsForBillingViewRequest) {
        return this.listSourceViewsForBillingViewPaginator((ListSourceViewsForBillingViewRequest)((Object)((ListSourceViewsForBillingViewRequest.Builder)ListSourceViewsForBillingViewRequest.builder().applyMutation(listSourceViewsForBillingViewRequest)).build()));
    }

    default public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return this.listTagsForResource((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return this.tagResource((TagResourceRequest)((Object)((TagResourceRequest.Builder)TagResourceRequest.builder().applyMutation(tagResourceRequest)).build()));
    }

    default public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return this.untagResource((UntagResourceRequest)((Object)((UntagResourceRequest.Builder)UntagResourceRequest.builder().applyMutation(untagResourceRequest)).build()));
    }

    default public CompletableFuture<UpdateBillingViewResponse> updateBillingView(UpdateBillingViewRequest updateBillingViewRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<UpdateBillingViewResponse> updateBillingView(Consumer<UpdateBillingViewRequest.Builder> updateBillingViewRequest) {
        return this.updateBillingView((UpdateBillingViewRequest)((Object)((UpdateBillingViewRequest.Builder)UpdateBillingViewRequest.builder().applyMutation(updateBillingViewRequest)).build()));
    }

    default public BillingServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    public static BillingAsyncClient create() {
        return (BillingAsyncClient)BillingAsyncClient.builder().build();
    }

    public static BillingAsyncClientBuilder builder() {
        return new DefaultBillingAsyncClientBuilder();
    }
}

