/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockruntime.model.BedrockRuntimeRequest;
import software.amazon.awssdk.services.bedrockruntime.model.PerformanceConfigLatency;
import software.amazon.awssdk.services.bedrockruntime.model.ServiceTierType;
import software.amazon.awssdk.services.bedrockruntime.model.Trace;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvokeModelWithResponseStreamRequest
extends BedrockRuntimeRequest
implements ToCopyableBuilder<Builder, InvokeModelWithResponseStreamRequest> {
    private static final SdkField<SdkBytes> BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("body").getter(InvokeModelWithResponseStreamRequest.getter(InvokeModelWithResponseStreamRequest::body)).setter(InvokeModelWithResponseStreamRequest.setter(Builder::body)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentType").getter(InvokeModelWithResponseStreamRequest.getter(InvokeModelWithResponseStreamRequest::contentType)).setter(InvokeModelWithResponseStreamRequest.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()}).build();
    private static final SdkField<String> ACCEPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accept").getter(InvokeModelWithResponseStreamRequest.getter(InvokeModelWithResponseStreamRequest::accept)).setter(InvokeModelWithResponseStreamRequest.setter(Builder::accept)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Bedrock-Accept").build()}).build();
    private static final SdkField<String> MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelId").getter(InvokeModelWithResponseStreamRequest.getter(InvokeModelWithResponseStreamRequest::modelId)).setter(InvokeModelWithResponseStreamRequest.setter(Builder::modelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("modelId").build()}).build();
    private static final SdkField<String> TRACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trace").getter(InvokeModelWithResponseStreamRequest.getter(InvokeModelWithResponseStreamRequest::traceAsString)).setter(InvokeModelWithResponseStreamRequest.setter(Builder::trace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Bedrock-Trace").build()}).build();
    private static final SdkField<String> GUARDRAIL_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("guardrailIdentifier").getter(InvokeModelWithResponseStreamRequest.getter(InvokeModelWithResponseStreamRequest::guardrailIdentifier)).setter(InvokeModelWithResponseStreamRequest.setter(Builder::guardrailIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Bedrock-GuardrailIdentifier").build()}).build();
    private static final SdkField<String> GUARDRAIL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("guardrailVersion").getter(InvokeModelWithResponseStreamRequest.getter(InvokeModelWithResponseStreamRequest::guardrailVersion)).setter(InvokeModelWithResponseStreamRequest.setter(Builder::guardrailVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Bedrock-GuardrailVersion").build()}).build();
    private static final SdkField<String> PERFORMANCE_CONFIG_LATENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("performanceConfigLatency").getter(InvokeModelWithResponseStreamRequest.getter(InvokeModelWithResponseStreamRequest::performanceConfigLatencyAsString)).setter(InvokeModelWithResponseStreamRequest.setter(Builder::performanceConfigLatency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Bedrock-PerformanceConfig-Latency").build()}).build();
    private static final SdkField<String> SERVICE_TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceTier").getter(InvokeModelWithResponseStreamRequest.getter(InvokeModelWithResponseStreamRequest::serviceTierAsString)).setter(InvokeModelWithResponseStreamRequest.setter(Builder::serviceTier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Bedrock-Service-Tier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BODY_FIELD, CONTENT_TYPE_FIELD, ACCEPT_FIELD, MODEL_ID_FIELD, TRACE_FIELD, GUARDRAIL_IDENTIFIER_FIELD, GUARDRAIL_VERSION_FIELD, PERFORMANCE_CONFIG_LATENCY_FIELD, SERVICE_TIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InvokeModelWithResponseStreamRequest.memberNameToFieldInitializer();
    private final SdkBytes body;
    private final String contentType;
    private final String accept;
    private final String modelId;
    private final String trace;
    private final String guardrailIdentifier;
    private final String guardrailVersion;
    private final String performanceConfigLatency;
    private final String serviceTier;

    private InvokeModelWithResponseStreamRequest(BuilderImpl builder) {
        super(builder);
        this.body = builder.body;
        this.contentType = builder.contentType;
        this.accept = builder.accept;
        this.modelId = builder.modelId;
        this.trace = builder.trace;
        this.guardrailIdentifier = builder.guardrailIdentifier;
        this.guardrailVersion = builder.guardrailVersion;
        this.performanceConfigLatency = builder.performanceConfigLatency;
        this.serviceTier = builder.serviceTier;
    }

    public final SdkBytes body() {
        return this.body;
    }

    public final String contentType() {
        return this.contentType;
    }

    public final String accept() {
        return this.accept;
    }

    public final String modelId() {
        return this.modelId;
    }

    public final Trace trace() {
        return Trace.fromValue(this.trace);
    }

    public final String traceAsString() {
        return this.trace;
    }

    public final String guardrailIdentifier() {
        return this.guardrailIdentifier;
    }

    public final String guardrailVersion() {
        return this.guardrailVersion;
    }

    public final PerformanceConfigLatency performanceConfigLatency() {
        return PerformanceConfigLatency.fromValue(this.performanceConfigLatency);
    }

    public final String performanceConfigLatencyAsString() {
        return this.performanceConfigLatency;
    }

    public final ServiceTierType serviceTier() {
        return ServiceTierType.fromValue(this.serviceTier);
    }

    public final String serviceTierAsString() {
        return this.serviceTier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.accept());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.traceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.guardrailIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.guardrailVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.performanceConfigLatencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceTierAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeModelWithResponseStreamRequest)) {
            return false;
        }
        InvokeModelWithResponseStreamRequest other = (InvokeModelWithResponseStreamRequest)((Object)obj);
        return Objects.equals(this.body(), other.body()) && Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.accept(), other.accept()) && Objects.equals(this.modelId(), other.modelId()) && Objects.equals(this.traceAsString(), other.traceAsString()) && Objects.equals(this.guardrailIdentifier(), other.guardrailIdentifier()) && Objects.equals(this.guardrailVersion(), other.guardrailVersion()) && Objects.equals(this.performanceConfigLatencyAsString(), other.performanceConfigLatencyAsString()) && Objects.equals(this.serviceTierAsString(), other.serviceTierAsString());
    }

    public final String toString() {
        return ToString.builder((String)"InvokeModelWithResponseStreamRequest").add("Body", (Object)(this.body() == null ? null : "*** Sensitive Data Redacted ***")).add("ContentType", (Object)this.contentType()).add("Accept", (Object)this.accept()).add("ModelId", (Object)this.modelId()).add("Trace", (Object)this.traceAsString()).add("GuardrailIdentifier", (Object)this.guardrailIdentifier()).add("GuardrailVersion", (Object)this.guardrailVersion()).add("PerformanceConfigLatency", (Object)this.performanceConfigLatencyAsString()).add("ServiceTier", (Object)this.serviceTierAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
            case "contentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "accept": {
                return Optional.ofNullable(clazz.cast(this.accept()));
            }
            case "modelId": {
                return Optional.ofNullable(clazz.cast(this.modelId()));
            }
            case "trace": {
                return Optional.ofNullable(clazz.cast(this.traceAsString()));
            }
            case "guardrailIdentifier": {
                return Optional.ofNullable(clazz.cast(this.guardrailIdentifier()));
            }
            case "guardrailVersion": {
                return Optional.ofNullable(clazz.cast(this.guardrailVersion()));
            }
            case "performanceConfigLatency": {
                return Optional.ofNullable(clazz.cast(this.performanceConfigLatencyAsString()));
            }
            case "serviceTier": {
                return Optional.ofNullable(clazz.cast(this.serviceTierAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("body", BODY_FIELD);
        map.put("Content-Type", CONTENT_TYPE_FIELD);
        map.put("X-Amzn-Bedrock-Accept", ACCEPT_FIELD);
        map.put("modelId", MODEL_ID_FIELD);
        map.put("X-Amzn-Bedrock-Trace", TRACE_FIELD);
        map.put("X-Amzn-Bedrock-GuardrailIdentifier", GUARDRAIL_IDENTIFIER_FIELD);
        map.put("X-Amzn-Bedrock-GuardrailVersion", GUARDRAIL_VERSION_FIELD);
        map.put("X-Amzn-Bedrock-PerformanceConfig-Latency", PERFORMANCE_CONFIG_LATENCY_FIELD);
        map.put("X-Amzn-Bedrock-Service-Tier", SERVICE_TIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvokeModelWithResponseStreamRequest, T> g) {
        return obj -> g.apply((InvokeModelWithResponseStreamRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockRuntimeRequest.BuilderImpl
    implements Builder {
        private SdkBytes body;
        private String contentType;
        private String accept;
        private String modelId;
        private String trace;
        private String guardrailIdentifier;
        private String guardrailVersion;
        private String performanceConfigLatency;
        private String serviceTier;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeModelWithResponseStreamRequest model) {
            super(model);
            this.body(model.body);
            this.contentType(model.contentType);
            this.accept(model.accept);
            this.modelId(model.modelId);
            this.trace(model.trace);
            this.guardrailIdentifier(model.guardrailIdentifier);
            this.guardrailVersion(model.guardrailVersion);
            this.performanceConfigLatency(model.performanceConfigLatency);
            this.serviceTier(model.serviceTier);
        }

        public final ByteBuffer getBody() {
            return this.body == null ? null : this.body.asByteBuffer();
        }

        public final void setBody(ByteBuffer body) {
            this.body(body == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)body));
        }

        @Override
        public final Builder body(SdkBytes body) {
            this.body = body;
            return this;
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final String getAccept() {
            return this.accept;
        }

        public final void setAccept(String accept) {
            this.accept = accept;
        }

        @Override
        public final Builder accept(String accept) {
            this.accept = accept;
            return this;
        }

        public final String getModelId() {
            return this.modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final String getTrace() {
            return this.trace;
        }

        public final void setTrace(String trace) {
            this.trace = trace;
        }

        @Override
        public final Builder trace(String trace) {
            this.trace = trace;
            return this;
        }

        @Override
        public final Builder trace(Trace trace) {
            this.trace(trace == null ? null : trace.toString());
            return this;
        }

        public final String getGuardrailIdentifier() {
            return this.guardrailIdentifier;
        }

        public final void setGuardrailIdentifier(String guardrailIdentifier) {
            this.guardrailIdentifier = guardrailIdentifier;
        }

        @Override
        public final Builder guardrailIdentifier(String guardrailIdentifier) {
            this.guardrailIdentifier = guardrailIdentifier;
            return this;
        }

        public final String getGuardrailVersion() {
            return this.guardrailVersion;
        }

        public final void setGuardrailVersion(String guardrailVersion) {
            this.guardrailVersion = guardrailVersion;
        }

        @Override
        public final Builder guardrailVersion(String guardrailVersion) {
            this.guardrailVersion = guardrailVersion;
            return this;
        }

        public final String getPerformanceConfigLatency() {
            return this.performanceConfigLatency;
        }

        public final void setPerformanceConfigLatency(String performanceConfigLatency) {
            this.performanceConfigLatency = performanceConfigLatency;
        }

        @Override
        public final Builder performanceConfigLatency(String performanceConfigLatency) {
            this.performanceConfigLatency = performanceConfigLatency;
            return this;
        }

        @Override
        public final Builder performanceConfigLatency(PerformanceConfigLatency performanceConfigLatency) {
            this.performanceConfigLatency(performanceConfigLatency == null ? null : performanceConfigLatency.toString());
            return this;
        }

        public final String getServiceTier() {
            return this.serviceTier;
        }

        public final void setServiceTier(String serviceTier) {
            this.serviceTier = serviceTier;
        }

        @Override
        public final Builder serviceTier(String serviceTier) {
            this.serviceTier = serviceTier;
            return this;
        }

        @Override
        public final Builder serviceTier(ServiceTierType serviceTier) {
            this.serviceTier(serviceTier == null ? null : serviceTier.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InvokeModelWithResponseStreamRequest build() {
            return new InvokeModelWithResponseStreamRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockRuntimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, InvokeModelWithResponseStreamRequest> {
        public Builder body(SdkBytes var1);

        public Builder contentType(String var1);

        public Builder accept(String var1);

        public Builder modelId(String var1);

        public Builder trace(String var1);

        public Builder trace(Trace var1);

        public Builder guardrailIdentifier(String var1);

        public Builder guardrailVersion(String var1);

        public Builder performanceConfigLatency(String var1);

        public Builder performanceConfigLatency(PerformanceConfigLatency var1);

        public Builder serviceTier(String var1);

        public Builder serviceTier(ServiceTierType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

