/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockruntime.model.BedrockRuntimeResponse;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailAction;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailAssessment;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailAssessmentListCopier;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailCoverage;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailOutputContent;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailOutputContentListCopier;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailUsage;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplyGuardrailResponse
extends BedrockRuntimeResponse
implements ToCopyableBuilder<Builder, ApplyGuardrailResponse> {
    private static final SdkField<GuardrailUsage> USAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("usage").getter(ApplyGuardrailResponse.getter(ApplyGuardrailResponse::usage)).setter(ApplyGuardrailResponse.setter(Builder::usage)).constructor(GuardrailUsage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usage").build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("action").getter(ApplyGuardrailResponse.getter(ApplyGuardrailResponse::actionAsString)).setter(ApplyGuardrailResponse.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()}).build();
    private static final SdkField<String> ACTION_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionReason").getter(ApplyGuardrailResponse.getter(ApplyGuardrailResponse::actionReason)).setter(ApplyGuardrailResponse.setter(Builder::actionReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionReason").build()}).build();
    private static final SdkField<List<GuardrailOutputContent>> OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("outputs").getter(ApplyGuardrailResponse.getter(ApplyGuardrailResponse::outputs)).setter(ApplyGuardrailResponse.setter(Builder::outputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GuardrailOutputContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<GuardrailAssessment>> ASSESSMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assessments").getter(ApplyGuardrailResponse.getter(ApplyGuardrailResponse::assessments)).setter(ApplyGuardrailResponse.setter(Builder::assessments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GuardrailAssessment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<GuardrailCoverage> GUARDRAIL_COVERAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("guardrailCoverage").getter(ApplyGuardrailResponse.getter(ApplyGuardrailResponse::guardrailCoverage)).setter(ApplyGuardrailResponse.setter(Builder::guardrailCoverage)).constructor(GuardrailCoverage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailCoverage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USAGE_FIELD, ACTION_FIELD, ACTION_REASON_FIELD, OUTPUTS_FIELD, ASSESSMENTS_FIELD, GUARDRAIL_COVERAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ApplyGuardrailResponse.memberNameToFieldInitializer();
    private final GuardrailUsage usage;
    private final String action;
    private final String actionReason;
    private final List<GuardrailOutputContent> outputs;
    private final List<GuardrailAssessment> assessments;
    private final GuardrailCoverage guardrailCoverage;

    private ApplyGuardrailResponse(BuilderImpl builder) {
        super(builder);
        this.usage = builder.usage;
        this.action = builder.action;
        this.actionReason = builder.actionReason;
        this.outputs = builder.outputs;
        this.assessments = builder.assessments;
        this.guardrailCoverage = builder.guardrailCoverage;
    }

    public final GuardrailUsage usage() {
        return this.usage;
    }

    public final GuardrailAction action() {
        return GuardrailAction.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final String actionReason() {
        return this.actionReason;
    }

    public final boolean hasOutputs() {
        return this.outputs != null && !(this.outputs instanceof SdkAutoConstructList);
    }

    public final List<GuardrailOutputContent> outputs() {
        return this.outputs;
    }

    public final boolean hasAssessments() {
        return this.assessments != null && !(this.assessments instanceof SdkAutoConstructList);
    }

    public final List<GuardrailAssessment> assessments() {
        return this.assessments;
    }

    public final GuardrailCoverage guardrailCoverage() {
        return this.guardrailCoverage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.usage());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputs() ? this.outputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssessments() ? this.assessments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.guardrailCoverage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplyGuardrailResponse)) {
            return false;
        }
        ApplyGuardrailResponse other = (ApplyGuardrailResponse)((Object)obj);
        return Objects.equals(this.usage(), other.usage()) && Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.actionReason(), other.actionReason()) && this.hasOutputs() == other.hasOutputs() && Objects.equals(this.outputs(), other.outputs()) && this.hasAssessments() == other.hasAssessments() && Objects.equals(this.assessments(), other.assessments()) && Objects.equals(this.guardrailCoverage(), other.guardrailCoverage());
    }

    public final String toString() {
        return ToString.builder((String)"ApplyGuardrailResponse").add("Usage", (Object)this.usage()).add("Action", (Object)this.actionAsString()).add("ActionReason", (Object)this.actionReason()).add("Outputs", this.hasOutputs() ? this.outputs() : null).add("Assessments", this.hasAssessments() ? this.assessments() : null).add("GuardrailCoverage", (Object)this.guardrailCoverage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "usage": {
                return Optional.ofNullable(clazz.cast(this.usage()));
            }
            case "action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "actionReason": {
                return Optional.ofNullable(clazz.cast(this.actionReason()));
            }
            case "outputs": {
                return Optional.ofNullable(clazz.cast(this.outputs()));
            }
            case "assessments": {
                return Optional.ofNullable(clazz.cast(this.assessments()));
            }
            case "guardrailCoverage": {
                return Optional.ofNullable(clazz.cast(this.guardrailCoverage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("usage", USAGE_FIELD);
        map.put("action", ACTION_FIELD);
        map.put("actionReason", ACTION_REASON_FIELD);
        map.put("outputs", OUTPUTS_FIELD);
        map.put("assessments", ASSESSMENTS_FIELD);
        map.put("guardrailCoverage", GUARDRAIL_COVERAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApplyGuardrailResponse, T> g) {
        return obj -> g.apply((ApplyGuardrailResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockRuntimeResponse.BuilderImpl
    implements Builder {
        private GuardrailUsage usage;
        private String action;
        private String actionReason;
        private List<GuardrailOutputContent> outputs = DefaultSdkAutoConstructList.getInstance();
        private List<GuardrailAssessment> assessments = DefaultSdkAutoConstructList.getInstance();
        private GuardrailCoverage guardrailCoverage;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplyGuardrailResponse model) {
            super(model);
            this.usage(model.usage);
            this.action(model.action);
            this.actionReason(model.actionReason);
            this.outputs(model.outputs);
            this.assessments(model.assessments);
            this.guardrailCoverage(model.guardrailCoverage);
        }

        public final GuardrailUsage.Builder getUsage() {
            return this.usage != null ? this.usage.toBuilder() : null;
        }

        public final void setUsage(GuardrailUsage.BuilderImpl usage) {
            this.usage = usage != null ? usage.build() : null;
        }

        @Override
        public final Builder usage(GuardrailUsage usage) {
            this.usage = usage;
            return this;
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(GuardrailAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getActionReason() {
            return this.actionReason;
        }

        public final void setActionReason(String actionReason) {
            this.actionReason = actionReason;
        }

        @Override
        public final Builder actionReason(String actionReason) {
            this.actionReason = actionReason;
            return this;
        }

        public final List<GuardrailOutputContent.Builder> getOutputs() {
            List<GuardrailOutputContent.Builder> result = GuardrailOutputContentListCopier.copyToBuilder(this.outputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputs(Collection<GuardrailOutputContent.BuilderImpl> outputs) {
            this.outputs = GuardrailOutputContentListCopier.copyFromBuilder(outputs);
        }

        @Override
        public final Builder outputs(Collection<GuardrailOutputContent> outputs) {
            this.outputs = GuardrailOutputContentListCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(GuardrailOutputContent ... outputs) {
            this.outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<GuardrailOutputContent.Builder> ... outputs) {
            this.outputs(Stream.of(outputs).map(c -> (GuardrailOutputContent)((GuardrailOutputContent.Builder)GuardrailOutputContent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<GuardrailAssessment.Builder> getAssessments() {
            List<GuardrailAssessment.Builder> result = GuardrailAssessmentListCopier.copyToBuilder(this.assessments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssessments(Collection<GuardrailAssessment.BuilderImpl> assessments) {
            this.assessments = GuardrailAssessmentListCopier.copyFromBuilder(assessments);
        }

        @Override
        public final Builder assessments(Collection<GuardrailAssessment> assessments) {
            this.assessments = GuardrailAssessmentListCopier.copy(assessments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessments(GuardrailAssessment ... assessments) {
            this.assessments(Arrays.asList(assessments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessments(Consumer<GuardrailAssessment.Builder> ... assessments) {
            this.assessments(Stream.of(assessments).map(c -> (GuardrailAssessment)((GuardrailAssessment.Builder)GuardrailAssessment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final GuardrailCoverage.Builder getGuardrailCoverage() {
            return this.guardrailCoverage != null ? this.guardrailCoverage.toBuilder() : null;
        }

        public final void setGuardrailCoverage(GuardrailCoverage.BuilderImpl guardrailCoverage) {
            this.guardrailCoverage = guardrailCoverage != null ? guardrailCoverage.build() : null;
        }

        @Override
        public final Builder guardrailCoverage(GuardrailCoverage guardrailCoverage) {
            this.guardrailCoverage = guardrailCoverage;
            return this;
        }

        @Override
        public ApplyGuardrailResponse build() {
            return new ApplyGuardrailResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockRuntimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ApplyGuardrailResponse> {
        public Builder usage(GuardrailUsage var1);

        default public Builder usage(Consumer<GuardrailUsage.Builder> usage) {
            return this.usage((GuardrailUsage)((GuardrailUsage.Builder)GuardrailUsage.builder().applyMutation(usage)).build());
        }

        public Builder action(String var1);

        public Builder action(GuardrailAction var1);

        public Builder actionReason(String var1);

        public Builder outputs(Collection<GuardrailOutputContent> var1);

        public Builder outputs(GuardrailOutputContent ... var1);

        public Builder outputs(Consumer<GuardrailOutputContent.Builder> ... var1);

        public Builder assessments(Collection<GuardrailAssessment> var1);

        public Builder assessments(GuardrailAssessment ... var1);

        public Builder assessments(Consumer<GuardrailAssessment.Builder> ... var1);

        public Builder guardrailCoverage(GuardrailCoverage var1);

        default public Builder guardrailCoverage(Consumer<GuardrailCoverage.Builder> guardrailCoverage) {
            return this.guardrailCoverage((GuardrailCoverage)((GuardrailCoverage.Builder)GuardrailCoverage.builder().applyMutation(guardrailCoverage)).build());
        }
    }
}

