/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model.invokemodelwithbidirectionalstreaminput;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.bedrockruntime.model.BidirectionalInputPayloadPart;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelWithBidirectionalStreamInput;

/**
 * A specialization of {@code software.amazon.awssdk.services.bedrockruntime.model.BidirectionalInputPayloadPart} that
 * represents the {@code InvokeModelWithBidirectionalStreamInput$chunk} event. Do not use this class directly. Instead,
 * use the static builder methods on
 * {@link software.amazon.awssdk.services.bedrockruntime.model.InvokeModelWithBidirectionalStreamInput}.
 */
@SdkInternalApi
@Generated("software.amazon.awssdk:codegen")
public final class DefaultChunk extends BidirectionalInputPayloadPart {
    private static final long serialVersionUID = 1L;

    DefaultChunk(BuilderImpl builderImpl) {
        super(builderImpl);
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    @Override
    public InvokeModelWithBidirectionalStreamInput.EventType sdkEventType() {
        return InvokeModelWithBidirectionalStreamInput.EventType.CHUNK;
    }

    public interface Builder extends BidirectionalInputPayloadPart.Builder {
        @Override
        DefaultChunk build();
    }

    private static final class BuilderImpl extends BidirectionalInputPayloadPart.BuilderImpl implements Builder {
        private BuilderImpl() {
        }

        private BuilderImpl(DefaultChunk event) {
            super(event);
        }

        @Override
        public DefaultChunk build() {
            return new DefaultChunk(this);
        }
    }
}
