/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model.conversestreamoutput;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamOutput;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamResponseHandler;
import software.amazon.awssdk.services.bedrockruntime.model.MessageStartEvent;

/**
 * A specialization of {@code software.amazon.awssdk.services.bedrockruntime.model.MessageStartEvent} that represents
 * the {@code ConverseStreamOutput$messageStart} event. Do not use this class directly. Instead, use the static builder
 * methods on {@link software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamOutput}.
 */
@SdkInternalApi
@Generated("software.amazon.awssdk:codegen")
public final class DefaultMessageStart extends MessageStartEvent {
    private static final long serialVersionUID = 1L;

    DefaultMessageStart(BuilderImpl builderImpl) {
        super(builderImpl);
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    @Override
    public void accept(ConverseStreamResponseHandler.Visitor visitor) {
        visitor.visitMessageStart(this);
    }

    @Override
    public ConverseStreamOutput.EventType sdkEventType() {
        return ConverseStreamOutput.EventType.MESSAGE_START;
    }

    public interface Builder extends MessageStartEvent.Builder {
        @Override
        DefaultMessageStart build();
    }

    private static final class BuilderImpl extends MessageStartEvent.BuilderImpl implements Builder {
        private BuilderImpl() {
        }

        private BuilderImpl(DefaultMessageStart event) {
            super(event);
        }

        @Override
        public DefaultMessageStart build() {
            return new DefaultMessageStart(this);
        }
    }
}
