/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The content block to be evaluated by the guardrail.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GuardrailContentBlock implements SdkPojo, Serializable,
        ToCopyableBuilder<GuardrailContentBlock.Builder, GuardrailContentBlock> {
    private static final SdkField<GuardrailTextBlock> TEXT_FIELD = SdkField
            .<GuardrailTextBlock> builder(MarshallingType.SDK_POJO).memberName("text")
            .getter(getter(GuardrailContentBlock::text)).setter(setter(Builder::text)).constructor(GuardrailTextBlock::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()).build();

    private static final SdkField<GuardrailImageBlock> IMAGE_FIELD = SdkField
            .<GuardrailImageBlock> builder(MarshallingType.SDK_POJO).memberName("image")
            .getter(getter(GuardrailContentBlock::image)).setter(setter(Builder::image))
            .constructor(GuardrailImageBlock::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("image").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_FIELD, IMAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final GuardrailTextBlock text;

    private final GuardrailImageBlock image;

    private final Type type;

    private GuardrailContentBlock(BuilderImpl builder) {
        this.text = builder.text;
        this.image = builder.image;
        this.type = builder.type;
    }

    /**
     * <p>
     * Text within content block to be evaluated by the guardrail.
     * </p>
     * 
     * @return Text within content block to be evaluated by the guardrail.
     */
    public final GuardrailTextBlock text() {
        return text;
    }

    /**
     * <p>
     * Image within guardrail content block to be evaluated by the guardrail.
     * </p>
     * 
     * @return Image within guardrail content block to be evaluated by the guardrail.
     */
    public final GuardrailImageBlock image() {
        return image;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(text());
        hashCode = 31 * hashCode + Objects.hashCode(image());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailContentBlock)) {
            return false;
        }
        GuardrailContentBlock other = (GuardrailContentBlock) obj;
        return Objects.equals(text(), other.text()) && Objects.equals(image(), other.image());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GuardrailContentBlock").add("Text", text())
                .add("Image", image() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "text":
            return Optional.ofNullable(clazz.cast(text()));
        case "image":
            return Optional.ofNullable(clazz.cast(image()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #text()} initialized to the given value.
     *
     * <p>
     * Text within content block to be evaluated by the guardrail.
     * </p>
     * 
     * @param text
     *        Text within content block to be evaluated by the guardrail.
     */
    public static GuardrailContentBlock fromText(GuardrailTextBlock text) {
        return builder().text(text).build();
    }

    /**
     * Create an instance of this class with {@link #text()} initialized to the given value.
     *
     * <p>
     * Text within content block to be evaluated by the guardrail.
     * </p>
     * 
     * @param text
     *        Text within content block to be evaluated by the guardrail.
     */
    public static GuardrailContentBlock fromText(Consumer<GuardrailTextBlock.Builder> text) {
        GuardrailTextBlock.Builder builder = GuardrailTextBlock.builder();
        text.accept(builder);
        return fromText(builder.build());
    }

    /**
     * Create an instance of this class with {@link #image()} initialized to the given value.
     *
     * <p>
     * Image within guardrail content block to be evaluated by the guardrail.
     * </p>
     * 
     * @param image
     *        Image within guardrail content block to be evaluated by the guardrail.
     */
    public static GuardrailContentBlock fromImage(GuardrailImageBlock image) {
        return builder().image(image).build();
    }

    /**
     * Create an instance of this class with {@link #image()} initialized to the given value.
     *
     * <p>
     * Image within guardrail content block to be evaluated by the guardrail.
     * </p>
     * 
     * @param image
     *        Image within guardrail content block to be evaluated by the guardrail.
     */
    public static GuardrailContentBlock fromImage(Consumer<GuardrailImageBlock.Builder> image) {
        GuardrailImageBlock.Builder builder = GuardrailImageBlock.builder();
        image.accept(builder);
        return fromImage(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("text", TEXT_FIELD);
        map.put("image", IMAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailContentBlock, T> g) {
        return obj -> g.apply((GuardrailContentBlock) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GuardrailContentBlock> {
        /**
         * <p>
         * Text within content block to be evaluated by the guardrail.
         * </p>
         * 
         * @param text
         *        Text within content block to be evaluated by the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(GuardrailTextBlock text);

        /**
         * <p>
         * Text within content block to be evaluated by the guardrail.
         * </p>
         * This is a convenience method that creates an instance of the {@link GuardrailTextBlock.Builder} avoiding the
         * need to create one manually via {@link GuardrailTextBlock#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailTextBlock.Builder#build()} is called immediately and its
         * result is passed to {@link #text(GuardrailTextBlock)}.
         * 
         * @param text
         *        a consumer that will call methods on {@link GuardrailTextBlock.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #text(GuardrailTextBlock)
         */
        default Builder text(Consumer<GuardrailTextBlock.Builder> text) {
            return text(GuardrailTextBlock.builder().applyMutation(text).build());
        }

        /**
         * <p>
         * Image within guardrail content block to be evaluated by the guardrail.
         * </p>
         * 
         * @param image
         *        Image within guardrail content block to be evaluated by the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder image(GuardrailImageBlock image);

        /**
         * <p>
         * Image within guardrail content block to be evaluated by the guardrail.
         * </p>
         * This is a convenience method that creates an instance of the {@link GuardrailImageBlock.Builder} avoiding the
         * need to create one manually via {@link GuardrailImageBlock#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailImageBlock.Builder#build()} is called immediately and
         * its result is passed to {@link #image(GuardrailImageBlock)}.
         * 
         * @param image
         *        a consumer that will call methods on {@link GuardrailImageBlock.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #image(GuardrailImageBlock)
         */
        default Builder image(Consumer<GuardrailImageBlock.Builder> image) {
            return image(GuardrailImageBlock.builder().applyMutation(image).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GuardrailTextBlock text;

        private GuardrailImageBlock image;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailContentBlock model) {
            text(model.text);
            image(model.image);
        }

        public final GuardrailTextBlock.Builder getText() {
            return text != null ? text.toBuilder() : null;
        }

        public final void setText(GuardrailTextBlock.BuilderImpl text) {
            Object oldValue = this.text;
            this.text = text != null ? text.build() : null;
            handleUnionValueChange(Type.TEXT, oldValue, this.text);
        }

        @Override
        public final Builder text(GuardrailTextBlock text) {
            Object oldValue = this.text;
            this.text = text;
            handleUnionValueChange(Type.TEXT, oldValue, this.text);
            return this;
        }

        public final GuardrailImageBlock.Builder getImage() {
            return image != null ? image.toBuilder() : null;
        }

        public final void setImage(GuardrailImageBlock.BuilderImpl image) {
            Object oldValue = this.image;
            this.image = image != null ? image.build() : null;
            handleUnionValueChange(Type.IMAGE, oldValue, this.image);
        }

        @Override
        public final Builder image(GuardrailImageBlock image) {
            Object oldValue = this.image;
            this.image = image;
            handleUnionValueChange(Type.IMAGE, oldValue, this.image);
            return this;
        }

        @Override
        public GuardrailContentBlock build() {
            return new GuardrailContentBlock(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see GuardrailContentBlock#type()
     */
    public enum Type {
        TEXT,

        IMAGE,

        UNKNOWN_TO_SDK_VERSION
    }
}
