/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.eventstream.DefaultEventStreamResponseHandlerBuilder;
import software.amazon.awssdk.awscore.eventstream.EventStreamResponseHandlerFromBuilder;

@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultInvokeModelWithBidirectionalStreamResponseHandlerBuilder
        extends
        DefaultEventStreamResponseHandlerBuilder<InvokeModelWithBidirectionalStreamResponse, InvokeModelWithBidirectionalStreamOutput, InvokeModelWithBidirectionalStreamResponseHandler.Builder>
        implements InvokeModelWithBidirectionalStreamResponseHandler.Builder {
    @Override
    public InvokeModelWithBidirectionalStreamResponseHandler.Builder subscriber(
            InvokeModelWithBidirectionalStreamResponseHandler.Visitor visitor) {
        subscriber(e -> e.accept(visitor));
        return this;
    }

    @Override
    public InvokeModelWithBidirectionalStreamResponseHandler build() {
        return new Impl(this);
    }

    @Generated("software.amazon.awssdk:codegen")
    private static final class Impl
            extends
            EventStreamResponseHandlerFromBuilder<InvokeModelWithBidirectionalStreamResponse, InvokeModelWithBidirectionalStreamOutput>
            implements InvokeModelWithBidirectionalStreamResponseHandler {
        private Impl(DefaultInvokeModelWithBidirectionalStreamResponseHandlerBuilder builder) {
            super(builder);
        }
    }
}
