/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.bedrockruntime.model.ContentBlockDeltaEvent;
import software.amazon.awssdk.services.bedrockruntime.model.ContentBlockStartEvent;
import software.amazon.awssdk.services.bedrockruntime.model.ContentBlockStopEvent;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamMetadataEvent;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamOutput;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamResponseHandler;
import software.amazon.awssdk.services.bedrockruntime.model.MessageStartEvent;
import software.amazon.awssdk.services.bedrockruntime.model.MessageStopEvent;

@SdkInternalApi
final class DefaultConverseStreamVisitorBuilder
implements ConverseStreamResponseHandler.Visitor.Builder {
    private Consumer<ConverseStreamOutput> onDefault;
    private Consumer<MessageStartEvent> onMessageStart;
    private Consumer<ContentBlockStartEvent> onContentBlockStart;
    private Consumer<ContentBlockDeltaEvent> onContentBlockDelta;
    private Consumer<ContentBlockStopEvent> onContentBlockStop;
    private Consumer<MessageStopEvent> onMessageStop;
    private Consumer<ConverseStreamMetadataEvent> onMetadata;

    DefaultConverseStreamVisitorBuilder() {
    }

    @Override
    public ConverseStreamResponseHandler.Visitor.Builder onDefault(Consumer<ConverseStreamOutput> c) {
        this.onDefault = c;
        return this;
    }

    @Override
    public ConverseStreamResponseHandler.Visitor build() {
        return new VisitorFromBuilder(this);
    }

    @Override
    public ConverseStreamResponseHandler.Visitor.Builder onMessageStart(Consumer<MessageStartEvent> c) {
        this.onMessageStart = c;
        return this;
    }

    @Override
    public ConverseStreamResponseHandler.Visitor.Builder onContentBlockStart(Consumer<ContentBlockStartEvent> c) {
        this.onContentBlockStart = c;
        return this;
    }

    @Override
    public ConverseStreamResponseHandler.Visitor.Builder onContentBlockDelta(Consumer<ContentBlockDeltaEvent> c) {
        this.onContentBlockDelta = c;
        return this;
    }

    @Override
    public ConverseStreamResponseHandler.Visitor.Builder onContentBlockStop(Consumer<ContentBlockStopEvent> c) {
        this.onContentBlockStop = c;
        return this;
    }

    @Override
    public ConverseStreamResponseHandler.Visitor.Builder onMessageStop(Consumer<MessageStopEvent> c) {
        this.onMessageStop = c;
        return this;
    }

    @Override
    public ConverseStreamResponseHandler.Visitor.Builder onMetadata(Consumer<ConverseStreamMetadataEvent> c) {
        this.onMetadata = c;
        return this;
    }

    static class VisitorFromBuilder
    implements ConverseStreamResponseHandler.Visitor {
        private final Consumer<ConverseStreamOutput> onDefault;
        private final Consumer<MessageStartEvent> onMessageStart;
        private final Consumer<ContentBlockStartEvent> onContentBlockStart;
        private final Consumer<ContentBlockDeltaEvent> onContentBlockDelta;
        private final Consumer<ContentBlockStopEvent> onContentBlockStop;
        private final Consumer<MessageStopEvent> onMessageStop;
        private final Consumer<ConverseStreamMetadataEvent> onMetadata;

        VisitorFromBuilder(DefaultConverseStreamVisitorBuilder builder) {
            this.onDefault = builder.onDefault != null ? builder.onDefault : x$0 -> ConverseStreamResponseHandler.Visitor.super.visitDefault((ConverseStreamOutput)x$0);
            this.onMessageStart = builder.onMessageStart != null ? builder.onMessageStart : x$0 -> ConverseStreamResponseHandler.Visitor.super.visitMessageStart((MessageStartEvent)x$0);
            this.onContentBlockStart = builder.onContentBlockStart != null ? builder.onContentBlockStart : x$0 -> ConverseStreamResponseHandler.Visitor.super.visitContentBlockStart((ContentBlockStartEvent)x$0);
            this.onContentBlockDelta = builder.onContentBlockDelta != null ? builder.onContentBlockDelta : x$0 -> ConverseStreamResponseHandler.Visitor.super.visitContentBlockDelta((ContentBlockDeltaEvent)x$0);
            this.onContentBlockStop = builder.onContentBlockStop != null ? builder.onContentBlockStop : x$0 -> ConverseStreamResponseHandler.Visitor.super.visitContentBlockStop((ContentBlockStopEvent)x$0);
            this.onMessageStop = builder.onMessageStop != null ? builder.onMessageStop : x$0 -> ConverseStreamResponseHandler.Visitor.super.visitMessageStop((MessageStopEvent)x$0);
            this.onMetadata = builder.onMetadata != null ? builder.onMetadata : x$0 -> ConverseStreamResponseHandler.Visitor.super.visitMetadata((ConverseStreamMetadataEvent)x$0);
        }

        @Override
        public void visitDefault(ConverseStreamOutput event) {
            this.onDefault.accept(event);
        }

        @Override
        public void visitMessageStart(MessageStartEvent event) {
            this.onMessageStart.accept(event);
        }

        @Override
        public void visitContentBlockStart(ContentBlockStartEvent event) {
            this.onContentBlockStart.accept(event);
        }

        @Override
        public void visitContentBlockDelta(ContentBlockDeltaEvent event) {
            this.onContentBlockDelta.accept(event);
        }

        @Override
        public void visitContentBlockStop(ContentBlockStopEvent event) {
            this.onContentBlockStop.accept(event);
        }

        @Override
        public void visitMessageStop(MessageStopEvent event) {
            this.onMessageStop.accept(event);
        }

        @Override
        public void visitMetadata(ConverseStreamMetadataEvent event) {
            this.onMetadata.accept(event);
        }
    }
}

