/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A tool result block that contains the results for a tool request that the model previously made.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ToolResultBlock implements SdkPojo, Serializable, ToCopyableBuilder<ToolResultBlock.Builder, ToolResultBlock> {
    private static final SdkField<String> TOOL_USE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("toolUseId").getter(getter(ToolResultBlock::toolUseId)).setter(setter(Builder::toolUseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolUseId").build()).build();

    private static final SdkField<List<ToolResultContentBlock>> CONTENT_FIELD = SdkField
            .<List<ToolResultContentBlock>> builder(MarshallingType.LIST)
            .memberName("content")
            .getter(getter(ToolResultBlock::content))
            .setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ToolResultContentBlock> builder(MarshallingType.SDK_POJO)
                                            .constructor(ToolResultContentBlock::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ToolResultBlock::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOOL_USE_ID_FIELD,
            CONTENT_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String toolUseId;

    private final List<ToolResultContentBlock> content;

    private final String status;

    private ToolResultBlock(BuilderImpl builder) {
        this.toolUseId = builder.toolUseId;
        this.content = builder.content;
        this.status = builder.status;
    }

    /**
     * <p>
     * The ID of the tool request that this is the result for.
     * </p>
     * 
     * @return The ID of the tool request that this is the result for.
     */
    public final String toolUseId() {
        return toolUseId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Content property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasContent() {
        return content != null && !(content instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The content for tool result content block.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContent} method.
     * </p>
     * 
     * @return The content for tool result content block.
     */
    public final List<ToolResultContentBlock> content() {
        return content;
    }

    /**
     * <p>
     * The status for the tool result content block.
     * </p>
     * <note>
     * <p>
     * This field is only supported Anthropic Claude 3 models.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ToolResultStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status for the tool result content block.</p> <note>
     *         <p>
     *         This field is only supported Anthropic Claude 3 models.
     *         </p>
     * @see ToolResultStatus
     */
    public final ToolResultStatus status() {
        return ToolResultStatus.fromValue(status);
    }

    /**
     * <p>
     * The status for the tool result content block.
     * </p>
     * <note>
     * <p>
     * This field is only supported Anthropic Claude 3 models.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ToolResultStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status for the tool result content block.</p> <note>
     *         <p>
     *         This field is only supported Anthropic Claude 3 models.
     *         </p>
     * @see ToolResultStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(toolUseId());
        hashCode = 31 * hashCode + Objects.hashCode(hasContent() ? content() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ToolResultBlock)) {
            return false;
        }
        ToolResultBlock other = (ToolResultBlock) obj;
        return Objects.equals(toolUseId(), other.toolUseId()) && hasContent() == other.hasContent()
                && Objects.equals(content(), other.content()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ToolResultBlock").add("ToolUseId", toolUseId()).add("Content", hasContent() ? content() : null)
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "toolUseId":
            return Optional.ofNullable(clazz.cast(toolUseId()));
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ToolResultBlock, T> g) {
        return obj -> g.apply((ToolResultBlock) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ToolResultBlock> {
        /**
         * <p>
         * The ID of the tool request that this is the result for.
         * </p>
         * 
         * @param toolUseId
         *        The ID of the tool request that this is the result for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toolUseId(String toolUseId);

        /**
         * <p>
         * The content for tool result content block.
         * </p>
         * 
         * @param content
         *        The content for tool result content block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(Collection<ToolResultContentBlock> content);

        /**
         * <p>
         * The content for tool result content block.
         * </p>
         * 
         * @param content
         *        The content for tool result content block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(ToolResultContentBlock... content);

        /**
         * <p>
         * The content for tool result content block.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockruntime.model.ToolResultContentBlock.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.bedrockruntime.model.ToolResultContentBlock#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockruntime.model.ToolResultContentBlock.Builder#build()} is called
         * immediately and its result is passed to {@link #content(List<ToolResultContentBlock>)}.
         * 
         * @param content
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockruntime.model.ToolResultContentBlock.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(java.util.Collection<ToolResultContentBlock>)
         */
        Builder content(Consumer<ToolResultContentBlock.Builder>... content);

        /**
         * <p>
         * The status for the tool result content block.
         * </p>
         * <note>
         * <p>
         * This field is only supported Anthropic Claude 3 models.
         * </p>
         * </note>
         * 
         * @param status
         *        The status for the tool result content block.</p> <note>
         *        <p>
         *        This field is only supported Anthropic Claude 3 models.
         *        </p>
         * @see ToolResultStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ToolResultStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status for the tool result content block.
         * </p>
         * <note>
         * <p>
         * This field is only supported Anthropic Claude 3 models.
         * </p>
         * </note>
         * 
         * @param status
         *        The status for the tool result content block.</p> <note>
         *        <p>
         *        This field is only supported Anthropic Claude 3 models.
         *        </p>
         * @see ToolResultStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ToolResultStatus
         */
        Builder status(ToolResultStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String toolUseId;

        private List<ToolResultContentBlock> content = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ToolResultBlock model) {
            toolUseId(model.toolUseId);
            content(model.content);
            status(model.status);
        }

        public final String getToolUseId() {
            return toolUseId;
        }

        public final void setToolUseId(String toolUseId) {
            this.toolUseId = toolUseId;
        }

        @Override
        public final Builder toolUseId(String toolUseId) {
            this.toolUseId = toolUseId;
            return this;
        }

        public final List<ToolResultContentBlock.Builder> getContent() {
            List<ToolResultContentBlock.Builder> result = ToolResultContentBlocksCopier.copyToBuilder(this.content);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContent(Collection<ToolResultContentBlock.BuilderImpl> content) {
            this.content = ToolResultContentBlocksCopier.copyFromBuilder(content);
        }

        @Override
        public final Builder content(Collection<ToolResultContentBlock> content) {
            this.content = ToolResultContentBlocksCopier.copy(content);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder content(ToolResultContentBlock... content) {
            content(Arrays.asList(content));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder content(Consumer<ToolResultContentBlock.Builder>... content) {
            content(Stream.of(content).map(c -> ToolResultContentBlock.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ToolResultStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public ToolResultBlock build() {
            return new ToolResultBlock(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
