/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The tokens used in a message API inference call.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TokenUsage implements SdkPojo, Serializable, ToCopyableBuilder<TokenUsage.Builder, TokenUsage> {
    private static final SdkField<Integer> INPUT_TOKENS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("inputTokens").getter(getter(TokenUsage::inputTokens)).setter(setter(Builder::inputTokens))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputTokens").build()).build();

    private static final SdkField<Integer> OUTPUT_TOKENS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("outputTokens").getter(getter(TokenUsage::outputTokens)).setter(setter(Builder::outputTokens))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputTokens").build()).build();

    private static final SdkField<Integer> TOTAL_TOKENS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalTokens").getter(getter(TokenUsage::totalTokens)).setter(setter(Builder::totalTokens))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalTokens").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_TOKENS_FIELD,
            OUTPUT_TOKENS_FIELD, TOTAL_TOKENS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer inputTokens;

    private final Integer outputTokens;

    private final Integer totalTokens;

    private TokenUsage(BuilderImpl builder) {
        this.inputTokens = builder.inputTokens;
        this.outputTokens = builder.outputTokens;
        this.totalTokens = builder.totalTokens;
    }

    /**
     * <p>
     * The number of tokens sent in the request to the model.
     * </p>
     * 
     * @return The number of tokens sent in the request to the model.
     */
    public final Integer inputTokens() {
        return inputTokens;
    }

    /**
     * <p>
     * The number of tokens that the model generated for the request.
     * </p>
     * 
     * @return The number of tokens that the model generated for the request.
     */
    public final Integer outputTokens() {
        return outputTokens;
    }

    /**
     * <p>
     * The total of input tokens and tokens generated by the model.
     * </p>
     * 
     * @return The total of input tokens and tokens generated by the model.
     */
    public final Integer totalTokens() {
        return totalTokens;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputTokens());
        hashCode = 31 * hashCode + Objects.hashCode(outputTokens());
        hashCode = 31 * hashCode + Objects.hashCode(totalTokens());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TokenUsage)) {
            return false;
        }
        TokenUsage other = (TokenUsage) obj;
        return Objects.equals(inputTokens(), other.inputTokens()) && Objects.equals(outputTokens(), other.outputTokens())
                && Objects.equals(totalTokens(), other.totalTokens());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TokenUsage").add("InputTokens", inputTokens()).add("OutputTokens", outputTokens())
                .add("TotalTokens", totalTokens()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inputTokens":
            return Optional.ofNullable(clazz.cast(inputTokens()));
        case "outputTokens":
            return Optional.ofNullable(clazz.cast(outputTokens()));
        case "totalTokens":
            return Optional.ofNullable(clazz.cast(totalTokens()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TokenUsage, T> g) {
        return obj -> g.apply((TokenUsage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TokenUsage> {
        /**
         * <p>
         * The number of tokens sent in the request to the model.
         * </p>
         * 
         * @param inputTokens
         *        The number of tokens sent in the request to the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputTokens(Integer inputTokens);

        /**
         * <p>
         * The number of tokens that the model generated for the request.
         * </p>
         * 
         * @param outputTokens
         *        The number of tokens that the model generated for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputTokens(Integer outputTokens);

        /**
         * <p>
         * The total of input tokens and tokens generated by the model.
         * </p>
         * 
         * @param totalTokens
         *        The total of input tokens and tokens generated by the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalTokens(Integer totalTokens);
    }

    static final class BuilderImpl implements Builder {
        private Integer inputTokens;

        private Integer outputTokens;

        private Integer totalTokens;

        private BuilderImpl() {
        }

        private BuilderImpl(TokenUsage model) {
            inputTokens(model.inputTokens);
            outputTokens(model.outputTokens);
            totalTokens(model.totalTokens);
        }

        public final Integer getInputTokens() {
            return inputTokens;
        }

        public final void setInputTokens(Integer inputTokens) {
            this.inputTokens = inputTokens;
        }

        @Override
        public final Builder inputTokens(Integer inputTokens) {
            this.inputTokens = inputTokens;
            return this;
        }

        public final Integer getOutputTokens() {
            return outputTokens;
        }

        public final void setOutputTokens(Integer outputTokens) {
            this.outputTokens = outputTokens;
        }

        @Override
        public final Builder outputTokens(Integer outputTokens) {
            this.outputTokens = outputTokens;
            return this;
        }

        public final Integer getTotalTokens() {
            return totalTokens;
        }

        public final void setTotalTokens(Integer totalTokens) {
            this.totalTokens = totalTokens;
        }

        @Override
        public final Builder totalTokens(Integer totalTokens) {
            this.totalTokens = totalTokens;
            return this;
        }

        @Override
        public TokenUsage build() {
            return new TokenUsage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
