/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the content of a document.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentSource implements SdkPojo, Serializable, ToCopyableBuilder<DocumentSource.Builder, DocumentSource> {
    private static final SdkField<SdkBytes> BYTES_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("bytes").getter(getter(DocumentSource::bytes)).setter(setter(Builder::bytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bytes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BYTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final SdkBytes bytes;

    private final Type type;

    private DocumentSource(BuilderImpl builder) {
        this.bytes = builder.bytes;
        this.type = builder.type;
    }

    /**
     * <p>
     * The raw bytes for the document. If you use an Amazon Web Services SDK, you don't need to encode the bytes in
     * base64.
     * </p>
     * 
     * @return The raw bytes for the document. If you use an Amazon Web Services SDK, you don't need to encode the bytes
     *         in base64.
     */
    public final SdkBytes bytes() {
        return bytes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bytes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentSource)) {
            return false;
        }
        DocumentSource other = (DocumentSource) obj;
        return Objects.equals(bytes(), other.bytes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DocumentSource").add("Bytes", bytes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bytes":
            return Optional.ofNullable(clazz.cast(bytes()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #bytes()} initialized to the given value.
     *
     * <p>
     * The raw bytes for the document. If you use an Amazon Web Services SDK, you don't need to encode the bytes in
     * base64.
     * </p>
     * 
     * @param bytes
     *        The raw bytes for the document. If you use an Amazon Web Services SDK, you don't need to encode the bytes
     *        in base64.
     */
    public static DocumentSource fromBytes(SdkBytes bytes) {
        return builder().bytes(bytes).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DocumentSource, T> g) {
        return obj -> g.apply((DocumentSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentSource> {
        /**
         * <p>
         * The raw bytes for the document. If you use an Amazon Web Services SDK, you don't need to encode the bytes in
         * base64.
         * </p>
         * 
         * @param bytes
         *        The raw bytes for the document. If you use an Amazon Web Services SDK, you don't need to encode the
         *        bytes in base64.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bytes(SdkBytes bytes);
    }

    static final class BuilderImpl implements Builder {
        private SdkBytes bytes;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentSource model) {
            bytes(model.bytes);
        }

        public final ByteBuffer getBytes() {
            return bytes == null ? null : bytes.asByteBuffer();
        }

        public final void setBytes(ByteBuffer bytes) {
            bytes(bytes == null ? null : SdkBytes.fromByteBuffer(bytes));
        }

        @Override
        public final Builder bytes(SdkBytes bytes) {
            Object oldValue = this.bytes;
            this.bytes = bytes;
            handleUnionValueChange(Type.BYTES, oldValue, this.bytes);
            return this;
        }

        @Override
        public DocumentSource build() {
            return new DocumentSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see DocumentSource#type()
     */
    public enum Type {
        BYTES,

        UNKNOWN_TO_SDK_VERSION
    }
}
