/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConverseStreamRequest extends BedrockRuntimeRequest implements
        ToCopyableBuilder<ConverseStreamRequest.Builder, ConverseStreamRequest> {
    private static final SdkField<String> MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelId").getter(getter(ConverseStreamRequest::modelId)).setter(setter(Builder::modelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("modelId").build()).build();

    private static final SdkField<List<Message>> MESSAGES_FIELD = SdkField
            .<List<Message>> builder(MarshallingType.LIST)
            .memberName("messages")
            .getter(getter(ConverseStreamRequest::messages))
            .setter(setter(Builder::messages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Message> builder(MarshallingType.SDK_POJO)
                                            .constructor(Message::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SystemContentBlock>> SYSTEM_FIELD = SdkField
            .<List<SystemContentBlock>> builder(MarshallingType.LIST)
            .memberName("system")
            .getter(getter(ConverseStreamRequest::system))
            .setter(setter(Builder::system))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("system").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SystemContentBlock> builder(MarshallingType.SDK_POJO)
                                            .constructor(SystemContentBlock::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<InferenceConfiguration> INFERENCE_CONFIG_FIELD = SdkField
            .<InferenceConfiguration> builder(MarshallingType.SDK_POJO).memberName("inferenceConfig")
            .getter(getter(ConverseStreamRequest::inferenceConfig)).setter(setter(Builder::inferenceConfig))
            .constructor(InferenceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceConfig").build()).build();

    private static final SdkField<ToolConfiguration> TOOL_CONFIG_FIELD = SdkField
            .<ToolConfiguration> builder(MarshallingType.SDK_POJO).memberName("toolConfig")
            .getter(getter(ConverseStreamRequest::toolConfig)).setter(setter(Builder::toolConfig))
            .constructor(ToolConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolConfig").build()).build();

    private static final SdkField<GuardrailStreamConfiguration> GUARDRAIL_CONFIG_FIELD = SdkField
            .<GuardrailStreamConfiguration> builder(MarshallingType.SDK_POJO).memberName("guardrailConfig")
            .getter(getter(ConverseStreamRequest::guardrailConfig)).setter(setter(Builder::guardrailConfig))
            .constructor(GuardrailStreamConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailConfig").build()).build();

    private static final SdkField<Document> ADDITIONAL_MODEL_REQUEST_FIELDS_FIELD = SdkField
            .<Document> builder(MarshallingType.DOCUMENT)
            .memberName("additionalModelRequestFields")
            .getter(getter(ConverseStreamRequest::additionalModelRequestFields))
            .setter(setter(Builder::additionalModelRequestFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalModelRequestFields")
                    .build()).build();

    private static final SdkField<List<String>> ADDITIONAL_MODEL_RESPONSE_FIELD_PATHS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("additionalModelResponseFieldPaths")
            .getter(getter(ConverseStreamRequest::additionalModelResponseFieldPaths))
            .setter(setter(Builder::additionalModelResponseFieldPaths))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalModelResponseFieldPaths")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ID_FIELD,
            MESSAGES_FIELD, SYSTEM_FIELD, INFERENCE_CONFIG_FIELD, TOOL_CONFIG_FIELD, GUARDRAIL_CONFIG_FIELD,
            ADDITIONAL_MODEL_REQUEST_FIELDS_FIELD, ADDITIONAL_MODEL_RESPONSE_FIELD_PATHS_FIELD));

    private final String modelId;

    private final List<Message> messages;

    private final List<SystemContentBlock> system;

    private final InferenceConfiguration inferenceConfig;

    private final ToolConfiguration toolConfig;

    private final GuardrailStreamConfiguration guardrailConfig;

    private final Document additionalModelRequestFields;

    private final List<String> additionalModelResponseFieldPaths;

    private ConverseStreamRequest(BuilderImpl builder) {
        super(builder);
        this.modelId = builder.modelId;
        this.messages = builder.messages;
        this.system = builder.system;
        this.inferenceConfig = builder.inferenceConfig;
        this.toolConfig = builder.toolConfig;
        this.guardrailConfig = builder.guardrailConfig;
        this.additionalModelRequestFields = builder.additionalModelRequestFields;
        this.additionalModelResponseFieldPaths = builder.additionalModelResponseFieldPaths;
    }

    /**
     * <p>
     * The ID for the model.
     * </p>
     * <p>
     * The <code>modelId</code> to provide depends on the type of model or throughput that you use:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you use a base model, specify the model ID or its ARN. For a list of model IDs for base models, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids.html#model-ids-arns">Amazon Bedrock base
     * model IDs (on-demand throughput)</a> in the Amazon Bedrock User Guide.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you use an inference profile, specify the inference profile ID or its ARN. For a list of inference profile
     * IDs, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference-support.html">Supported Regions
     * and models for cross-region inference</a> in the Amazon Bedrock User Guide.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you use a provisioned model, specify the ARN of the Provisioned Throughput. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/prov-thru-use.html">Run inference using a Provisioned
     * Throughput</a> in the Amazon Bedrock User Guide.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you use a custom model, first purchase Provisioned Throughput for it. Then specify the ARN of the resulting
     * provisioned model. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-use.html">Use a custom model in
     * Amazon Bedrock</a> in the Amazon Bedrock User Guide.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The Converse API doesn't support <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html">imported
     * models</a>.
     * </p>
     * 
     * @return The ID for the model.</p>
     *         <p>
     *         The <code>modelId</code> to provide depends on the type of model or throughput that you use:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you use a base model, specify the model ID or its ARN. For a list of model IDs for base models, see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids.html#model-ids-arns">Amazon Bedrock
     *         base model IDs (on-demand throughput)</a> in the Amazon Bedrock User Guide.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you use an inference profile, specify the inference profile ID or its ARN. For a list of inference
     *         profile IDs, see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference-support.html">Supported
     *         Regions and models for cross-region inference</a> in the Amazon Bedrock User Guide.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you use a provisioned model, specify the ARN of the Provisioned Throughput. For more information, see
     *         <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/prov-thru-use.html">Run inference using a
     *         Provisioned Throughput</a> in the Amazon Bedrock User Guide.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you use a custom model, first purchase Provisioned Throughput for it. Then specify the ARN of the
     *         resulting provisioned model. For more information, see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-use.html">Use a custom
     *         model in Amazon Bedrock</a> in the Amazon Bedrock User Guide.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The Converse API doesn't support <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html"
     *         >imported models</a>.
     */
    public final String modelId() {
        return modelId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Messages property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMessages() {
        return messages != null && !(messages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The messages that you want to send to the model.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMessages} method.
     * </p>
     * 
     * @return The messages that you want to send to the model.
     */
    public final List<Message> messages() {
        return messages;
    }

    /**
     * For responses, this returns true if the service returned a value for the System property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSystem() {
        return system != null && !(system instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A system prompt to send to the model.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSystem} method.
     * </p>
     * 
     * @return A system prompt to send to the model.
     */
    public final List<SystemContentBlock> system() {
        return system;
    }

    /**
     * <p>
     * Inference parameters to pass to the model. <code>ConverseStream</code> supports a base set of inference
     * parameters. If you need to pass additional parameters that the model supports, use the
     * <code>additionalModelRequestFields</code> request field.
     * </p>
     * 
     * @return Inference parameters to pass to the model. <code>ConverseStream</code> supports a base set of inference
     *         parameters. If you need to pass additional parameters that the model supports, use the
     *         <code>additionalModelRequestFields</code> request field.
     */
    public final InferenceConfiguration inferenceConfig() {
        return inferenceConfig;
    }

    /**
     * <p>
     * Configuration information for the tools that the model can use when generating a response.
     * </p>
     * <note>
     * <p>
     * This field is only supported by Anthropic Claude 3 models.
     * </p>
     * </note>
     * 
     * @return Configuration information for the tools that the model can use when generating a response.</p> <note>
     *         <p>
     *         This field is only supported by Anthropic Claude 3 models.
     *         </p>
     */
    public final ToolConfiguration toolConfig() {
        return toolConfig;
    }

    /**
     * <p>
     * Configuration information for a guardrail that you want to use in the request.
     * </p>
     * 
     * @return Configuration information for a guardrail that you want to use in the request.
     */
    public final GuardrailStreamConfiguration guardrailConfig() {
        return guardrailConfig;
    }

    /**
     * <p>
     * Additional inference parameters that the model supports, beyond the base set of inference parameters that
     * <code>ConverseStream</code> supports in the <code>inferenceConfig</code> field.
     * </p>
     * 
     * @return Additional inference parameters that the model supports, beyond the base set of inference parameters that
     *         <code>ConverseStream</code> supports in the <code>inferenceConfig</code> field.
     */
    public final Document additionalModelRequestFields() {
        return additionalModelRequestFields;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalModelResponseFieldPaths
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasAdditionalModelResponseFieldPaths() {
        return additionalModelResponseFieldPaths != null && !(additionalModelResponseFieldPaths instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Additional model parameters field paths to return in the response. <code>ConverseStream</code> returns the
     * requested fields as a JSON Pointer object in the <code>additionalModelResponseFields</code> field. The following
     * is example JSON for <code>additionalModelResponseFieldPaths</code>.
     * </p>
     * <p>
     * <code>[ "/stop_sequence" ]</code>
     * </p>
     * <p>
     * For information about the JSON Pointer syntax, see the <a
     * href="https://datatracker.ietf.org/doc/html/rfc6901">Internet Engineering Task Force (IETF)</a> documentation.
     * </p>
     * <p>
     * <code>ConverseStream</code> rejects an empty JSON Pointer or incorrectly structured JSON Pointer with a
     * <code>400</code> error code. if the JSON Pointer is valid, but the requested field is not in the model response,
     * it is ignored by <code>ConverseStream</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalModelResponseFieldPaths}
     * method.
     * </p>
     * 
     * @return Additional model parameters field paths to return in the response. <code>ConverseStream</code> returns
     *         the requested fields as a JSON Pointer object in the <code>additionalModelResponseFields</code> field.
     *         The following is example JSON for <code>additionalModelResponseFieldPaths</code>.</p>
     *         <p>
     *         <code>[ "/stop_sequence" ]</code>
     *         </p>
     *         <p>
     *         For information about the JSON Pointer syntax, see the <a
     *         href="https://datatracker.ietf.org/doc/html/rfc6901">Internet Engineering Task Force (IETF)</a>
     *         documentation.
     *         </p>
     *         <p>
     *         <code>ConverseStream</code> rejects an empty JSON Pointer or incorrectly structured JSON Pointer with a
     *         <code>400</code> error code. if the JSON Pointer is valid, but the requested field is not in the model
     *         response, it is ignored by <code>ConverseStream</code>.
     */
    public final List<String> additionalModelResponseFieldPaths() {
        return additionalModelResponseFieldPaths;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modelId());
        hashCode = 31 * hashCode + Objects.hashCode(hasMessages() ? messages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSystem() ? system() : null);
        hashCode = 31 * hashCode + Objects.hashCode(inferenceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(toolConfig());
        hashCode = 31 * hashCode + Objects.hashCode(guardrailConfig());
        hashCode = 31 * hashCode + Objects.hashCode(additionalModelRequestFields());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasAdditionalModelResponseFieldPaths() ? additionalModelResponseFieldPaths() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConverseStreamRequest)) {
            return false;
        }
        ConverseStreamRequest other = (ConverseStreamRequest) obj;
        return Objects.equals(modelId(), other.modelId()) && hasMessages() == other.hasMessages()
                && Objects.equals(messages(), other.messages()) && hasSystem() == other.hasSystem()
                && Objects.equals(system(), other.system()) && Objects.equals(inferenceConfig(), other.inferenceConfig())
                && Objects.equals(toolConfig(), other.toolConfig()) && Objects.equals(guardrailConfig(), other.guardrailConfig())
                && Objects.equals(additionalModelRequestFields(), other.additionalModelRequestFields())
                && hasAdditionalModelResponseFieldPaths() == other.hasAdditionalModelResponseFieldPaths()
                && Objects.equals(additionalModelResponseFieldPaths(), other.additionalModelResponseFieldPaths());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ConverseStreamRequest")
                .add("ModelId", modelId())
                .add("Messages", hasMessages() ? messages() : null)
                .add("System", hasSystem() ? system() : null)
                .add("InferenceConfig", inferenceConfig())
                .add("ToolConfig", toolConfig())
                .add("GuardrailConfig", guardrailConfig())
                .add("AdditionalModelRequestFields", additionalModelRequestFields())
                .add("AdditionalModelResponseFieldPaths",
                        hasAdditionalModelResponseFieldPaths() ? additionalModelResponseFieldPaths() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "modelId":
            return Optional.ofNullable(clazz.cast(modelId()));
        case "messages":
            return Optional.ofNullable(clazz.cast(messages()));
        case "system":
            return Optional.ofNullable(clazz.cast(system()));
        case "inferenceConfig":
            return Optional.ofNullable(clazz.cast(inferenceConfig()));
        case "toolConfig":
            return Optional.ofNullable(clazz.cast(toolConfig()));
        case "guardrailConfig":
            return Optional.ofNullable(clazz.cast(guardrailConfig()));
        case "additionalModelRequestFields":
            return Optional.ofNullable(clazz.cast(additionalModelRequestFields()));
        case "additionalModelResponseFieldPaths":
            return Optional.ofNullable(clazz.cast(additionalModelResponseFieldPaths()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConverseStreamRequest, T> g) {
        return obj -> g.apply((ConverseStreamRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockRuntimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, ConverseStreamRequest> {
        /**
         * <p>
         * The ID for the model.
         * </p>
         * <p>
         * The <code>modelId</code> to provide depends on the type of model or throughput that you use:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you use a base model, specify the model ID or its ARN. For a list of model IDs for base models, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids.html#model-ids-arns">Amazon Bedrock base
         * model IDs (on-demand throughput)</a> in the Amazon Bedrock User Guide.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you use an inference profile, specify the inference profile ID or its ARN. For a list of inference profile
         * IDs, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference-support.html">Supported
         * Regions and models for cross-region inference</a> in the Amazon Bedrock User Guide.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you use a provisioned model, specify the ARN of the Provisioned Throughput. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/prov-thru-use.html">Run inference using a
         * Provisioned Throughput</a> in the Amazon Bedrock User Guide.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you use a custom model, first purchase Provisioned Throughput for it. Then specify the ARN of the
         * resulting provisioned model. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-use.html">Use a custom model
         * in Amazon Bedrock</a> in the Amazon Bedrock User Guide.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The Converse API doesn't support <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html">imported
         * models</a>.
         * </p>
         * 
         * @param modelId
         *        The ID for the model.</p>
         *        <p>
         *        The <code>modelId</code> to provide depends on the type of model or throughput that you use:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you use a base model, specify the model ID or its ARN. For a list of model IDs for base models, see
         *        <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids.html#model-ids-arns">Amazon
         *        Bedrock base model IDs (on-demand throughput)</a> in the Amazon Bedrock User Guide.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you use an inference profile, specify the inference profile ID or its ARN. For a list of inference
         *        profile IDs, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference-support.html"
         *        >Supported Regions and models for cross-region inference</a> in the Amazon Bedrock User Guide.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you use a provisioned model, specify the ARN of the Provisioned Throughput. For more information,
         *        see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/prov-thru-use.html">Run inference
         *        using a Provisioned Throughput</a> in the Amazon Bedrock User Guide.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you use a custom model, first purchase Provisioned Throughput for it. Then specify the ARN of the
         *        resulting provisioned model. For more information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-use.html">Use a custom
         *        model in Amazon Bedrock</a> in the Amazon Bedrock User Guide.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The Converse API doesn't support <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html"
         *        >imported models</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelId(String modelId);

        /**
         * <p>
         * The messages that you want to send to the model.
         * </p>
         * 
         * @param messages
         *        The messages that you want to send to the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messages(Collection<Message> messages);

        /**
         * <p>
         * The messages that you want to send to the model.
         * </p>
         * 
         * @param messages
         *        The messages that you want to send to the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messages(Message... messages);

        /**
         * <p>
         * The messages that you want to send to the model.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockruntime.model.Message.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.bedrockruntime.model.Message#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockruntime.model.Message.Builder#build()} is called immediately
         * and its result is passed to {@link #messages(List<Message>)}.
         * 
         * @param messages
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockruntime.model.Message.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #messages(java.util.Collection<Message>)
         */
        Builder messages(Consumer<Message.Builder>... messages);

        /**
         * <p>
         * A system prompt to send to the model.
         * </p>
         * 
         * @param system
         *        A system prompt to send to the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder system(Collection<SystemContentBlock> system);

        /**
         * <p>
         * A system prompt to send to the model.
         * </p>
         * 
         * @param system
         *        A system prompt to send to the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder system(SystemContentBlock... system);

        /**
         * <p>
         * A system prompt to send to the model.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockruntime.model.SystemContentBlock.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.bedrockruntime.model.SystemContentBlock#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockruntime.model.SystemContentBlock.Builder#build()} is called
         * immediately and its result is passed to {@link #system(List<SystemContentBlock>)}.
         * 
         * @param system
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockruntime.model.SystemContentBlock.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #system(java.util.Collection<SystemContentBlock>)
         */
        Builder system(Consumer<SystemContentBlock.Builder>... system);

        /**
         * <p>
         * Inference parameters to pass to the model. <code>ConverseStream</code> supports a base set of inference
         * parameters. If you need to pass additional parameters that the model supports, use the
         * <code>additionalModelRequestFields</code> request field.
         * </p>
         * 
         * @param inferenceConfig
         *        Inference parameters to pass to the model. <code>ConverseStream</code> supports a base set of
         *        inference parameters. If you need to pass additional parameters that the model supports, use the
         *        <code>additionalModelRequestFields</code> request field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceConfig(InferenceConfiguration inferenceConfig);

        /**
         * <p>
         * Inference parameters to pass to the model. <code>ConverseStream</code> supports a base set of inference
         * parameters. If you need to pass additional parameters that the model supports, use the
         * <code>additionalModelRequestFields</code> request field.
         * </p>
         * This is a convenience method that creates an instance of the {@link InferenceConfiguration.Builder} avoiding
         * the need to create one manually via {@link InferenceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InferenceConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #inferenceConfig(InferenceConfiguration)}.
         * 
         * @param inferenceConfig
         *        a consumer that will call methods on {@link InferenceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inferenceConfig(InferenceConfiguration)
         */
        default Builder inferenceConfig(Consumer<InferenceConfiguration.Builder> inferenceConfig) {
            return inferenceConfig(InferenceConfiguration.builder().applyMutation(inferenceConfig).build());
        }

        /**
         * <p>
         * Configuration information for the tools that the model can use when generating a response.
         * </p>
         * <note>
         * <p>
         * This field is only supported by Anthropic Claude 3 models.
         * </p>
         * </note>
         * 
         * @param toolConfig
         *        Configuration information for the tools that the model can use when generating a response.</p> <note>
         *        <p>
         *        This field is only supported by Anthropic Claude 3 models.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toolConfig(ToolConfiguration toolConfig);

        /**
         * <p>
         * Configuration information for the tools that the model can use when generating a response.
         * </p>
         * <note>
         * <p>
         * This field is only supported by Anthropic Claude 3 models.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link ToolConfiguration.Builder}
         * avoiding the need to create one manually via {@link ToolConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ToolConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #toolConfig(ToolConfiguration)}.
         * 
         * @param toolConfig
         *        a consumer that will call methods on {@link ToolConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #toolConfig(ToolConfiguration)
         */
        default Builder toolConfig(Consumer<ToolConfiguration.Builder> toolConfig) {
            return toolConfig(ToolConfiguration.builder().applyMutation(toolConfig).build());
        }

        /**
         * <p>
         * Configuration information for a guardrail that you want to use in the request.
         * </p>
         * 
         * @param guardrailConfig
         *        Configuration information for a guardrail that you want to use in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardrailConfig(GuardrailStreamConfiguration guardrailConfig);

        /**
         * <p>
         * Configuration information for a guardrail that you want to use in the request.
         * </p>
         * This is a convenience method that creates an instance of the {@link GuardrailStreamConfiguration.Builder}
         * avoiding the need to create one manually via {@link GuardrailStreamConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailStreamConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #guardrailConfig(GuardrailStreamConfiguration)}.
         * 
         * @param guardrailConfig
         *        a consumer that will call methods on {@link GuardrailStreamConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #guardrailConfig(GuardrailStreamConfiguration)
         */
        default Builder guardrailConfig(Consumer<GuardrailStreamConfiguration.Builder> guardrailConfig) {
            return guardrailConfig(GuardrailStreamConfiguration.builder().applyMutation(guardrailConfig).build());
        }

        /**
         * <p>
         * Additional inference parameters that the model supports, beyond the base set of inference parameters that
         * <code>ConverseStream</code> supports in the <code>inferenceConfig</code> field.
         * </p>
         * 
         * @param additionalModelRequestFields
         *        Additional inference parameters that the model supports, beyond the base set of inference parameters
         *        that <code>ConverseStream</code> supports in the <code>inferenceConfig</code> field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalModelRequestFields(Document additionalModelRequestFields);

        /**
         * <p>
         * Additional model parameters field paths to return in the response. <code>ConverseStream</code> returns the
         * requested fields as a JSON Pointer object in the <code>additionalModelResponseFields</code> field. The
         * following is example JSON for <code>additionalModelResponseFieldPaths</code>.
         * </p>
         * <p>
         * <code>[ "/stop_sequence" ]</code>
         * </p>
         * <p>
         * For information about the JSON Pointer syntax, see the <a
         * href="https://datatracker.ietf.org/doc/html/rfc6901">Internet Engineering Task Force (IETF)</a>
         * documentation.
         * </p>
         * <p>
         * <code>ConverseStream</code> rejects an empty JSON Pointer or incorrectly structured JSON Pointer with a
         * <code>400</code> error code. if the JSON Pointer is valid, but the requested field is not in the model
         * response, it is ignored by <code>ConverseStream</code>.
         * </p>
         * 
         * @param additionalModelResponseFieldPaths
         *        Additional model parameters field paths to return in the response. <code>ConverseStream</code> returns
         *        the requested fields as a JSON Pointer object in the <code>additionalModelResponseFields</code> field.
         *        The following is example JSON for <code>additionalModelResponseFieldPaths</code>.</p>
         *        <p>
         *        <code>[ "/stop_sequence" ]</code>
         *        </p>
         *        <p>
         *        For information about the JSON Pointer syntax, see the <a
         *        href="https://datatracker.ietf.org/doc/html/rfc6901">Internet Engineering Task Force (IETF)</a>
         *        documentation.
         *        </p>
         *        <p>
         *        <code>ConverseStream</code> rejects an empty JSON Pointer or incorrectly structured JSON Pointer with
         *        a <code>400</code> error code. if the JSON Pointer is valid, but the requested field is not in the
         *        model response, it is ignored by <code>ConverseStream</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalModelResponseFieldPaths(Collection<String> additionalModelResponseFieldPaths);

        /**
         * <p>
         * Additional model parameters field paths to return in the response. <code>ConverseStream</code> returns the
         * requested fields as a JSON Pointer object in the <code>additionalModelResponseFields</code> field. The
         * following is example JSON for <code>additionalModelResponseFieldPaths</code>.
         * </p>
         * <p>
         * <code>[ "/stop_sequence" ]</code>
         * </p>
         * <p>
         * For information about the JSON Pointer syntax, see the <a
         * href="https://datatracker.ietf.org/doc/html/rfc6901">Internet Engineering Task Force (IETF)</a>
         * documentation.
         * </p>
         * <p>
         * <code>ConverseStream</code> rejects an empty JSON Pointer or incorrectly structured JSON Pointer with a
         * <code>400</code> error code. if the JSON Pointer is valid, but the requested field is not in the model
         * response, it is ignored by <code>ConverseStream</code>.
         * </p>
         * 
         * @param additionalModelResponseFieldPaths
         *        Additional model parameters field paths to return in the response. <code>ConverseStream</code> returns
         *        the requested fields as a JSON Pointer object in the <code>additionalModelResponseFields</code> field.
         *        The following is example JSON for <code>additionalModelResponseFieldPaths</code>.</p>
         *        <p>
         *        <code>[ "/stop_sequence" ]</code>
         *        </p>
         *        <p>
         *        For information about the JSON Pointer syntax, see the <a
         *        href="https://datatracker.ietf.org/doc/html/rfc6901">Internet Engineering Task Force (IETF)</a>
         *        documentation.
         *        </p>
         *        <p>
         *        <code>ConverseStream</code> rejects an empty JSON Pointer or incorrectly structured JSON Pointer with
         *        a <code>400</code> error code. if the JSON Pointer is valid, but the requested field is not in the
         *        model response, it is ignored by <code>ConverseStream</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalModelResponseFieldPaths(String... additionalModelResponseFieldPaths);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockRuntimeRequest.BuilderImpl implements Builder {
        private String modelId;

        private List<Message> messages = DefaultSdkAutoConstructList.getInstance();

        private List<SystemContentBlock> system = DefaultSdkAutoConstructList.getInstance();

        private InferenceConfiguration inferenceConfig;

        private ToolConfiguration toolConfig;

        private GuardrailStreamConfiguration guardrailConfig;

        private Document additionalModelRequestFields;

        private List<String> additionalModelResponseFieldPaths = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConverseStreamRequest model) {
            super(model);
            modelId(model.modelId);
            messages(model.messages);
            system(model.system);
            inferenceConfig(model.inferenceConfig);
            toolConfig(model.toolConfig);
            guardrailConfig(model.guardrailConfig);
            additionalModelRequestFields(model.additionalModelRequestFields);
            additionalModelResponseFieldPaths(model.additionalModelResponseFieldPaths);
        }

        public final String getModelId() {
            return modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final List<Message.Builder> getMessages() {
            List<Message.Builder> result = MessagesCopier.copyToBuilder(this.messages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMessages(Collection<Message.BuilderImpl> messages) {
            this.messages = MessagesCopier.copyFromBuilder(messages);
        }

        @Override
        public final Builder messages(Collection<Message> messages) {
            this.messages = MessagesCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Message... messages) {
            messages(Arrays.asList(messages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Consumer<Message.Builder>... messages) {
            messages(Stream.of(messages).map(c -> Message.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SystemContentBlock.Builder> getSystem() {
            List<SystemContentBlock.Builder> result = SystemContentBlocksCopier.copyToBuilder(this.system);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSystem(Collection<SystemContentBlock.BuilderImpl> system) {
            this.system = SystemContentBlocksCopier.copyFromBuilder(system);
        }

        @Override
        public final Builder system(Collection<SystemContentBlock> system) {
            this.system = SystemContentBlocksCopier.copy(system);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder system(SystemContentBlock... system) {
            system(Arrays.asList(system));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder system(Consumer<SystemContentBlock.Builder>... system) {
            system(Stream.of(system).map(c -> SystemContentBlock.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final InferenceConfiguration.Builder getInferenceConfig() {
            return inferenceConfig != null ? inferenceConfig.toBuilder() : null;
        }

        public final void setInferenceConfig(InferenceConfiguration.BuilderImpl inferenceConfig) {
            this.inferenceConfig = inferenceConfig != null ? inferenceConfig.build() : null;
        }

        @Override
        public final Builder inferenceConfig(InferenceConfiguration inferenceConfig) {
            this.inferenceConfig = inferenceConfig;
            return this;
        }

        public final ToolConfiguration.Builder getToolConfig() {
            return toolConfig != null ? toolConfig.toBuilder() : null;
        }

        public final void setToolConfig(ToolConfiguration.BuilderImpl toolConfig) {
            this.toolConfig = toolConfig != null ? toolConfig.build() : null;
        }

        @Override
        public final Builder toolConfig(ToolConfiguration toolConfig) {
            this.toolConfig = toolConfig;
            return this;
        }

        public final GuardrailStreamConfiguration.Builder getGuardrailConfig() {
            return guardrailConfig != null ? guardrailConfig.toBuilder() : null;
        }

        public final void setGuardrailConfig(GuardrailStreamConfiguration.BuilderImpl guardrailConfig) {
            this.guardrailConfig = guardrailConfig != null ? guardrailConfig.build() : null;
        }

        @Override
        public final Builder guardrailConfig(GuardrailStreamConfiguration guardrailConfig) {
            this.guardrailConfig = guardrailConfig;
            return this;
        }

        public final Document getAdditionalModelRequestFields() {
            return additionalModelRequestFields;
        }

        public final void setAdditionalModelRequestFields(Document additionalModelRequestFields) {
            this.additionalModelRequestFields = additionalModelRequestFields;
        }

        @Override
        public final Builder additionalModelRequestFields(Document additionalModelRequestFields) {
            this.additionalModelRequestFields = additionalModelRequestFields;
            return this;
        }

        public final Collection<String> getAdditionalModelResponseFieldPaths() {
            if (additionalModelResponseFieldPaths instanceof SdkAutoConstructList) {
                return null;
            }
            return additionalModelResponseFieldPaths;
        }

        public final void setAdditionalModelResponseFieldPaths(Collection<String> additionalModelResponseFieldPaths) {
            this.additionalModelResponseFieldPaths = ConverseStreamRequestAdditionalModelResponseFieldPathsListCopier
                    .copy(additionalModelResponseFieldPaths);
        }

        @Override
        public final Builder additionalModelResponseFieldPaths(Collection<String> additionalModelResponseFieldPaths) {
            this.additionalModelResponseFieldPaths = ConverseStreamRequestAdditionalModelResponseFieldPathsListCopier
                    .copy(additionalModelResponseFieldPaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalModelResponseFieldPaths(String... additionalModelResponseFieldPaths) {
            additionalModelResponseFieldPaths(Arrays.asList(additionalModelResponseFieldPaths));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ConverseStreamRequest build() {
            return new ConverseStreamRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
