/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeClient;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeClientBuilder;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeServiceClientConfiguration;
import software.amazon.awssdk.services.bedrockruntime.DefaultBedrockRuntimeBaseClientBuilder;
import software.amazon.awssdk.services.bedrockruntime.DefaultBedrockRuntimeClient;
import software.amazon.awssdk.services.bedrockruntime.endpoints.BedrockRuntimeEndpointProvider;

@SdkInternalApi
final class DefaultBedrockRuntimeClientBuilder
extends DefaultBedrockRuntimeBaseClientBuilder<BedrockRuntimeClientBuilder, BedrockRuntimeClient>
implements BedrockRuntimeClientBuilder {
    DefaultBedrockRuntimeClientBuilder() {
    }

    @Override
    public DefaultBedrockRuntimeClientBuilder endpointProvider(BedrockRuntimeEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final BedrockRuntimeClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultBedrockRuntimeClientBuilder.validateClientOptions(clientConfiguration);
        BedrockRuntimeServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultBedrockRuntimeClient client = new DefaultBedrockRuntimeClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private BedrockRuntimeServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return BedrockRuntimeServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

