/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockdataautomationruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockdataautomationruntime.model.BedrockDataAutomationRuntimeResponse;
import software.amazon.awssdk.services.bedrockdataautomationruntime.model.OutputSegment;
import software.amazon.awssdk.services.bedrockdataautomationruntime.model.OutputSegmentListCopier;
import software.amazon.awssdk.services.bedrockdataautomationruntime.model.SemanticModality;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvokeDataAutomationResponse
extends BedrockDataAutomationRuntimeResponse
implements ToCopyableBuilder<Builder, InvokeDataAutomationResponse> {
    private static final SdkField<String> SEMANTIC_MODALITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("semanticModality").getter(InvokeDataAutomationResponse.getter(InvokeDataAutomationResponse::semanticModalityAsString)).setter(InvokeDataAutomationResponse.setter(Builder::semanticModality)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("semanticModality").build()}).build();
    private static final SdkField<List<OutputSegment>> OUTPUT_SEGMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("outputSegments").getter(InvokeDataAutomationResponse.getter(InvokeDataAutomationResponse::outputSegments)).setter(InvokeDataAutomationResponse.setter(Builder::outputSegments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputSegments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OutputSegment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEMANTIC_MODALITY_FIELD, OUTPUT_SEGMENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InvokeDataAutomationResponse.memberNameToFieldInitializer();
    private final String semanticModality;
    private final List<OutputSegment> outputSegments;

    private InvokeDataAutomationResponse(BuilderImpl builder) {
        super(builder);
        this.semanticModality = builder.semanticModality;
        this.outputSegments = builder.outputSegments;
    }

    public final SemanticModality semanticModality() {
        return SemanticModality.fromValue(this.semanticModality);
    }

    public final String semanticModalityAsString() {
        return this.semanticModality;
    }

    public final boolean hasOutputSegments() {
        return this.outputSegments != null && !(this.outputSegments instanceof SdkAutoConstructList);
    }

    public final List<OutputSegment> outputSegments() {
        return this.outputSegments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.semanticModalityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputSegments() ? this.outputSegments() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeDataAutomationResponse)) {
            return false;
        }
        InvokeDataAutomationResponse other = (InvokeDataAutomationResponse)((Object)obj);
        return Objects.equals(this.semanticModalityAsString(), other.semanticModalityAsString()) && this.hasOutputSegments() == other.hasOutputSegments() && Objects.equals(this.outputSegments(), other.outputSegments());
    }

    public final String toString() {
        return ToString.builder((String)"InvokeDataAutomationResponse").add("SemanticModality", (Object)this.semanticModalityAsString()).add("OutputSegments", this.hasOutputSegments() ? this.outputSegments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "semanticModality": {
                return Optional.ofNullable(clazz.cast(this.semanticModalityAsString()));
            }
            case "outputSegments": {
                return Optional.ofNullable(clazz.cast(this.outputSegments()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("semanticModality", SEMANTIC_MODALITY_FIELD);
        map.put("outputSegments", OUTPUT_SEGMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvokeDataAutomationResponse, T> g) {
        return obj -> g.apply((InvokeDataAutomationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockDataAutomationRuntimeResponse.BuilderImpl
    implements Builder {
        private String semanticModality;
        private List<OutputSegment> outputSegments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeDataAutomationResponse model) {
            super(model);
            this.semanticModality(model.semanticModality);
            this.outputSegments(model.outputSegments);
        }

        public final String getSemanticModality() {
            return this.semanticModality;
        }

        public final void setSemanticModality(String semanticModality) {
            this.semanticModality = semanticModality;
        }

        @Override
        public final Builder semanticModality(String semanticModality) {
            this.semanticModality = semanticModality;
            return this;
        }

        @Override
        public final Builder semanticModality(SemanticModality semanticModality) {
            this.semanticModality(semanticModality == null ? null : semanticModality.toString());
            return this;
        }

        public final List<OutputSegment.Builder> getOutputSegments() {
            List<OutputSegment.Builder> result = OutputSegmentListCopier.copyToBuilder(this.outputSegments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputSegments(Collection<OutputSegment.BuilderImpl> outputSegments) {
            this.outputSegments = OutputSegmentListCopier.copyFromBuilder(outputSegments);
        }

        @Override
        public final Builder outputSegments(Collection<OutputSegment> outputSegments) {
            this.outputSegments = OutputSegmentListCopier.copy(outputSegments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputSegments(OutputSegment ... outputSegments) {
            this.outputSegments(Arrays.asList(outputSegments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputSegments(Consumer<OutputSegment.Builder> ... outputSegments) {
            this.outputSegments(Stream.of(outputSegments).map(c -> (OutputSegment)((OutputSegment.Builder)OutputSegment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public InvokeDataAutomationResponse build() {
            return new InvokeDataAutomationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockDataAutomationRuntimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, InvokeDataAutomationResponse> {
        public Builder semanticModality(String var1);

        public Builder semanticModality(SemanticModality var1);

        public Builder outputSegments(Collection<OutputSegment> var1);

        public Builder outputSegments(OutputSegment ... var1);

        public Builder outputSegments(Consumer<OutputSegment.Builder> ... var1);
    }
}

