/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockdataautomation.model.CustomOutputConfiguration;
import software.amazon.awssdk.services.bedrockdataautomation.model.DataAutomationProjectStage;
import software.amazon.awssdk.services.bedrockdataautomation.model.DataAutomationProjectStatus;
import software.amazon.awssdk.services.bedrockdataautomation.model.DataAutomationProjectType;
import software.amazon.awssdk.services.bedrockdataautomation.model.KmsEncryptionContextCopier;
import software.amazon.awssdk.services.bedrockdataautomation.model.OverrideConfiguration;
import software.amazon.awssdk.services.bedrockdataautomation.model.StandardOutputConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataAutomationProject
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataAutomationProject> {
    private static final SdkField<String> PROJECT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectArn").getter(DataAutomationProject.getter(DataAutomationProject::projectArn)).setter(DataAutomationProject.setter(Builder::projectArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectArn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(DataAutomationProject.getter(DataAutomationProject::creationTime)).setter(DataAutomationProject.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedTime").getter(DataAutomationProject.getter(DataAutomationProject::lastModifiedTime)).setter(DataAutomationProject.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectName").getter(DataAutomationProject.getter(DataAutomationProject::projectName)).setter(DataAutomationProject.setter(Builder::projectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectName").build()}).build();
    private static final SdkField<String> PROJECT_STAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectStage").getter(DataAutomationProject.getter(DataAutomationProject::projectStageAsString)).setter(DataAutomationProject.setter(Builder::projectStage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectStage").build()}).build();
    private static final SdkField<String> PROJECT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectType").getter(DataAutomationProject.getter(DataAutomationProject::projectTypeAsString)).setter(DataAutomationProject.setter(Builder::projectType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectType").build()}).build();
    private static final SdkField<String> PROJECT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectDescription").getter(DataAutomationProject.getter(DataAutomationProject::projectDescription)).setter(DataAutomationProject.setter(Builder::projectDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectDescription").build()}).build();
    private static final SdkField<StandardOutputConfiguration> STANDARD_OUTPUT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("standardOutputConfiguration").getter(DataAutomationProject.getter(DataAutomationProject::standardOutputConfiguration)).setter(DataAutomationProject.setter(Builder::standardOutputConfiguration)).constructor(StandardOutputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("standardOutputConfiguration").build()}).build();
    private static final SdkField<CustomOutputConfiguration> CUSTOM_OUTPUT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("customOutputConfiguration").getter(DataAutomationProject.getter(DataAutomationProject::customOutputConfiguration)).setter(DataAutomationProject.setter(Builder::customOutputConfiguration)).constructor(CustomOutputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customOutputConfiguration").build()}).build();
    private static final SdkField<OverrideConfiguration> OVERRIDE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("overrideConfiguration").getter(DataAutomationProject.getter(DataAutomationProject::overrideConfigurationValue)).setter(DataAutomationProject.setter(Builder::overrideConfigurationValue)).constructor(OverrideConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrideConfiguration").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DataAutomationProject.getter(DataAutomationProject::statusAsString)).setter(DataAutomationProject.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyId").getter(DataAutomationProject.getter(DataAutomationProject::kmsKeyId)).setter(DataAutomationProject.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()}).build();
    private static final SdkField<Map<String, String>> KMS_ENCRYPTION_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("kmsEncryptionContext").getter(DataAutomationProject.getter(DataAutomationProject::kmsEncryptionContext)).setter(DataAutomationProject.setter(Builder::kmsEncryptionContext)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsEncryptionContext").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_ARN_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, PROJECT_NAME_FIELD, PROJECT_STAGE_FIELD, PROJECT_TYPE_FIELD, PROJECT_DESCRIPTION_FIELD, STANDARD_OUTPUT_CONFIGURATION_FIELD, CUSTOM_OUTPUT_CONFIGURATION_FIELD, OVERRIDE_CONFIGURATION_FIELD, STATUS_FIELD, KMS_KEY_ID_FIELD, KMS_ENCRYPTION_CONTEXT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataAutomationProject.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String projectArn;
    private final Instant creationTime;
    private final Instant lastModifiedTime;
    private final String projectName;
    private final String projectStage;
    private final String projectType;
    private final String projectDescription;
    private final StandardOutputConfiguration standardOutputConfiguration;
    private final CustomOutputConfiguration customOutputConfiguration;
    private final OverrideConfiguration overrideConfigurationValue;
    private final String status;
    private final String kmsKeyId;
    private final Map<String, String> kmsEncryptionContext;

    private DataAutomationProject(BuilderImpl builder) {
        this.projectArn = builder.projectArn;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.projectName = builder.projectName;
        this.projectStage = builder.projectStage;
        this.projectType = builder.projectType;
        this.projectDescription = builder.projectDescription;
        this.standardOutputConfiguration = builder.standardOutputConfiguration;
        this.customOutputConfiguration = builder.customOutputConfiguration;
        this.overrideConfigurationValue = builder.overrideConfigurationValue;
        this.status = builder.status;
        this.kmsKeyId = builder.kmsKeyId;
        this.kmsEncryptionContext = builder.kmsEncryptionContext;
    }

    public final String projectArn() {
        return this.projectArn;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String projectName() {
        return this.projectName;
    }

    public final DataAutomationProjectStage projectStage() {
        return DataAutomationProjectStage.fromValue(this.projectStage);
    }

    public final String projectStageAsString() {
        return this.projectStage;
    }

    public final DataAutomationProjectType projectType() {
        return DataAutomationProjectType.fromValue(this.projectType);
    }

    public final String projectTypeAsString() {
        return this.projectType;
    }

    public final String projectDescription() {
        return this.projectDescription;
    }

    public final StandardOutputConfiguration standardOutputConfiguration() {
        return this.standardOutputConfiguration;
    }

    public final CustomOutputConfiguration customOutputConfiguration() {
        return this.customOutputConfiguration;
    }

    public final OverrideConfiguration overrideConfigurationValue() {
        return this.overrideConfigurationValue;
    }

    public final DataAutomationProjectStatus status() {
        return DataAutomationProjectStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final boolean hasKmsEncryptionContext() {
        return this.kmsEncryptionContext != null && !(this.kmsEncryptionContext instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> kmsEncryptionContext() {
        return this.kmsEncryptionContext;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.projectArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectStageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.standardOutputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.customOutputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.overrideConfigurationValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKmsEncryptionContext() ? this.kmsEncryptionContext() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataAutomationProject)) {
            return false;
        }
        DataAutomationProject other = (DataAutomationProject)obj;
        return Objects.equals(this.projectArn(), other.projectArn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.projectName(), other.projectName()) && Objects.equals(this.projectStageAsString(), other.projectStageAsString()) && Objects.equals(this.projectTypeAsString(), other.projectTypeAsString()) && Objects.equals(this.projectDescription(), other.projectDescription()) && Objects.equals(this.standardOutputConfiguration(), other.standardOutputConfiguration()) && Objects.equals(this.customOutputConfiguration(), other.customOutputConfiguration()) && Objects.equals(this.overrideConfigurationValue(), other.overrideConfigurationValue()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && this.hasKmsEncryptionContext() == other.hasKmsEncryptionContext() && Objects.equals(this.kmsEncryptionContext(), other.kmsEncryptionContext());
    }

    public final String toString() {
        return ToString.builder((String)"DataAutomationProject").add("ProjectArn", (Object)this.projectArn()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("ProjectName", (Object)(this.projectName() == null ? null : "*** Sensitive Data Redacted ***")).add("ProjectStage", (Object)this.projectStageAsString()).add("ProjectType", (Object)this.projectTypeAsString()).add("ProjectDescription", (Object)(this.projectDescription() == null ? null : "*** Sensitive Data Redacted ***")).add("StandardOutputConfiguration", (Object)this.standardOutputConfiguration()).add("CustomOutputConfiguration", (Object)this.customOutputConfiguration()).add("OverrideConfiguration", (Object)this.overrideConfigurationValue()).add("Status", (Object)this.statusAsString()).add("KmsKeyId", (Object)this.kmsKeyId()).add("KmsEncryptionContext", this.hasKmsEncryptionContext() ? this.kmsEncryptionContext() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "projectArn": {
                return Optional.ofNullable(clazz.cast(this.projectArn()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "lastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "projectName": {
                return Optional.ofNullable(clazz.cast(this.projectName()));
            }
            case "projectStage": {
                return Optional.ofNullable(clazz.cast(this.projectStageAsString()));
            }
            case "projectType": {
                return Optional.ofNullable(clazz.cast(this.projectTypeAsString()));
            }
            case "projectDescription": {
                return Optional.ofNullable(clazz.cast(this.projectDescription()));
            }
            case "standardOutputConfiguration": {
                return Optional.ofNullable(clazz.cast(this.standardOutputConfiguration()));
            }
            case "customOutputConfiguration": {
                return Optional.ofNullable(clazz.cast(this.customOutputConfiguration()));
            }
            case "overrideConfiguration": {
                return Optional.ofNullable(clazz.cast(this.overrideConfigurationValue()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "kmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "kmsEncryptionContext": {
                return Optional.ofNullable(clazz.cast(this.kmsEncryptionContext()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("projectArn", PROJECT_ARN_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("lastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("projectName", PROJECT_NAME_FIELD);
        map.put("projectStage", PROJECT_STAGE_FIELD);
        map.put("projectType", PROJECT_TYPE_FIELD);
        map.put("projectDescription", PROJECT_DESCRIPTION_FIELD);
        map.put("standardOutputConfiguration", STANDARD_OUTPUT_CONFIGURATION_FIELD);
        map.put("customOutputConfiguration", CUSTOM_OUTPUT_CONFIGURATION_FIELD);
        map.put("overrideConfiguration", OVERRIDE_CONFIGURATION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("kmsKeyId", KMS_KEY_ID_FIELD);
        map.put("kmsEncryptionContext", KMS_ENCRYPTION_CONTEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataAutomationProject, T> g) {
        return obj -> g.apply((DataAutomationProject)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String projectArn;
        private Instant creationTime;
        private Instant lastModifiedTime;
        private String projectName;
        private String projectStage;
        private String projectType;
        private String projectDescription;
        private StandardOutputConfiguration standardOutputConfiguration;
        private CustomOutputConfiguration customOutputConfiguration;
        private OverrideConfiguration overrideConfigurationValue;
        private String status;
        private String kmsKeyId;
        private Map<String, String> kmsEncryptionContext = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DataAutomationProject model) {
            this.projectArn(model.projectArn);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.projectName(model.projectName);
            this.projectStage(model.projectStage);
            this.projectType(model.projectType);
            this.projectDescription(model.projectDescription);
            this.standardOutputConfiguration(model.standardOutputConfiguration);
            this.customOutputConfiguration(model.customOutputConfiguration);
            this.overrideConfigurationValue(model.overrideConfigurationValue);
            this.status(model.status);
            this.kmsKeyId(model.kmsKeyId);
            this.kmsEncryptionContext(model.kmsEncryptionContext);
        }

        public final String getProjectArn() {
            return this.projectArn;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getProjectName() {
            return this.projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final String getProjectStage() {
            return this.projectStage;
        }

        public final void setProjectStage(String projectStage) {
            this.projectStage = projectStage;
        }

        @Override
        public final Builder projectStage(String projectStage) {
            this.projectStage = projectStage;
            return this;
        }

        @Override
        public final Builder projectStage(DataAutomationProjectStage projectStage) {
            this.projectStage(projectStage == null ? null : projectStage.toString());
            return this;
        }

        public final String getProjectType() {
            return this.projectType;
        }

        public final void setProjectType(String projectType) {
            this.projectType = projectType;
        }

        @Override
        public final Builder projectType(String projectType) {
            this.projectType = projectType;
            return this;
        }

        @Override
        public final Builder projectType(DataAutomationProjectType projectType) {
            this.projectType(projectType == null ? null : projectType.toString());
            return this;
        }

        public final String getProjectDescription() {
            return this.projectDescription;
        }

        public final void setProjectDescription(String projectDescription) {
            this.projectDescription = projectDescription;
        }

        @Override
        public final Builder projectDescription(String projectDescription) {
            this.projectDescription = projectDescription;
            return this;
        }

        public final StandardOutputConfiguration.Builder getStandardOutputConfiguration() {
            return this.standardOutputConfiguration != null ? this.standardOutputConfiguration.toBuilder() : null;
        }

        public final void setStandardOutputConfiguration(StandardOutputConfiguration.BuilderImpl standardOutputConfiguration) {
            this.standardOutputConfiguration = standardOutputConfiguration != null ? standardOutputConfiguration.build() : null;
        }

        @Override
        public final Builder standardOutputConfiguration(StandardOutputConfiguration standardOutputConfiguration) {
            this.standardOutputConfiguration = standardOutputConfiguration;
            return this;
        }

        public final CustomOutputConfiguration.Builder getCustomOutputConfiguration() {
            return this.customOutputConfiguration != null ? this.customOutputConfiguration.toBuilder() : null;
        }

        public final void setCustomOutputConfiguration(CustomOutputConfiguration.BuilderImpl customOutputConfiguration) {
            this.customOutputConfiguration = customOutputConfiguration != null ? customOutputConfiguration.build() : null;
        }

        @Override
        public final Builder customOutputConfiguration(CustomOutputConfiguration customOutputConfiguration) {
            this.customOutputConfiguration = customOutputConfiguration;
            return this;
        }

        public final OverrideConfiguration.Builder getOverrideConfigurationValue() {
            return this.overrideConfigurationValue != null ? this.overrideConfigurationValue.toBuilder() : null;
        }

        public final void setOverrideConfigurationValue(OverrideConfiguration.BuilderImpl overrideConfigurationValue) {
            this.overrideConfigurationValue = overrideConfigurationValue != null ? overrideConfigurationValue.build() : null;
        }

        @Override
        public final Builder overrideConfigurationValue(OverrideConfiguration overrideConfigurationValue) {
            this.overrideConfigurationValue = overrideConfigurationValue;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DataAutomationProjectStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Map<String, String> getKmsEncryptionContext() {
            if (this.kmsEncryptionContext instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.kmsEncryptionContext;
        }

        public final void setKmsEncryptionContext(Map<String, String> kmsEncryptionContext) {
            this.kmsEncryptionContext = KmsEncryptionContextCopier.copy(kmsEncryptionContext);
        }

        @Override
        public final Builder kmsEncryptionContext(Map<String, String> kmsEncryptionContext) {
            this.kmsEncryptionContext = KmsEncryptionContextCopier.copy(kmsEncryptionContext);
            return this;
        }

        public DataAutomationProject build() {
            return new DataAutomationProject(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataAutomationProject> {
        public Builder projectArn(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder projectName(String var1);

        public Builder projectStage(String var1);

        public Builder projectStage(DataAutomationProjectStage var1);

        public Builder projectType(String var1);

        public Builder projectType(DataAutomationProjectType var1);

        public Builder projectDescription(String var1);

        public Builder standardOutputConfiguration(StandardOutputConfiguration var1);

        default public Builder standardOutputConfiguration(Consumer<StandardOutputConfiguration.Builder> standardOutputConfiguration) {
            return this.standardOutputConfiguration((StandardOutputConfiguration)((StandardOutputConfiguration.Builder)StandardOutputConfiguration.builder().applyMutation(standardOutputConfiguration)).build());
        }

        public Builder customOutputConfiguration(CustomOutputConfiguration var1);

        default public Builder customOutputConfiguration(Consumer<CustomOutputConfiguration.Builder> customOutputConfiguration) {
            return this.customOutputConfiguration((CustomOutputConfiguration)((CustomOutputConfiguration.Builder)CustomOutputConfiguration.builder().applyMutation(customOutputConfiguration)).build());
        }

        public Builder overrideConfigurationValue(OverrideConfiguration var1);

        default public Builder overrideConfigurationValue(Consumer<OverrideConfiguration.Builder> overrideConfigurationValue) {
            return this.overrideConfigurationValue((OverrideConfiguration)((OverrideConfiguration.Builder)OverrideConfiguration.builder().applyMutation(overrideConfigurationValue)).build());
        }

        public Builder status(String var1);

        public Builder status(DataAutomationProjectStatus var1);

        public Builder kmsKeyId(String var1);

        public Builder kmsEncryptionContext(Map<String, String> var1);
    }
}

