/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockdataautomation.model.BedrockDataAutomationRequest;
import software.amazon.awssdk.services.bedrockdataautomation.model.BlueprintStage;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CopyBlueprintStageRequest
extends BedrockDataAutomationRequest
implements ToCopyableBuilder<Builder, CopyBlueprintStageRequest> {
    private static final SdkField<String> BLUEPRINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("blueprintArn").getter(CopyBlueprintStageRequest.getter(CopyBlueprintStageRequest::blueprintArn)).setter(CopyBlueprintStageRequest.setter(Builder::blueprintArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("blueprintArn").build()}).build();
    private static final SdkField<String> SOURCE_STAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceStage").getter(CopyBlueprintStageRequest.getter(CopyBlueprintStageRequest::sourceStageAsString)).setter(CopyBlueprintStageRequest.setter(Builder::sourceStage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceStage").build()}).build();
    private static final SdkField<String> TARGET_STAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetStage").getter(CopyBlueprintStageRequest.getter(CopyBlueprintStageRequest::targetStageAsString)).setter(CopyBlueprintStageRequest.setter(Builder::targetStage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetStage").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CopyBlueprintStageRequest.getter(CopyBlueprintStageRequest::clientToken)).setter(CopyBlueprintStageRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLUEPRINT_ARN_FIELD, SOURCE_STAGE_FIELD, TARGET_STAGE_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CopyBlueprintStageRequest.memberNameToFieldInitializer();
    private final String blueprintArn;
    private final String sourceStage;
    private final String targetStage;
    private final String clientToken;

    private CopyBlueprintStageRequest(BuilderImpl builder) {
        super(builder);
        this.blueprintArn = builder.blueprintArn;
        this.sourceStage = builder.sourceStage;
        this.targetStage = builder.targetStage;
        this.clientToken = builder.clientToken;
    }

    public final String blueprintArn() {
        return this.blueprintArn;
    }

    public final BlueprintStage sourceStage() {
        return BlueprintStage.fromValue(this.sourceStage);
    }

    public final String sourceStageAsString() {
        return this.sourceStage;
    }

    public final BlueprintStage targetStage() {
        return BlueprintStage.fromValue(this.targetStage);
    }

    public final String targetStageAsString() {
        return this.targetStage;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.blueprintArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceStageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetStageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyBlueprintStageRequest)) {
            return false;
        }
        CopyBlueprintStageRequest other = (CopyBlueprintStageRequest)((Object)obj);
        return Objects.equals(this.blueprintArn(), other.blueprintArn()) && Objects.equals(this.sourceStageAsString(), other.sourceStageAsString()) && Objects.equals(this.targetStageAsString(), other.targetStageAsString()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CopyBlueprintStageRequest").add("BlueprintArn", (Object)this.blueprintArn()).add("SourceStage", (Object)this.sourceStageAsString()).add("TargetStage", (Object)this.targetStageAsString()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "blueprintArn": {
                return Optional.ofNullable(clazz.cast(this.blueprintArn()));
            }
            case "sourceStage": {
                return Optional.ofNullable(clazz.cast(this.sourceStageAsString()));
            }
            case "targetStage": {
                return Optional.ofNullable(clazz.cast(this.targetStageAsString()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("blueprintArn", BLUEPRINT_ARN_FIELD);
        map.put("sourceStage", SOURCE_STAGE_FIELD);
        map.put("targetStage", TARGET_STAGE_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CopyBlueprintStageRequest, T> g) {
        return obj -> g.apply((CopyBlueprintStageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockDataAutomationRequest.BuilderImpl
    implements Builder {
        private String blueprintArn;
        private String sourceStage;
        private String targetStage;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyBlueprintStageRequest model) {
            super(model);
            this.blueprintArn(model.blueprintArn);
            this.sourceStage(model.sourceStage);
            this.targetStage(model.targetStage);
            this.clientToken(model.clientToken);
        }

        public final String getBlueprintArn() {
            return this.blueprintArn;
        }

        public final void setBlueprintArn(String blueprintArn) {
            this.blueprintArn = blueprintArn;
        }

        @Override
        public final Builder blueprintArn(String blueprintArn) {
            this.blueprintArn = blueprintArn;
            return this;
        }

        public final String getSourceStage() {
            return this.sourceStage;
        }

        public final void setSourceStage(String sourceStage) {
            this.sourceStage = sourceStage;
        }

        @Override
        public final Builder sourceStage(String sourceStage) {
            this.sourceStage = sourceStage;
            return this;
        }

        @Override
        public final Builder sourceStage(BlueprintStage sourceStage) {
            this.sourceStage(sourceStage == null ? null : sourceStage.toString());
            return this;
        }

        public final String getTargetStage() {
            return this.targetStage;
        }

        public final void setTargetStage(String targetStage) {
            this.targetStage = targetStage;
        }

        @Override
        public final Builder targetStage(String targetStage) {
            this.targetStage = targetStage;
            return this;
        }

        @Override
        public final Builder targetStage(BlueprintStage targetStage) {
            this.targetStage(targetStage == null ? null : targetStage.toString());
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CopyBlueprintStageRequest build() {
            return new CopyBlueprintStageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockDataAutomationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CopyBlueprintStageRequest> {
        public Builder blueprintArn(String var1);

        public Builder sourceStage(String var1);

        public Builder sourceStage(BlueprintStage var1);

        public Builder targetStage(String var1);

        public Builder targetStage(BlueprintStage var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

