/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockdataautomation.model.BedrockDataAutomationRequest;
import software.amazon.awssdk.services.bedrockdataautomation.model.BlueprintOptimizationObject;
import software.amazon.awssdk.services.bedrockdataautomation.model.BlueprintOptimizationOutputConfiguration;
import software.amazon.awssdk.services.bedrockdataautomation.model.BlueprintOptimizationSample;
import software.amazon.awssdk.services.bedrockdataautomation.model.BlueprintOptimizationSamplesCopier;
import software.amazon.awssdk.services.bedrockdataautomation.model.EncryptionConfiguration;
import software.amazon.awssdk.services.bedrockdataautomation.model.Tag;
import software.amazon.awssdk.services.bedrockdataautomation.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvokeBlueprintOptimizationAsyncRequest
extends BedrockDataAutomationRequest
implements ToCopyableBuilder<Builder, InvokeBlueprintOptimizationAsyncRequest> {
    private static final SdkField<BlueprintOptimizationObject> BLUEPRINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("blueprint").getter(InvokeBlueprintOptimizationAsyncRequest.getter(InvokeBlueprintOptimizationAsyncRequest::blueprint)).setter(InvokeBlueprintOptimizationAsyncRequest.setter(Builder::blueprint)).constructor(BlueprintOptimizationObject::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprint").build()}).build();
    private static final SdkField<List<BlueprintOptimizationSample>> SAMPLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("samples").getter(InvokeBlueprintOptimizationAsyncRequest.getter(InvokeBlueprintOptimizationAsyncRequest::samples)).setter(InvokeBlueprintOptimizationAsyncRequest.setter(Builder::samples)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("samples").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BlueprintOptimizationSample::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<BlueprintOptimizationOutputConfiguration> OUTPUT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outputConfiguration").getter(InvokeBlueprintOptimizationAsyncRequest.getter(InvokeBlueprintOptimizationAsyncRequest::outputConfiguration)).setter(InvokeBlueprintOptimizationAsyncRequest.setter(Builder::outputConfiguration)).constructor(BlueprintOptimizationOutputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputConfiguration").build()}).build();
    private static final SdkField<String> DATA_AUTOMATION_PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataAutomationProfileArn").getter(InvokeBlueprintOptimizationAsyncRequest.getter(InvokeBlueprintOptimizationAsyncRequest::dataAutomationProfileArn)).setter(InvokeBlueprintOptimizationAsyncRequest.setter(Builder::dataAutomationProfileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataAutomationProfileArn").build()}).build();
    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("encryptionConfiguration").getter(InvokeBlueprintOptimizationAsyncRequest.getter(InvokeBlueprintOptimizationAsyncRequest::encryptionConfiguration)).setter(InvokeBlueprintOptimizationAsyncRequest.setter(Builder::encryptionConfiguration)).constructor(EncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionConfiguration").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(InvokeBlueprintOptimizationAsyncRequest.getter(InvokeBlueprintOptimizationAsyncRequest::tags)).setter(InvokeBlueprintOptimizationAsyncRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLUEPRINT_FIELD, SAMPLES_FIELD, OUTPUT_CONFIGURATION_FIELD, DATA_AUTOMATION_PROFILE_ARN_FIELD, ENCRYPTION_CONFIGURATION_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InvokeBlueprintOptimizationAsyncRequest.memberNameToFieldInitializer();
    private final BlueprintOptimizationObject blueprint;
    private final List<BlueprintOptimizationSample> samples;
    private final BlueprintOptimizationOutputConfiguration outputConfiguration;
    private final String dataAutomationProfileArn;
    private final EncryptionConfiguration encryptionConfiguration;
    private final List<Tag> tags;

    private InvokeBlueprintOptimizationAsyncRequest(BuilderImpl builder) {
        super(builder);
        this.blueprint = builder.blueprint;
        this.samples = builder.samples;
        this.outputConfiguration = builder.outputConfiguration;
        this.dataAutomationProfileArn = builder.dataAutomationProfileArn;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.tags = builder.tags;
    }

    public final BlueprintOptimizationObject blueprint() {
        return this.blueprint;
    }

    public final boolean hasSamples() {
        return this.samples != null && !(this.samples instanceof SdkAutoConstructList);
    }

    public final List<BlueprintOptimizationSample> samples() {
        return this.samples;
    }

    public final BlueprintOptimizationOutputConfiguration outputConfiguration() {
        return this.outputConfiguration;
    }

    public final String dataAutomationProfileArn() {
        return this.dataAutomationProfileArn;
    }

    public final EncryptionConfiguration encryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.blueprint());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSamples() ? this.samples() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataAutomationProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeBlueprintOptimizationAsyncRequest)) {
            return false;
        }
        InvokeBlueprintOptimizationAsyncRequest other = (InvokeBlueprintOptimizationAsyncRequest)((Object)obj);
        return Objects.equals(this.blueprint(), other.blueprint()) && this.hasSamples() == other.hasSamples() && Objects.equals(this.samples(), other.samples()) && Objects.equals(this.outputConfiguration(), other.outputConfiguration()) && Objects.equals(this.dataAutomationProfileArn(), other.dataAutomationProfileArn()) && Objects.equals(this.encryptionConfiguration(), other.encryptionConfiguration()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"InvokeBlueprintOptimizationAsyncRequest").add("Blueprint", (Object)this.blueprint()).add("Samples", this.hasSamples() ? this.samples() : null).add("OutputConfiguration", (Object)this.outputConfiguration()).add("DataAutomationProfileArn", (Object)this.dataAutomationProfileArn()).add("EncryptionConfiguration", (Object)this.encryptionConfiguration()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "blueprint": {
                return Optional.ofNullable(clazz.cast(this.blueprint()));
            }
            case "samples": {
                return Optional.ofNullable(clazz.cast(this.samples()));
            }
            case "outputConfiguration": {
                return Optional.ofNullable(clazz.cast(this.outputConfiguration()));
            }
            case "dataAutomationProfileArn": {
                return Optional.ofNullable(clazz.cast(this.dataAutomationProfileArn()));
            }
            case "encryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfiguration()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("blueprint", BLUEPRINT_FIELD);
        map.put("samples", SAMPLES_FIELD);
        map.put("outputConfiguration", OUTPUT_CONFIGURATION_FIELD);
        map.put("dataAutomationProfileArn", DATA_AUTOMATION_PROFILE_ARN_FIELD);
        map.put("encryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvokeBlueprintOptimizationAsyncRequest, T> g) {
        return obj -> g.apply((InvokeBlueprintOptimizationAsyncRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockDataAutomationRequest.BuilderImpl
    implements Builder {
        private BlueprintOptimizationObject blueprint;
        private List<BlueprintOptimizationSample> samples = DefaultSdkAutoConstructList.getInstance();
        private BlueprintOptimizationOutputConfiguration outputConfiguration;
        private String dataAutomationProfileArn;
        private EncryptionConfiguration encryptionConfiguration;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeBlueprintOptimizationAsyncRequest model) {
            super(model);
            this.blueprint(model.blueprint);
            this.samples(model.samples);
            this.outputConfiguration(model.outputConfiguration);
            this.dataAutomationProfileArn(model.dataAutomationProfileArn);
            this.encryptionConfiguration(model.encryptionConfiguration);
            this.tags(model.tags);
        }

        public final BlueprintOptimizationObject.Builder getBlueprint() {
            return this.blueprint != null ? this.blueprint.toBuilder() : null;
        }

        public final void setBlueprint(BlueprintOptimizationObject.BuilderImpl blueprint) {
            this.blueprint = blueprint != null ? blueprint.build() : null;
        }

        @Override
        public final Builder blueprint(BlueprintOptimizationObject blueprint) {
            this.blueprint = blueprint;
            return this;
        }

        public final List<BlueprintOptimizationSample.Builder> getSamples() {
            List<BlueprintOptimizationSample.Builder> result = BlueprintOptimizationSamplesCopier.copyToBuilder(this.samples);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSamples(Collection<BlueprintOptimizationSample.BuilderImpl> samples) {
            this.samples = BlueprintOptimizationSamplesCopier.copyFromBuilder(samples);
        }

        @Override
        public final Builder samples(Collection<BlueprintOptimizationSample> samples) {
            this.samples = BlueprintOptimizationSamplesCopier.copy(samples);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder samples(BlueprintOptimizationSample ... samples) {
            this.samples(Arrays.asList(samples));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder samples(Consumer<BlueprintOptimizationSample.Builder> ... samples) {
            this.samples(Stream.of(samples).map(c -> (BlueprintOptimizationSample)((BlueprintOptimizationSample.Builder)BlueprintOptimizationSample.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final BlueprintOptimizationOutputConfiguration.Builder getOutputConfiguration() {
            return this.outputConfiguration != null ? this.outputConfiguration.toBuilder() : null;
        }

        public final void setOutputConfiguration(BlueprintOptimizationOutputConfiguration.BuilderImpl outputConfiguration) {
            this.outputConfiguration = outputConfiguration != null ? outputConfiguration.build() : null;
        }

        @Override
        public final Builder outputConfiguration(BlueprintOptimizationOutputConfiguration outputConfiguration) {
            this.outputConfiguration = outputConfiguration;
            return this;
        }

        public final String getDataAutomationProfileArn() {
            return this.dataAutomationProfileArn;
        }

        public final void setDataAutomationProfileArn(String dataAutomationProfileArn) {
            this.dataAutomationProfileArn = dataAutomationProfileArn;
        }

        @Override
        public final Builder dataAutomationProfileArn(String dataAutomationProfileArn) {
            this.dataAutomationProfileArn = dataAutomationProfileArn;
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return this.encryptionConfiguration != null ? this.encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InvokeBlueprintOptimizationAsyncRequest build() {
            return new InvokeBlueprintOptimizationAsyncRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockDataAutomationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, InvokeBlueprintOptimizationAsyncRequest> {
        public Builder blueprint(BlueprintOptimizationObject var1);

        default public Builder blueprint(Consumer<BlueprintOptimizationObject.Builder> blueprint) {
            return this.blueprint((BlueprintOptimizationObject)((BlueprintOptimizationObject.Builder)BlueprintOptimizationObject.builder().applyMutation(blueprint)).build());
        }

        public Builder samples(Collection<BlueprintOptimizationSample> var1);

        public Builder samples(BlueprintOptimizationSample ... var1);

        public Builder samples(Consumer<BlueprintOptimizationSample.Builder> ... var1);

        public Builder outputConfiguration(BlueprintOptimizationOutputConfiguration var1);

        default public Builder outputConfiguration(Consumer<BlueprintOptimizationOutputConfiguration.Builder> outputConfiguration) {
            return this.outputConfiguration((BlueprintOptimizationOutputConfiguration)((BlueprintOptimizationOutputConfiguration.Builder)BlueprintOptimizationOutputConfiguration.builder().applyMutation(outputConfiguration)).build());
        }

        public Builder dataAutomationProfileArn(String var1);

        public Builder encryptionConfiguration(EncryptionConfiguration var1);

        default public Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return this.encryptionConfiguration((EncryptionConfiguration)((EncryptionConfiguration.Builder)EncryptionConfiguration.builder().applyMutation(encryptionConfiguration)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

