/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockdataautomation.model.VideoStandardExtraction;
import software.amazon.awssdk.services.bedrockdataautomation.model.VideoStandardGenerativeField;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VideoStandardOutputConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VideoStandardOutputConfiguration> {
    private static final SdkField<VideoStandardExtraction> EXTRACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("extraction").getter(VideoStandardOutputConfiguration.getter(VideoStandardOutputConfiguration::extraction)).setter(VideoStandardOutputConfiguration.setter(Builder::extraction)).constructor(VideoStandardExtraction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("extraction").build()}).build();
    private static final SdkField<VideoStandardGenerativeField> GENERATIVE_FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("generativeField").getter(VideoStandardOutputConfiguration.getter(VideoStandardOutputConfiguration::generativeField)).setter(VideoStandardOutputConfiguration.setter(Builder::generativeField)).constructor(VideoStandardGenerativeField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generativeField").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXTRACTION_FIELD, GENERATIVE_FIELD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VideoStandardOutputConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final VideoStandardExtraction extraction;
    private final VideoStandardGenerativeField generativeField;

    private VideoStandardOutputConfiguration(BuilderImpl builder) {
        this.extraction = builder.extraction;
        this.generativeField = builder.generativeField;
    }

    public final VideoStandardExtraction extraction() {
        return this.extraction;
    }

    public final VideoStandardGenerativeField generativeField() {
        return this.generativeField;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.extraction());
        hashCode = 31 * hashCode + Objects.hashCode(this.generativeField());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoStandardOutputConfiguration)) {
            return false;
        }
        VideoStandardOutputConfiguration other = (VideoStandardOutputConfiguration)obj;
        return Objects.equals(this.extraction(), other.extraction()) && Objects.equals(this.generativeField(), other.generativeField());
    }

    public final String toString() {
        return ToString.builder((String)"VideoStandardOutputConfiguration").add("Extraction", (Object)this.extraction()).add("GenerativeField", (Object)this.generativeField()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "extraction": {
                return Optional.ofNullable(clazz.cast(this.extraction()));
            }
            case "generativeField": {
                return Optional.ofNullable(clazz.cast(this.generativeField()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("extraction", EXTRACTION_FIELD);
        map.put("generativeField", GENERATIVE_FIELD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VideoStandardOutputConfiguration, T> g) {
        return obj -> g.apply((VideoStandardOutputConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private VideoStandardExtraction extraction;
        private VideoStandardGenerativeField generativeField;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoStandardOutputConfiguration model) {
            this.extraction(model.extraction);
            this.generativeField(model.generativeField);
        }

        public final VideoStandardExtraction.Builder getExtraction() {
            return this.extraction != null ? this.extraction.toBuilder() : null;
        }

        public final void setExtraction(VideoStandardExtraction.BuilderImpl extraction) {
            this.extraction = extraction != null ? extraction.build() : null;
        }

        @Override
        public final Builder extraction(VideoStandardExtraction extraction) {
            this.extraction = extraction;
            return this;
        }

        public final VideoStandardGenerativeField.Builder getGenerativeField() {
            return this.generativeField != null ? this.generativeField.toBuilder() : null;
        }

        public final void setGenerativeField(VideoStandardGenerativeField.BuilderImpl generativeField) {
            this.generativeField = generativeField != null ? generativeField.build() : null;
        }

        @Override
        public final Builder generativeField(VideoStandardGenerativeField generativeField) {
            this.generativeField = generativeField;
            return this;
        }

        public VideoStandardOutputConfiguration build() {
            return new VideoStandardOutputConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VideoStandardOutputConfiguration> {
        public Builder extraction(VideoStandardExtraction var1);

        default public Builder extraction(Consumer<VideoStandardExtraction.Builder> extraction) {
            return this.extraction((VideoStandardExtraction)((VideoStandardExtraction.Builder)VideoStandardExtraction.builder().applyMutation(extraction)).build());
        }

        public Builder generativeField(VideoStandardGenerativeField var1);

        default public Builder generativeField(Consumer<VideoStandardGenerativeField.Builder> generativeField) {
            return this.generativeField((VideoStandardGenerativeField)((VideoStandardGenerativeField.Builder)VideoStandardGenerativeField.builder().applyMutation(generativeField)).build());
        }
    }
}

