/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockdataautomation.model.DesiredModality;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModalityRoutingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModalityRoutingConfiguration> {
    private static final SdkField<String> JPEG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jpeg").getter(ModalityRoutingConfiguration.getter(ModalityRoutingConfiguration::jpegAsString)).setter(ModalityRoutingConfiguration.setter(Builder::jpeg)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jpeg").build()}).build();
    private static final SdkField<String> PNG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("png").getter(ModalityRoutingConfiguration.getter(ModalityRoutingConfiguration::pngAsString)).setter(ModalityRoutingConfiguration.setter(Builder::png)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("png").build()}).build();
    private static final SdkField<String> MP4_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mp4").getter(ModalityRoutingConfiguration.getter(ModalityRoutingConfiguration::mp4AsString)).setter(ModalityRoutingConfiguration.setter(Builder::mp4)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mp4").build()}).build();
    private static final SdkField<String> MOV_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mov").getter(ModalityRoutingConfiguration.getter(ModalityRoutingConfiguration::movAsString)).setter(ModalityRoutingConfiguration.setter(Builder::mov)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mov").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JPEG_FIELD, PNG_FIELD, MP4_FIELD, MOV_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModalityRoutingConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String jpeg;
    private final String png;
    private final String mp4;
    private final String mov;

    private ModalityRoutingConfiguration(BuilderImpl builder) {
        this.jpeg = builder.jpeg;
        this.png = builder.png;
        this.mp4 = builder.mp4;
        this.mov = builder.mov;
    }

    public final DesiredModality jpeg() {
        return DesiredModality.fromValue(this.jpeg);
    }

    public final String jpegAsString() {
        return this.jpeg;
    }

    public final DesiredModality png() {
        return DesiredModality.fromValue(this.png);
    }

    public final String pngAsString() {
        return this.png;
    }

    public final DesiredModality mp4() {
        return DesiredModality.fromValue(this.mp4);
    }

    public final String mp4AsString() {
        return this.mp4;
    }

    public final DesiredModality mov() {
        return DesiredModality.fromValue(this.mov);
    }

    public final String movAsString() {
        return this.mov;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jpegAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.pngAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mp4AsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.movAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModalityRoutingConfiguration)) {
            return false;
        }
        ModalityRoutingConfiguration other = (ModalityRoutingConfiguration)obj;
        return Objects.equals(this.jpegAsString(), other.jpegAsString()) && Objects.equals(this.pngAsString(), other.pngAsString()) && Objects.equals(this.mp4AsString(), other.mp4AsString()) && Objects.equals(this.movAsString(), other.movAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ModalityRoutingConfiguration").add("Jpeg", (Object)this.jpegAsString()).add("Png", (Object)this.pngAsString()).add("Mp4", (Object)this.mp4AsString()).add("Mov", (Object)this.movAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jpeg": {
                return Optional.ofNullable(clazz.cast(this.jpegAsString()));
            }
            case "png": {
                return Optional.ofNullable(clazz.cast(this.pngAsString()));
            }
            case "mp4": {
                return Optional.ofNullable(clazz.cast(this.mp4AsString()));
            }
            case "mov": {
                return Optional.ofNullable(clazz.cast(this.movAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("jpeg", JPEG_FIELD);
        map.put("png", PNG_FIELD);
        map.put("mp4", MP4_FIELD);
        map.put("mov", MOV_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModalityRoutingConfiguration, T> g) {
        return obj -> g.apply((ModalityRoutingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jpeg;
        private String png;
        private String mp4;
        private String mov;

        private BuilderImpl() {
        }

        private BuilderImpl(ModalityRoutingConfiguration model) {
            this.jpeg(model.jpeg);
            this.png(model.png);
            this.mp4(model.mp4);
            this.mov(model.mov);
        }

        public final String getJpeg() {
            return this.jpeg;
        }

        public final void setJpeg(String jpeg) {
            this.jpeg = jpeg;
        }

        @Override
        public final Builder jpeg(String jpeg) {
            this.jpeg = jpeg;
            return this;
        }

        @Override
        public final Builder jpeg(DesiredModality jpeg) {
            this.jpeg(jpeg == null ? null : jpeg.toString());
            return this;
        }

        public final String getPng() {
            return this.png;
        }

        public final void setPng(String png) {
            this.png = png;
        }

        @Override
        public final Builder png(String png) {
            this.png = png;
            return this;
        }

        @Override
        public final Builder png(DesiredModality png) {
            this.png(png == null ? null : png.toString());
            return this;
        }

        public final String getMp4() {
            return this.mp4;
        }

        public final void setMp4(String mp4) {
            this.mp4 = mp4;
        }

        @Override
        public final Builder mp4(String mp4) {
            this.mp4 = mp4;
            return this;
        }

        @Override
        public final Builder mp4(DesiredModality mp4) {
            this.mp4(mp4 == null ? null : mp4.toString());
            return this;
        }

        public final String getMov() {
            return this.mov;
        }

        public final void setMov(String mov) {
            this.mov = mov;
        }

        @Override
        public final Builder mov(String mov) {
            this.mov = mov;
            return this;
        }

        @Override
        public final Builder mov(DesiredModality mov) {
            this.mov(mov == null ? null : mov.toString());
            return this;
        }

        public ModalityRoutingConfiguration build() {
            return new ModalityRoutingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModalityRoutingConfiguration> {
        public Builder jpeg(String var1);

        public Builder jpeg(DesiredModality var1);

        public Builder png(String var1);

        public Builder png(DesiredModality var1);

        public Builder mp4(String var1);

        public Builder mp4(DesiredModality var1);

        public Builder mov(String var1);

        public Builder mov(DesiredModality var1);
    }
}

