/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ExecutionType {
    LAMBDA("LAMBDA"),
    RETURN_CONTROL("RETURN_CONTROL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExecutionType> VALUE_MAP;
    private final String value;

    private ExecutionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExecutionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExecutionType> knownValues() {
        EnumSet<ExecutionType> knownValues = EnumSet.allOf(ExecutionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ExecutionType.class, ExecutionType::toString);
    }
}

