/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentruntime.BedrockAgentRuntimeAsyncClient;
import software.amazon.awssdk.services.bedrockagentruntime.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentruntime.model.InvocationSummary;
import software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationsRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationsResponse;

public class ListInvocationsPublisher
implements SdkPublisher<ListInvocationsResponse> {
    private final BedrockAgentRuntimeAsyncClient client;
    private final ListInvocationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListInvocationsPublisher(BedrockAgentRuntimeAsyncClient client, ListInvocationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListInvocationsPublisher(BedrockAgentRuntimeAsyncClient client, ListInvocationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListInvocationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListInvocationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<InvocationSummary> invocationSummaries() {
        return this.flatMapIterable(response -> response.invocationSummaries());
    }

    private class ListInvocationsResponseFetcher
    implements AsyncPageFetcher<ListInvocationsResponse> {
        private ListInvocationsResponseFetcher() {
        }

        public boolean hasNextPage(ListInvocationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListInvocationsResponse> nextPage(ListInvocationsResponse previousPage) {
            if (previousPage == null) {
                return ListInvocationsPublisher.this.client.listInvocations(ListInvocationsPublisher.this.firstRequest);
            }
            return ListInvocationsPublisher.this.client.listInvocations((ListInvocationsRequest)((Object)ListInvocationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

