/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentruntime.model.RerankQueryContentType;
import software.amazon.awssdk.services.bedrockagentruntime.model.RerankTextDocument;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RerankQuery
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RerankQuery> {
    private static final SdkField<RerankTextDocument> TEXT_QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("textQuery").getter(RerankQuery.getter(RerankQuery::textQuery)).setter(RerankQuery.setter(Builder::textQuery)).constructor(RerankTextDocument::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("textQuery").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(RerankQuery.getter(RerankQuery::typeAsString)).setter(RerankQuery.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_QUERY_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RerankQuery.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final RerankTextDocument textQuery;
    private final String type;

    private RerankQuery(BuilderImpl builder) {
        this.textQuery = builder.textQuery;
        this.type = builder.type;
    }

    public final RerankTextDocument textQuery() {
        return this.textQuery;
    }

    public final RerankQueryContentType type() {
        return RerankQueryContentType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.textQuery());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RerankQuery)) {
            return false;
        }
        RerankQuery other = (RerankQuery)obj;
        return Objects.equals(this.textQuery(), other.textQuery()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RerankQuery").add("TextQuery", (Object)(this.textQuery() == null ? null : "*** Sensitive Data Redacted ***")).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "textQuery": {
                return Optional.ofNullable(clazz.cast(this.textQuery()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("textQuery", TEXT_QUERY_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RerankQuery, T> g) {
        return obj -> g.apply((RerankQuery)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private RerankTextDocument textQuery;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(RerankQuery model) {
            this.textQuery(model.textQuery);
            this.type(model.type);
        }

        public final RerankTextDocument.Builder getTextQuery() {
            return this.textQuery != null ? this.textQuery.toBuilder() : null;
        }

        public final void setTextQuery(RerankTextDocument.BuilderImpl textQuery) {
            this.textQuery = textQuery != null ? textQuery.build() : null;
        }

        @Override
        public final Builder textQuery(RerankTextDocument textQuery) {
            this.textQuery = textQuery;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RerankQueryContentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public RerankQuery build() {
            return new RerankQuery(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RerankQuery> {
        public Builder textQuery(RerankTextDocument var1);

        default public Builder textQuery(Consumer<RerankTextDocument.Builder> textQuery) {
            return this.textQuery((RerankTextDocument)((RerankTextDocument.Builder)RerankTextDocument.builder().applyMutation(textQuery)).build());
        }

        public Builder type(String var1);

        public Builder type(RerankQueryContentType var1);
    }
}

