/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagentruntime.model.ConditionResultEvent;
import software.amazon.awssdk.services.bedrockagentruntime.model.FlowExecutionInputEvent;
import software.amazon.awssdk.services.bedrockagentruntime.model.FlowExecutionOutputEvent;
import software.amazon.awssdk.services.bedrockagentruntime.model.FlowFailureEvent;
import software.amazon.awssdk.services.bedrockagentruntime.model.NodeActionEvent;
import software.amazon.awssdk.services.bedrockagentruntime.model.NodeDependencyEvent;
import software.amazon.awssdk.services.bedrockagentruntime.model.NodeFailureEvent;
import software.amazon.awssdk.services.bedrockagentruntime.model.NodeInputEvent;
import software.amazon.awssdk.services.bedrockagentruntime.model.NodeOutputEvent;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FlowExecutionEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FlowExecutionEvent> {
    private static final SdkField<ConditionResultEvent> CONDITION_RESULT_EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("conditionResultEvent").getter(FlowExecutionEvent.getter(FlowExecutionEvent::conditionResultEvent)).setter(FlowExecutionEvent.setter(Builder::conditionResultEvent)).constructor(ConditionResultEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conditionResultEvent").build()}).build();
    private static final SdkField<FlowFailureEvent> FLOW_FAILURE_EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("flowFailureEvent").getter(FlowExecutionEvent.getter(FlowExecutionEvent::flowFailureEvent)).setter(FlowExecutionEvent.setter(Builder::flowFailureEvent)).constructor(FlowFailureEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowFailureEvent").build()}).build();
    private static final SdkField<FlowExecutionInputEvent> FLOW_INPUT_EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("flowInputEvent").getter(FlowExecutionEvent.getter(FlowExecutionEvent::flowInputEvent)).setter(FlowExecutionEvent.setter(Builder::flowInputEvent)).constructor(FlowExecutionInputEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowInputEvent").build()}).build();
    private static final SdkField<FlowExecutionOutputEvent> FLOW_OUTPUT_EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("flowOutputEvent").getter(FlowExecutionEvent.getter(FlowExecutionEvent::flowOutputEvent)).setter(FlowExecutionEvent.setter(Builder::flowOutputEvent)).constructor(FlowExecutionOutputEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowOutputEvent").build()}).build();
    private static final SdkField<NodeActionEvent> NODE_ACTION_EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("nodeActionEvent").getter(FlowExecutionEvent.getter(FlowExecutionEvent::nodeActionEvent)).setter(FlowExecutionEvent.setter(Builder::nodeActionEvent)).constructor(NodeActionEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeActionEvent").build()}).build();
    private static final SdkField<NodeDependencyEvent> NODE_DEPENDENCY_EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("nodeDependencyEvent").getter(FlowExecutionEvent.getter(FlowExecutionEvent::nodeDependencyEvent)).setter(FlowExecutionEvent.setter(Builder::nodeDependencyEvent)).constructor(NodeDependencyEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeDependencyEvent").build()}).build();
    private static final SdkField<NodeFailureEvent> NODE_FAILURE_EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("nodeFailureEvent").getter(FlowExecutionEvent.getter(FlowExecutionEvent::nodeFailureEvent)).setter(FlowExecutionEvent.setter(Builder::nodeFailureEvent)).constructor(NodeFailureEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeFailureEvent").build()}).build();
    private static final SdkField<NodeInputEvent> NODE_INPUT_EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("nodeInputEvent").getter(FlowExecutionEvent.getter(FlowExecutionEvent::nodeInputEvent)).setter(FlowExecutionEvent.setter(Builder::nodeInputEvent)).constructor(NodeInputEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeInputEvent").build()}).build();
    private static final SdkField<NodeOutputEvent> NODE_OUTPUT_EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("nodeOutputEvent").getter(FlowExecutionEvent.getter(FlowExecutionEvent::nodeOutputEvent)).setter(FlowExecutionEvent.setter(Builder::nodeOutputEvent)).constructor(NodeOutputEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeOutputEvent").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONDITION_RESULT_EVENT_FIELD, FLOW_FAILURE_EVENT_FIELD, FLOW_INPUT_EVENT_FIELD, FLOW_OUTPUT_EVENT_FIELD, NODE_ACTION_EVENT_FIELD, NODE_DEPENDENCY_EVENT_FIELD, NODE_FAILURE_EVENT_FIELD, NODE_INPUT_EVENT_FIELD, NODE_OUTPUT_EVENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FlowExecutionEvent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ConditionResultEvent conditionResultEvent;
    private final FlowFailureEvent flowFailureEvent;
    private final FlowExecutionInputEvent flowInputEvent;
    private final FlowExecutionOutputEvent flowOutputEvent;
    private final NodeActionEvent nodeActionEvent;
    private final NodeDependencyEvent nodeDependencyEvent;
    private final NodeFailureEvent nodeFailureEvent;
    private final NodeInputEvent nodeInputEvent;
    private final NodeOutputEvent nodeOutputEvent;
    private final Type type;

    private FlowExecutionEvent(BuilderImpl builder) {
        this.conditionResultEvent = builder.conditionResultEvent;
        this.flowFailureEvent = builder.flowFailureEvent;
        this.flowInputEvent = builder.flowInputEvent;
        this.flowOutputEvent = builder.flowOutputEvent;
        this.nodeActionEvent = builder.nodeActionEvent;
        this.nodeDependencyEvent = builder.nodeDependencyEvent;
        this.nodeFailureEvent = builder.nodeFailureEvent;
        this.nodeInputEvent = builder.nodeInputEvent;
        this.nodeOutputEvent = builder.nodeOutputEvent;
        this.type = builder.type;
    }

    public final ConditionResultEvent conditionResultEvent() {
        return this.conditionResultEvent;
    }

    public final FlowFailureEvent flowFailureEvent() {
        return this.flowFailureEvent;
    }

    public final FlowExecutionInputEvent flowInputEvent() {
        return this.flowInputEvent;
    }

    public final FlowExecutionOutputEvent flowOutputEvent() {
        return this.flowOutputEvent;
    }

    public final NodeActionEvent nodeActionEvent() {
        return this.nodeActionEvent;
    }

    public final NodeDependencyEvent nodeDependencyEvent() {
        return this.nodeDependencyEvent;
    }

    public final NodeFailureEvent nodeFailureEvent() {
        return this.nodeFailureEvent;
    }

    public final NodeInputEvent nodeInputEvent() {
        return this.nodeInputEvent;
    }

    public final NodeOutputEvent nodeOutputEvent() {
        return this.nodeOutputEvent;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.conditionResultEvent());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowFailureEvent());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowInputEvent());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowOutputEvent());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeActionEvent());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeDependencyEvent());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeFailureEvent());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeInputEvent());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeOutputEvent());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowExecutionEvent)) {
            return false;
        }
        FlowExecutionEvent other = (FlowExecutionEvent)obj;
        return Objects.equals(this.conditionResultEvent(), other.conditionResultEvent()) && Objects.equals(this.flowFailureEvent(), other.flowFailureEvent()) && Objects.equals(this.flowInputEvent(), other.flowInputEvent()) && Objects.equals(this.flowOutputEvent(), other.flowOutputEvent()) && Objects.equals(this.nodeActionEvent(), other.nodeActionEvent()) && Objects.equals(this.nodeDependencyEvent(), other.nodeDependencyEvent()) && Objects.equals(this.nodeFailureEvent(), other.nodeFailureEvent()) && Objects.equals(this.nodeInputEvent(), other.nodeInputEvent()) && Objects.equals(this.nodeOutputEvent(), other.nodeOutputEvent());
    }

    public final String toString() {
        return ToString.builder((String)"FlowExecutionEvent").add("ConditionResultEvent", (Object)(this.conditionResultEvent() == null ? null : "*** Sensitive Data Redacted ***")).add("FlowFailureEvent", (Object)(this.flowFailureEvent() == null ? null : "*** Sensitive Data Redacted ***")).add("FlowInputEvent", (Object)(this.flowInputEvent() == null ? null : "*** Sensitive Data Redacted ***")).add("FlowOutputEvent", (Object)(this.flowOutputEvent() == null ? null : "*** Sensitive Data Redacted ***")).add("NodeActionEvent", (Object)(this.nodeActionEvent() == null ? null : "*** Sensitive Data Redacted ***")).add("NodeDependencyEvent", (Object)(this.nodeDependencyEvent() == null ? null : "*** Sensitive Data Redacted ***")).add("NodeFailureEvent", (Object)(this.nodeFailureEvent() == null ? null : "*** Sensitive Data Redacted ***")).add("NodeInputEvent", (Object)(this.nodeInputEvent() == null ? null : "*** Sensitive Data Redacted ***")).add("NodeOutputEvent", (Object)(this.nodeOutputEvent() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "conditionResultEvent": {
                return Optional.ofNullable(clazz.cast(this.conditionResultEvent()));
            }
            case "flowFailureEvent": {
                return Optional.ofNullable(clazz.cast(this.flowFailureEvent()));
            }
            case "flowInputEvent": {
                return Optional.ofNullable(clazz.cast(this.flowInputEvent()));
            }
            case "flowOutputEvent": {
                return Optional.ofNullable(clazz.cast(this.flowOutputEvent()));
            }
            case "nodeActionEvent": {
                return Optional.ofNullable(clazz.cast(this.nodeActionEvent()));
            }
            case "nodeDependencyEvent": {
                return Optional.ofNullable(clazz.cast(this.nodeDependencyEvent()));
            }
            case "nodeFailureEvent": {
                return Optional.ofNullable(clazz.cast(this.nodeFailureEvent()));
            }
            case "nodeInputEvent": {
                return Optional.ofNullable(clazz.cast(this.nodeInputEvent()));
            }
            case "nodeOutputEvent": {
                return Optional.ofNullable(clazz.cast(this.nodeOutputEvent()));
            }
        }
        return Optional.empty();
    }

    public static FlowExecutionEvent fromConditionResultEvent(ConditionResultEvent conditionResultEvent) {
        return (FlowExecutionEvent)FlowExecutionEvent.builder().conditionResultEvent(conditionResultEvent).build();
    }

    public static FlowExecutionEvent fromConditionResultEvent(Consumer<ConditionResultEvent.Builder> conditionResultEvent) {
        ConditionResultEvent.Builder builder = ConditionResultEvent.builder();
        conditionResultEvent.accept(builder);
        return FlowExecutionEvent.fromConditionResultEvent((ConditionResultEvent)builder.build());
    }

    public static FlowExecutionEvent fromFlowFailureEvent(FlowFailureEvent flowFailureEvent) {
        return (FlowExecutionEvent)FlowExecutionEvent.builder().flowFailureEvent(flowFailureEvent).build();
    }

    public static FlowExecutionEvent fromFlowFailureEvent(Consumer<FlowFailureEvent.Builder> flowFailureEvent) {
        FlowFailureEvent.Builder builder = FlowFailureEvent.builder();
        flowFailureEvent.accept(builder);
        return FlowExecutionEvent.fromFlowFailureEvent((FlowFailureEvent)builder.build());
    }

    public static FlowExecutionEvent fromFlowInputEvent(FlowExecutionInputEvent flowInputEvent) {
        return (FlowExecutionEvent)FlowExecutionEvent.builder().flowInputEvent(flowInputEvent).build();
    }

    public static FlowExecutionEvent fromFlowInputEvent(Consumer<FlowExecutionInputEvent.Builder> flowInputEvent) {
        FlowExecutionInputEvent.Builder builder = FlowExecutionInputEvent.builder();
        flowInputEvent.accept(builder);
        return FlowExecutionEvent.fromFlowInputEvent((FlowExecutionInputEvent)builder.build());
    }

    public static FlowExecutionEvent fromFlowOutputEvent(FlowExecutionOutputEvent flowOutputEvent) {
        return (FlowExecutionEvent)FlowExecutionEvent.builder().flowOutputEvent(flowOutputEvent).build();
    }

    public static FlowExecutionEvent fromFlowOutputEvent(Consumer<FlowExecutionOutputEvent.Builder> flowOutputEvent) {
        FlowExecutionOutputEvent.Builder builder = FlowExecutionOutputEvent.builder();
        flowOutputEvent.accept(builder);
        return FlowExecutionEvent.fromFlowOutputEvent((FlowExecutionOutputEvent)builder.build());
    }

    public static FlowExecutionEvent fromNodeActionEvent(NodeActionEvent nodeActionEvent) {
        return (FlowExecutionEvent)FlowExecutionEvent.builder().nodeActionEvent(nodeActionEvent).build();
    }

    public static FlowExecutionEvent fromNodeActionEvent(Consumer<NodeActionEvent.Builder> nodeActionEvent) {
        NodeActionEvent.Builder builder = NodeActionEvent.builder();
        nodeActionEvent.accept(builder);
        return FlowExecutionEvent.fromNodeActionEvent((NodeActionEvent)builder.build());
    }

    public static FlowExecutionEvent fromNodeDependencyEvent(NodeDependencyEvent nodeDependencyEvent) {
        return (FlowExecutionEvent)FlowExecutionEvent.builder().nodeDependencyEvent(nodeDependencyEvent).build();
    }

    public static FlowExecutionEvent fromNodeDependencyEvent(Consumer<NodeDependencyEvent.Builder> nodeDependencyEvent) {
        NodeDependencyEvent.Builder builder = NodeDependencyEvent.builder();
        nodeDependencyEvent.accept(builder);
        return FlowExecutionEvent.fromNodeDependencyEvent((NodeDependencyEvent)builder.build());
    }

    public static FlowExecutionEvent fromNodeFailureEvent(NodeFailureEvent nodeFailureEvent) {
        return (FlowExecutionEvent)FlowExecutionEvent.builder().nodeFailureEvent(nodeFailureEvent).build();
    }

    public static FlowExecutionEvent fromNodeFailureEvent(Consumer<NodeFailureEvent.Builder> nodeFailureEvent) {
        NodeFailureEvent.Builder builder = NodeFailureEvent.builder();
        nodeFailureEvent.accept(builder);
        return FlowExecutionEvent.fromNodeFailureEvent((NodeFailureEvent)builder.build());
    }

    public static FlowExecutionEvent fromNodeInputEvent(NodeInputEvent nodeInputEvent) {
        return (FlowExecutionEvent)FlowExecutionEvent.builder().nodeInputEvent(nodeInputEvent).build();
    }

    public static FlowExecutionEvent fromNodeInputEvent(Consumer<NodeInputEvent.Builder> nodeInputEvent) {
        NodeInputEvent.Builder builder = NodeInputEvent.builder();
        nodeInputEvent.accept(builder);
        return FlowExecutionEvent.fromNodeInputEvent((NodeInputEvent)builder.build());
    }

    public static FlowExecutionEvent fromNodeOutputEvent(NodeOutputEvent nodeOutputEvent) {
        return (FlowExecutionEvent)FlowExecutionEvent.builder().nodeOutputEvent(nodeOutputEvent).build();
    }

    public static FlowExecutionEvent fromNodeOutputEvent(Consumer<NodeOutputEvent.Builder> nodeOutputEvent) {
        NodeOutputEvent.Builder builder = NodeOutputEvent.builder();
        nodeOutputEvent.accept(builder);
        return FlowExecutionEvent.fromNodeOutputEvent((NodeOutputEvent)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("conditionResultEvent", CONDITION_RESULT_EVENT_FIELD);
        map.put("flowFailureEvent", FLOW_FAILURE_EVENT_FIELD);
        map.put("flowInputEvent", FLOW_INPUT_EVENT_FIELD);
        map.put("flowOutputEvent", FLOW_OUTPUT_EVENT_FIELD);
        map.put("nodeActionEvent", NODE_ACTION_EVENT_FIELD);
        map.put("nodeDependencyEvent", NODE_DEPENDENCY_EVENT_FIELD);
        map.put("nodeFailureEvent", NODE_FAILURE_EVENT_FIELD);
        map.put("nodeInputEvent", NODE_INPUT_EVENT_FIELD);
        map.put("nodeOutputEvent", NODE_OUTPUT_EVENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlowExecutionEvent, T> g) {
        return obj -> g.apply((FlowExecutionEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        CONDITION_RESULT_EVENT,
        FLOW_FAILURE_EVENT,
        FLOW_INPUT_EVENT,
        FLOW_OUTPUT_EVENT,
        NODE_ACTION_EVENT,
        NODE_DEPENDENCY_EVENT,
        NODE_FAILURE_EVENT,
        NODE_INPUT_EVENT,
        NODE_OUTPUT_EVENT,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private ConditionResultEvent conditionResultEvent;
        private FlowFailureEvent flowFailureEvent;
        private FlowExecutionInputEvent flowInputEvent;
        private FlowExecutionOutputEvent flowOutputEvent;
        private NodeActionEvent nodeActionEvent;
        private NodeDependencyEvent nodeDependencyEvent;
        private NodeFailureEvent nodeFailureEvent;
        private NodeInputEvent nodeInputEvent;
        private NodeOutputEvent nodeOutputEvent;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(FlowExecutionEvent model) {
            this.conditionResultEvent(model.conditionResultEvent);
            this.flowFailureEvent(model.flowFailureEvent);
            this.flowInputEvent(model.flowInputEvent);
            this.flowOutputEvent(model.flowOutputEvent);
            this.nodeActionEvent(model.nodeActionEvent);
            this.nodeDependencyEvent(model.nodeDependencyEvent);
            this.nodeFailureEvent(model.nodeFailureEvent);
            this.nodeInputEvent(model.nodeInputEvent);
            this.nodeOutputEvent(model.nodeOutputEvent);
        }

        public final ConditionResultEvent.Builder getConditionResultEvent() {
            return this.conditionResultEvent != null ? this.conditionResultEvent.toBuilder() : null;
        }

        public final void setConditionResultEvent(ConditionResultEvent.BuilderImpl conditionResultEvent) {
            ConditionResultEvent oldValue = this.conditionResultEvent;
            this.conditionResultEvent = conditionResultEvent != null ? conditionResultEvent.build() : null;
            this.handleUnionValueChange(Type.CONDITION_RESULT_EVENT, oldValue, this.conditionResultEvent);
        }

        @Override
        public final Builder conditionResultEvent(ConditionResultEvent conditionResultEvent) {
            ConditionResultEvent oldValue = this.conditionResultEvent;
            this.conditionResultEvent = conditionResultEvent;
            this.handleUnionValueChange(Type.CONDITION_RESULT_EVENT, oldValue, this.conditionResultEvent);
            return this;
        }

        public final FlowFailureEvent.Builder getFlowFailureEvent() {
            return this.flowFailureEvent != null ? this.flowFailureEvent.toBuilder() : null;
        }

        public final void setFlowFailureEvent(FlowFailureEvent.BuilderImpl flowFailureEvent) {
            FlowFailureEvent oldValue = this.flowFailureEvent;
            this.flowFailureEvent = flowFailureEvent != null ? flowFailureEvent.build() : null;
            this.handleUnionValueChange(Type.FLOW_FAILURE_EVENT, oldValue, this.flowFailureEvent);
        }

        @Override
        public final Builder flowFailureEvent(FlowFailureEvent flowFailureEvent) {
            FlowFailureEvent oldValue = this.flowFailureEvent;
            this.flowFailureEvent = flowFailureEvent;
            this.handleUnionValueChange(Type.FLOW_FAILURE_EVENT, oldValue, this.flowFailureEvent);
            return this;
        }

        public final FlowExecutionInputEvent.Builder getFlowInputEvent() {
            return this.flowInputEvent != null ? this.flowInputEvent.toBuilder() : null;
        }

        public final void setFlowInputEvent(FlowExecutionInputEvent.BuilderImpl flowInputEvent) {
            FlowExecutionInputEvent oldValue = this.flowInputEvent;
            this.flowInputEvent = flowInputEvent != null ? flowInputEvent.build() : null;
            this.handleUnionValueChange(Type.FLOW_INPUT_EVENT, oldValue, this.flowInputEvent);
        }

        @Override
        public final Builder flowInputEvent(FlowExecutionInputEvent flowInputEvent) {
            FlowExecutionInputEvent oldValue = this.flowInputEvent;
            this.flowInputEvent = flowInputEvent;
            this.handleUnionValueChange(Type.FLOW_INPUT_EVENT, oldValue, this.flowInputEvent);
            return this;
        }

        public final FlowExecutionOutputEvent.Builder getFlowOutputEvent() {
            return this.flowOutputEvent != null ? this.flowOutputEvent.toBuilder() : null;
        }

        public final void setFlowOutputEvent(FlowExecutionOutputEvent.BuilderImpl flowOutputEvent) {
            FlowExecutionOutputEvent oldValue = this.flowOutputEvent;
            this.flowOutputEvent = flowOutputEvent != null ? flowOutputEvent.build() : null;
            this.handleUnionValueChange(Type.FLOW_OUTPUT_EVENT, oldValue, this.flowOutputEvent);
        }

        @Override
        public final Builder flowOutputEvent(FlowExecutionOutputEvent flowOutputEvent) {
            FlowExecutionOutputEvent oldValue = this.flowOutputEvent;
            this.flowOutputEvent = flowOutputEvent;
            this.handleUnionValueChange(Type.FLOW_OUTPUT_EVENT, oldValue, this.flowOutputEvent);
            return this;
        }

        public final NodeActionEvent.Builder getNodeActionEvent() {
            return this.nodeActionEvent != null ? this.nodeActionEvent.toBuilder() : null;
        }

        public final void setNodeActionEvent(NodeActionEvent.BuilderImpl nodeActionEvent) {
            NodeActionEvent oldValue = this.nodeActionEvent;
            this.nodeActionEvent = nodeActionEvent != null ? nodeActionEvent.build() : null;
            this.handleUnionValueChange(Type.NODE_ACTION_EVENT, oldValue, this.nodeActionEvent);
        }

        @Override
        public final Builder nodeActionEvent(NodeActionEvent nodeActionEvent) {
            NodeActionEvent oldValue = this.nodeActionEvent;
            this.nodeActionEvent = nodeActionEvent;
            this.handleUnionValueChange(Type.NODE_ACTION_EVENT, oldValue, this.nodeActionEvent);
            return this;
        }

        public final NodeDependencyEvent.Builder getNodeDependencyEvent() {
            return this.nodeDependencyEvent != null ? this.nodeDependencyEvent.toBuilder() : null;
        }

        public final void setNodeDependencyEvent(NodeDependencyEvent.BuilderImpl nodeDependencyEvent) {
            NodeDependencyEvent oldValue = this.nodeDependencyEvent;
            this.nodeDependencyEvent = nodeDependencyEvent != null ? nodeDependencyEvent.build() : null;
            this.handleUnionValueChange(Type.NODE_DEPENDENCY_EVENT, oldValue, this.nodeDependencyEvent);
        }

        @Override
        public final Builder nodeDependencyEvent(NodeDependencyEvent nodeDependencyEvent) {
            NodeDependencyEvent oldValue = this.nodeDependencyEvent;
            this.nodeDependencyEvent = nodeDependencyEvent;
            this.handleUnionValueChange(Type.NODE_DEPENDENCY_EVENT, oldValue, this.nodeDependencyEvent);
            return this;
        }

        public final NodeFailureEvent.Builder getNodeFailureEvent() {
            return this.nodeFailureEvent != null ? this.nodeFailureEvent.toBuilder() : null;
        }

        public final void setNodeFailureEvent(NodeFailureEvent.BuilderImpl nodeFailureEvent) {
            NodeFailureEvent oldValue = this.nodeFailureEvent;
            this.nodeFailureEvent = nodeFailureEvent != null ? nodeFailureEvent.build() : null;
            this.handleUnionValueChange(Type.NODE_FAILURE_EVENT, oldValue, this.nodeFailureEvent);
        }

        @Override
        public final Builder nodeFailureEvent(NodeFailureEvent nodeFailureEvent) {
            NodeFailureEvent oldValue = this.nodeFailureEvent;
            this.nodeFailureEvent = nodeFailureEvent;
            this.handleUnionValueChange(Type.NODE_FAILURE_EVENT, oldValue, this.nodeFailureEvent);
            return this;
        }

        public final NodeInputEvent.Builder getNodeInputEvent() {
            return this.nodeInputEvent != null ? this.nodeInputEvent.toBuilder() : null;
        }

        public final void setNodeInputEvent(NodeInputEvent.BuilderImpl nodeInputEvent) {
            NodeInputEvent oldValue = this.nodeInputEvent;
            this.nodeInputEvent = nodeInputEvent != null ? nodeInputEvent.build() : null;
            this.handleUnionValueChange(Type.NODE_INPUT_EVENT, oldValue, this.nodeInputEvent);
        }

        @Override
        public final Builder nodeInputEvent(NodeInputEvent nodeInputEvent) {
            NodeInputEvent oldValue = this.nodeInputEvent;
            this.nodeInputEvent = nodeInputEvent;
            this.handleUnionValueChange(Type.NODE_INPUT_EVENT, oldValue, this.nodeInputEvent);
            return this;
        }

        public final NodeOutputEvent.Builder getNodeOutputEvent() {
            return this.nodeOutputEvent != null ? this.nodeOutputEvent.toBuilder() : null;
        }

        public final void setNodeOutputEvent(NodeOutputEvent.BuilderImpl nodeOutputEvent) {
            NodeOutputEvent oldValue = this.nodeOutputEvent;
            this.nodeOutputEvent = nodeOutputEvent != null ? nodeOutputEvent.build() : null;
            this.handleUnionValueChange(Type.NODE_OUTPUT_EVENT, oldValue, this.nodeOutputEvent);
        }

        @Override
        public final Builder nodeOutputEvent(NodeOutputEvent nodeOutputEvent) {
            NodeOutputEvent oldValue = this.nodeOutputEvent;
            this.nodeOutputEvent = nodeOutputEvent;
            this.handleUnionValueChange(Type.NODE_OUTPUT_EVENT, oldValue, this.nodeOutputEvent);
            return this;
        }

        public FlowExecutionEvent build() {
            return new FlowExecutionEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FlowExecutionEvent> {
        public Builder conditionResultEvent(ConditionResultEvent var1);

        default public Builder conditionResultEvent(Consumer<ConditionResultEvent.Builder> conditionResultEvent) {
            return this.conditionResultEvent((ConditionResultEvent)((ConditionResultEvent.Builder)ConditionResultEvent.builder().applyMutation(conditionResultEvent)).build());
        }

        public Builder flowFailureEvent(FlowFailureEvent var1);

        default public Builder flowFailureEvent(Consumer<FlowFailureEvent.Builder> flowFailureEvent) {
            return this.flowFailureEvent((FlowFailureEvent)((FlowFailureEvent.Builder)FlowFailureEvent.builder().applyMutation(flowFailureEvent)).build());
        }

        public Builder flowInputEvent(FlowExecutionInputEvent var1);

        default public Builder flowInputEvent(Consumer<FlowExecutionInputEvent.Builder> flowInputEvent) {
            return this.flowInputEvent((FlowExecutionInputEvent)((FlowExecutionInputEvent.Builder)FlowExecutionInputEvent.builder().applyMutation(flowInputEvent)).build());
        }

        public Builder flowOutputEvent(FlowExecutionOutputEvent var1);

        default public Builder flowOutputEvent(Consumer<FlowExecutionOutputEvent.Builder> flowOutputEvent) {
            return this.flowOutputEvent((FlowExecutionOutputEvent)((FlowExecutionOutputEvent.Builder)FlowExecutionOutputEvent.builder().applyMutation(flowOutputEvent)).build());
        }

        public Builder nodeActionEvent(NodeActionEvent var1);

        default public Builder nodeActionEvent(Consumer<NodeActionEvent.Builder> nodeActionEvent) {
            return this.nodeActionEvent((NodeActionEvent)((NodeActionEvent.Builder)NodeActionEvent.builder().applyMutation(nodeActionEvent)).build());
        }

        public Builder nodeDependencyEvent(NodeDependencyEvent var1);

        default public Builder nodeDependencyEvent(Consumer<NodeDependencyEvent.Builder> nodeDependencyEvent) {
            return this.nodeDependencyEvent((NodeDependencyEvent)((NodeDependencyEvent.Builder)NodeDependencyEvent.builder().applyMutation(nodeDependencyEvent)).build());
        }

        public Builder nodeFailureEvent(NodeFailureEvent var1);

        default public Builder nodeFailureEvent(Consumer<NodeFailureEvent.Builder> nodeFailureEvent) {
            return this.nodeFailureEvent((NodeFailureEvent)((NodeFailureEvent.Builder)NodeFailureEvent.builder().applyMutation(nodeFailureEvent)).build());
        }

        public Builder nodeInputEvent(NodeInputEvent var1);

        default public Builder nodeInputEvent(Consumer<NodeInputEvent.Builder> nodeInputEvent) {
            return this.nodeInputEvent((NodeInputEvent)((NodeInputEvent.Builder)NodeInputEvent.builder().applyMutation(nodeInputEvent)).build());
        }

        public Builder nodeOutputEvent(NodeOutputEvent var1);

        default public Builder nodeOutputEvent(Consumer<NodeOutputEvent.Builder> nodeOutputEvent) {
            return this.nodeOutputEvent((NodeOutputEvent)((NodeOutputEvent.Builder)NodeOutputEvent.builder().applyMutation(nodeOutputEvent)).build());
        }
    }
}

