/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagentruntime.model.BedrockSessionContentBlock;
import software.amazon.awssdk.services.bedrockagentruntime.model.BedrockSessionContentBlocksCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvocationStepPayload
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InvocationStepPayload> {
    private static final SdkField<List<BedrockSessionContentBlock>> CONTENT_BLOCKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("contentBlocks").getter(InvocationStepPayload.getter(InvocationStepPayload::contentBlocks)).setter(InvocationStepPayload.setter(Builder::contentBlocks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentBlocks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BedrockSessionContentBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_BLOCKS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InvocationStepPayload.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<BedrockSessionContentBlock> contentBlocks;
    private final Type type;

    private InvocationStepPayload(BuilderImpl builder) {
        this.contentBlocks = builder.contentBlocks;
        this.type = builder.type;
    }

    public final boolean hasContentBlocks() {
        return this.contentBlocks != null && !(this.contentBlocks instanceof SdkAutoConstructList);
    }

    public final List<BedrockSessionContentBlock> contentBlocks() {
        return this.contentBlocks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContentBlocks() ? this.contentBlocks() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvocationStepPayload)) {
            return false;
        }
        InvocationStepPayload other = (InvocationStepPayload)obj;
        return this.hasContentBlocks() == other.hasContentBlocks() && Objects.equals(this.contentBlocks(), other.contentBlocks());
    }

    public final String toString() {
        return ToString.builder((String)"InvocationStepPayload").add("ContentBlocks", (Object)(this.contentBlocks() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "contentBlocks": {
                return Optional.ofNullable(clazz.cast(this.contentBlocks()));
            }
        }
        return Optional.empty();
    }

    public static InvocationStepPayload fromContentBlocks(List<BedrockSessionContentBlock> contentBlocks) {
        return (InvocationStepPayload)InvocationStepPayload.builder().contentBlocks(contentBlocks).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<BedrockSessionContentBlock>>> map = new HashMap<String, SdkField<List<BedrockSessionContentBlock>>>();
        map.put("contentBlocks", CONTENT_BLOCKS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvocationStepPayload, T> g) {
        return obj -> g.apply((InvocationStepPayload)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        CONTENT_BLOCKS,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private List<BedrockSessionContentBlock> contentBlocks = DefaultSdkAutoConstructList.getInstance();
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(InvocationStepPayload model) {
            this.contentBlocks(model.contentBlocks);
        }

        public final List<BedrockSessionContentBlock.Builder> getContentBlocks() {
            List<BedrockSessionContentBlock.Builder> result = BedrockSessionContentBlocksCopier.copyToBuilder(this.contentBlocks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContentBlocks(Collection<BedrockSessionContentBlock.BuilderImpl> contentBlocks) {
            List<BedrockSessionContentBlock> oldValue = this.contentBlocks;
            this.contentBlocks = BedrockSessionContentBlocksCopier.copyFromBuilder(contentBlocks);
            this.handleUnionValueChange(Type.CONTENT_BLOCKS, oldValue, this.contentBlocks);
        }

        @Override
        public final Builder contentBlocks(Collection<BedrockSessionContentBlock> contentBlocks) {
            List<BedrockSessionContentBlock> oldValue = this.contentBlocks;
            this.contentBlocks = BedrockSessionContentBlocksCopier.copy(contentBlocks);
            this.handleUnionValueChange(Type.CONTENT_BLOCKS, oldValue, this.contentBlocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contentBlocks(BedrockSessionContentBlock ... contentBlocks) {
            this.contentBlocks(Arrays.asList(contentBlocks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contentBlocks(Consumer<BedrockSessionContentBlock.Builder> ... contentBlocks) {
            this.contentBlocks(Stream.of(contentBlocks).map(c -> (BedrockSessionContentBlock)((BedrockSessionContentBlock.Builder)BedrockSessionContentBlock.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public InvocationStepPayload build() {
            return new InvocationStepPayload(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InvocationStepPayload> {
        public Builder contentBlocks(Collection<BedrockSessionContentBlock> var1);

        public Builder contentBlocks(BedrockSessionContentBlock ... var1);

        public Builder contentBlocks(Consumer<BedrockSessionContentBlock.Builder> ... var1);
    }
}

