/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentruntime.model.InputImageFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputImage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InputImage> {
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("format").getter(InputImage.getter(InputImage::formatAsString)).setter(InputImage.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()}).build();
    private static final SdkField<SdkBytes> INLINE_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("inlineContent").getter(InputImage.getter(InputImage::inlineContent)).setter(InputImage.setter(Builder::inlineContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inlineContent").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMAT_FIELD, INLINE_CONTENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InputImage.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String format;
    private final SdkBytes inlineContent;

    private InputImage(BuilderImpl builder) {
        this.format = builder.format;
        this.inlineContent = builder.inlineContent;
    }

    public final InputImageFormat format() {
        return InputImageFormat.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final SdkBytes inlineContent() {
        return this.inlineContent;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.inlineContent());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputImage)) {
            return false;
        }
        InputImage other = (InputImage)obj;
        return Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.inlineContent(), other.inlineContent());
    }

    public final String toString() {
        return ToString.builder((String)"InputImage").add("Format", (Object)this.formatAsString()).add("InlineContent", (Object)(this.inlineContent() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "inlineContent": {
                return Optional.ofNullable(clazz.cast(this.inlineContent()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("format", FORMAT_FIELD);
        map.put("inlineContent", INLINE_CONTENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InputImage, T> g) {
        return obj -> g.apply((InputImage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String format;
        private SdkBytes inlineContent;

        private BuilderImpl() {
        }

        private BuilderImpl(InputImage model) {
            this.format(model.format);
            this.inlineContent(model.inlineContent);
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(InputImageFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final ByteBuffer getInlineContent() {
            return this.inlineContent == null ? null : this.inlineContent.asByteBuffer();
        }

        public final void setInlineContent(ByteBuffer inlineContent) {
            this.inlineContent(inlineContent == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)inlineContent));
        }

        @Override
        public final Builder inlineContent(SdkBytes inlineContent) {
            this.inlineContent = inlineContent;
            return this;
        }

        public InputImage build() {
            return new InputImage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InputImage> {
        public Builder format(String var1);

        public Builder format(InputImageFormat var1);

        public Builder inlineContent(SdkBytes var1);
    }
}

