/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentruntime.BedrockAgentRuntimeClient;
import software.amazon.awssdk.services.bedrockagentruntime.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentruntime.model.InvocationStepSummary;
import software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationStepsRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationStepsResponse;

public class ListInvocationStepsIterable
implements SdkIterable<ListInvocationStepsResponse> {
    private final BedrockAgentRuntimeClient client;
    private final ListInvocationStepsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListInvocationStepsIterable(BedrockAgentRuntimeClient client, ListInvocationStepsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListInvocationStepsResponseFetcher();
    }

    public Iterator<ListInvocationStepsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<InvocationStepSummary> invocationStepSummaries() {
        Function<ListInvocationStepsResponse, Iterator> getIterator = response -> {
            if (response != null && response.invocationStepSummaries() != null) {
                return response.invocationStepSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListInvocationStepsResponseFetcher
    implements SyncPageFetcher<ListInvocationStepsResponse> {
        private ListInvocationStepsResponseFetcher() {
        }

        public boolean hasNextPage(ListInvocationStepsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListInvocationStepsResponse nextPage(ListInvocationStepsResponse previousPage) {
            if (previousPage == null) {
                return ListInvocationStepsIterable.this.client.listInvocationSteps(ListInvocationStepsIterable.this.firstRequest);
            }
            return ListInvocationStepsIterable.this.client.listInvocationSteps((ListInvocationStepsRequest)((Object)ListInvocationStepsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

