/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagentruntime.model.BedrockAgentRuntimeRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.SessionMetadataMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSessionRequest
extends BedrockAgentRuntimeRequest
implements ToCopyableBuilder<Builder, UpdateSessionRequest> {
    private static final SdkField<Map<String, String>> SESSION_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("sessionMetadata").getter(UpdateSessionRequest.getter(UpdateSessionRequest::sessionMetadata)).setter(UpdateSessionRequest.setter(Builder::sessionMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionMetadata").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> SESSION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionIdentifier").getter(UpdateSessionRequest.getter(UpdateSessionRequest::sessionIdentifier)).setter(UpdateSessionRequest.setter(Builder::sessionIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("sessionIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_METADATA_FIELD, SESSION_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateSessionRequest.memberNameToFieldInitializer();
    private final Map<String, String> sessionMetadata;
    private final String sessionIdentifier;

    private UpdateSessionRequest(BuilderImpl builder) {
        super(builder);
        this.sessionMetadata = builder.sessionMetadata;
        this.sessionIdentifier = builder.sessionIdentifier;
    }

    public final boolean hasSessionMetadata() {
        return this.sessionMetadata != null && !(this.sessionMetadata instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> sessionMetadata() {
        return this.sessionMetadata;
    }

    public final String sessionIdentifier() {
        return this.sessionIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSessionMetadata() ? this.sessionMetadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSessionRequest)) {
            return false;
        }
        UpdateSessionRequest other = (UpdateSessionRequest)((Object)obj);
        return this.hasSessionMetadata() == other.hasSessionMetadata() && Objects.equals(this.sessionMetadata(), other.sessionMetadata()) && Objects.equals(this.sessionIdentifier(), other.sessionIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSessionRequest").add("SessionMetadata", this.hasSessionMetadata() ? this.sessionMetadata() : null).add("SessionIdentifier", (Object)this.sessionIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sessionMetadata": {
                return Optional.ofNullable(clazz.cast(this.sessionMetadata()));
            }
            case "sessionIdentifier": {
                return Optional.ofNullable(clazz.cast(this.sessionIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sessionMetadata", SESSION_METADATA_FIELD);
        map.put("sessionIdentifier", SESSION_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSessionRequest, T> g) {
        return obj -> g.apply((UpdateSessionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRuntimeRequest.BuilderImpl
    implements Builder {
        private Map<String, String> sessionMetadata = DefaultSdkAutoConstructMap.getInstance();
        private String sessionIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSessionRequest model) {
            super(model);
            this.sessionMetadata(model.sessionMetadata);
            this.sessionIdentifier(model.sessionIdentifier);
        }

        public final Map<String, String> getSessionMetadata() {
            if (this.sessionMetadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.sessionMetadata;
        }

        public final void setSessionMetadata(Map<String, String> sessionMetadata) {
            this.sessionMetadata = SessionMetadataMapCopier.copy(sessionMetadata);
        }

        @Override
        public final Builder sessionMetadata(Map<String, String> sessionMetadata) {
            this.sessionMetadata = SessionMetadataMapCopier.copy(sessionMetadata);
            return this;
        }

        public final String getSessionIdentifier() {
            return this.sessionIdentifier;
        }

        public final void setSessionIdentifier(String sessionIdentifier) {
            this.sessionIdentifier = sessionIdentifier;
        }

        @Override
        public final Builder sessionIdentifier(String sessionIdentifier) {
            this.sessionIdentifier = sessionIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSessionRequest build() {
            return new UpdateSessionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentRuntimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSessionRequest> {
        public Builder sessionMetadata(Map<String, String> var1);

        public Builder sessionIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

